/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2023-03-22 08:28:14 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `p0aadmzbh8_WP_SEO_404_links` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `ctime` datetime NOT NULL,
  `link` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `referrer` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ip` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `country` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `os` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `browser` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `link` (`link`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `p0aadmzbh8_WP_SEO_Cache` (
  `ID` int unsigned NOT NULL,
  `is_redirected` int unsigned NOT NULL,
  `redirect_from` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redirect_to` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redirect_type` int unsigned NOT NULL DEFAULT '301',
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `p0aadmzbh8_WP_SEO_Redirection` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `enabled` int NOT NULL DEFAULT '1',
  `redirect_from` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redirect_from_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redirect_from_folder_settings` int NOT NULL,
  `redirect_from_subfolders` int NOT NULL DEFAULT '1',
  `redirect_to` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redirect_to_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redirect_to_folder_settings` int NOT NULL DEFAULT '1',
  `regex` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `redirect_type` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `url_type` int NOT NULL DEFAULT '1',
  `postID` int unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `redirect_from` (`redirect_from`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `p0aadmzbh8_WP_SEO_Redirection_LOG` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `rID` int unsigned DEFAULT NULL,
  `postID` int unsigned DEFAULT NULL,
  `ctime` datetime NOT NULL,
  `rfrom` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rto` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rtype` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `rsrc` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `referrer` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `ip` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `country` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `os` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  `browser` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_unicode_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `p0aadmzbh8_blc_filters` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_blc_instances` (
  `instance_id` int unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int unsigned NOT NULL,
  `container_id` int unsigned NOT NULL,
  `container_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `link_text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parser_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'link',
  `container_field` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_context` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `raw_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`instance_id`),
  KEY `link_id` (`link_id`),
  KEY `source_id` (`container_type`,`container_id`),
  KEY `parser_type` (`parser_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_blc_links` (
  `link_id` int unsigned NOT NULL AUTO_INCREMENT,
  `url` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `first_failure` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_success` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `check_count` int unsigned NOT NULL DEFAULT '0',
  `final_url` text CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL,
  `redirect_count` smallint unsigned NOT NULL DEFAULT '0',
  `log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `http_code` smallint NOT NULL DEFAULT '0',
  `status_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `status_text` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `request_duration` float NOT NULL DEFAULT '0',
  `timeout` tinyint unsigned NOT NULL DEFAULT '0',
  `broken` tinyint unsigned NOT NULL DEFAULT '0',
  `warning` tinyint unsigned NOT NULL DEFAULT '0',
  `may_recheck` tinyint(1) NOT NULL DEFAULT '1',
  `being_checked` tinyint(1) NOT NULL DEFAULT '0',
  `result_hash` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `false_positive` tinyint(1) NOT NULL DEFAULT '0',
  `dismissed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  KEY `url` (`url`(150)),
  KEY `final_url` (`final_url`(150)),
  KEY `http_code` (`http_code`),
  KEY `broken` (`broken`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_blc_synch` (
  `container_id` int unsigned NOT NULL,
  `container_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `synched` tinyint unsigned NOT NULL,
  `last_synch` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`container_type`,`container_id`),
  KEY `synched` (`synched`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_csp3_subscribers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int NOT NULL,
  `page_uuid` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `fname` varchar(255) DEFAULT NULL,
  `lname` varchar(255) DEFAULT NULL,
  `ref_url` varchar(255) DEFAULT NULL,
  `clicks` int NOT NULL DEFAULT '0',
  `conversions` int NOT NULL DEFAULT '0',
  `referrer` int NOT NULL DEFAULT '0',
  `confirmed` int NOT NULL DEFAULT '0',
  `optin_confirm` int NOT NULL DEFAULT '0',
  `ip` varchar(255) DEFAULT NULL,
  `meta` text,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `csp3_subscribers_page_uuid_idx` (`page_uuid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `p0aadmzbh8_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=latin1;

CREATE TABLE `p0aadmzbh8_eum_logs` (
  `log_id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version_from` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `stacktrace` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1361 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_ewwwio_images` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text,
  `image_md5` varchar(55) DEFAULT NULL,
  `results` varchar(75) NOT NULL,
  `gallery` varchar(10) DEFAULT NULL,
  `image_size` int unsigned DEFAULT NULL,
  `orig_size` int unsigned DEFAULT NULL,
  `updates` int unsigned DEFAULT NULL,
  `updated` timestamp NOT NULL DEFAULT '1971-01-01 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `trace` blob,
  `attachment_id` bigint unsigned DEFAULT NULL,
  `resize` varchar(75) DEFAULT NULL,
  `converted` mediumtext NOT NULL,
  `level` int unsigned DEFAULT NULL,
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `backup` varchar(100) DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `attachment_info` (`gallery`(3),`attachment_id`),
  KEY `path_image_size` (`path`(191),`image_size`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `p0aadmzbh8_itsec_bans` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `host` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'ip',
  `created_at` datetime NOT NULL,
  `actor_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `actor_id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `comment` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `host` (`host`),
  KEY `actor` (`actor_type`,`actor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_itsec_dashboard_events` (
  `event_id` int unsigned NOT NULL AUTO_INCREMENT,
  `event_slug` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `event_time` datetime NOT NULL,
  `event_count` int unsigned NOT NULL DEFAULT '1',
  `event_consolidated` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`event_id`),
  UNIQUE KEY `event_slug__time__consolidated` (`event_slug`,`event_time`,`event_consolidated`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_itsec_distributed_storage` (
  `storage_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `storage_group` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_key` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `storage_chunk` int NOT NULL DEFAULT '0',
  `storage_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `storage_updated` datetime NOT NULL,
  PRIMARY KEY (`storage_id`),
  UNIQUE KEY `storage_group__key__chunk` (`storage_group`,`storage_key`,`storage_chunk`)
) ENGINE=MyISAM AUTO_INCREMENT=135 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_itsec_fingerprints` (
  `fingerprint_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fingerprint_user` bigint unsigned NOT NULL,
  `fingerprint_hash` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_created_at` datetime NOT NULL,
  `fingerprint_approved_at` datetime NOT NULL,
  `fingerprint_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_snapshot` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_last_seen` datetime NOT NULL,
  `fingerprint_uses` int NOT NULL DEFAULT '0',
  `fingerprint_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fingerprint_uuid` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`fingerprint_id`),
  UNIQUE KEY `fingerprint_user__hash` (`fingerprint_user`,`fingerprint_hash`),
  UNIQUE KEY `fingerprint_uuid` (`fingerprint_uuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_itsec_geolocation_cache` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_host` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_lat` decimal(10,8) NOT NULL,
  `location_long` decimal(11,8) NOT NULL,
  `location_label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_credit` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_time` datetime NOT NULL,
  PRIMARY KEY (`location_id`),
  UNIQUE KEY `location_host` (`location_host`),
  KEY `location_time` (`location_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_itsec_lockouts` (
  `lockout_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(25) NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(40) DEFAULT NULL,
  `lockout_user` bigint unsigned DEFAULT NULL,
  `lockout_username` varchar(60) DEFAULT NULL,
  `lockout_active` int NOT NULL DEFAULT '1',
  `lockout_context` text,
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `p0aadmzbh8_itsec_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(20) NOT NULL DEFAULT '',
  `log_function` varchar(255) NOT NULL DEFAULT '',
  `log_priority` int NOT NULL DEFAULT '1',
  `log_date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `log_date_gmt` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `log_host` varchar(40) DEFAULT NULL,
  `log_username` varchar(60) DEFAULT NULL,
  `log_user` bigint unsigned DEFAULT NULL,
  `log_url` varchar(255) DEFAULT NULL,
  `log_referrer` varchar(255) DEFAULT NULL,
  `log_data` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `p0aadmzbh8_itsec_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `module` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'notice',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `init_timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `memory_current` bigint unsigned NOT NULL DEFAULT '0',
  `memory_peak` bigint unsigned NOT NULL DEFAULT '0',
  `url` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blog_id` bigint NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `remote_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `code` (`code`),
  KEY `type` (`type`),
  KEY `timestamp` (`timestamp`),
  KEY `user_id` (`user_id`),
  KEY `blog_id` (`blog_id`),
  KEY `init_timestamp` (`init_timestamp`)
) ENGINE=MyISAM AUTO_INCREMENT=1756 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_itsec_mutexes` (
  `mutex_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `mutex_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mutex_expires` int unsigned NOT NULL,
  PRIMARY KEY (`mutex_id`),
  UNIQUE KEY `mutex_name` (`mutex_name`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_itsec_opaque_tokens` (
  `token_id` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_hashed` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_data` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token_created_at` datetime NOT NULL,
  PRIMARY KEY (`token_id`),
  UNIQUE KEY `token_hashed` (`token_hashed`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_itsec_temp` (
  `temp_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(25) NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(40) DEFAULT NULL,
  `temp_user` bigint unsigned DEFAULT NULL,
  `temp_username` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `p0aadmzbh8_itsec_user_groups` (
  `group_id` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `group_label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `group_roles` text COLLATE utf8mb4_unicode_520_ci,
  `group_canonical` text COLLATE utf8mb4_unicode_520_ci,
  `group_users` text COLLATE utf8mb4_unicode_520_ci,
  `group_min_role` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `group_created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=28558 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_smush_dir_images` (
  `id` mediumint NOT NULL AUTO_INCREMENT,
  `path` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `resize` varchar(55) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int unsigned DEFAULT NULL,
  `orig_size` int unsigned DEFAULT NULL,
  `file_time` int unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `path_hash` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `p0aadmzbh8_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=96 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `p0aadmzbh8_wpfront_ure_login_redirect` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `deny_wpadmin` bit(1) DEFAULT NULL,
  `disable_toolbar` bit(1) DEFAULT NULL,
  `logout_url` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `priority` (`priority`),
  KEY `role` (`role`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_wpfront_ure_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `auto_load` tinyint DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `option_name` (`option_name`),
  KEY `auto_load` (`auto_load`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_wpfront_ure_post_type` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `label` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` int NOT NULL DEFAULT '1',
  `post_type_arg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `taxonomies` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `capability_type` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_wpfront_ure_taxonomy` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `label` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` int NOT NULL DEFAULT '1',
  `taxonomy_arg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `post_types` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `capability_type` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_yoast_migrations` (
  `version` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  UNIQUE KEY `idx_bfjx9x8i_yoast_migrations_version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `target_post_id` bigint unsigned NOT NULL,
  `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `p0aadmzbh8_yoast_seo_meta` (
  `object_id` bigint unsigned NOT NULL,
  `internal_link_count` int unsigned DEFAULT NULL,
  `incoming_link_count` int unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: p0aadmzbh8_WP_SEO_404_links */
INSERT INTO `p0aadmzbh8_WP_SEO_404_links` VALUES("1", "2016-05-31 17:49:10", "/getor", "", "91.116.224.53", "Spain", "Windows NT 4.0", "Firefox");

/* INSERT TABLE DATA: p0aadmzbh8_duplicator_packages */
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("17", "20150620_instalacionweb", "580077d729b319171161014061447", "100", "2016-10-14 06:14:55", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-10-14 06:14:47\";s:7:\"Version\";s:6:\"1.1.18\";s:9:\"VersionWP\";s:5:\"4.6.1\";s:9:\"VersionDB\";s:6:\"5.6.33\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:17;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:29:\"580077d729b319171161014061447\";s:8:\"NameHash\";s:53:\"20150620_instalacionweb_580077d729b319171161014061447\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150620_instalacionweb_580077d729b319171161014061447_scan.json\";s:7:\"Runtime\";s:10:\"13.36 sec.\";s:7:\"ExeSize\";s:8:\"347.77KB\";s:7:\"ZipSize\";s:7:\"40.45MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150620_instalacionweb_580077d729b319171161014061447_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:42418588;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:67:\"20150620_instalacionweb_580077d729b319171161014061447_installer.php\";s:4:\"Size\";i:356114;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1764245;s:4:\"File\";s:66:\"20150620_instalacionweb_580077d729b319171161014061447_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:101:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_580077d729b319171161014061447_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("18", "20150620_instalacionweb", "5825995d740b63467161111101141", "100", "2016-11-11 10:11:48", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-11-11 10:11:41\";s:7:\"Version\";s:6:\"1.1.20\";s:9:\"VersionWP\";s:5:\"4.6.1\";s:9:\"VersionDB\";s:6:\"5.6.34\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:18;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:29:\"5825995d740b63467161111101141\";s:8:\"NameHash\";s:53:\"20150620_instalacionweb_5825995d740b63467161111101141\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150620_instalacionweb_5825995d740b63467161111101141_scan.json\";s:7:\"Runtime\";s:10:\"13.96 sec.\";s:7:\"ExeSize\";s:7:\"351.9KB\";s:7:\"ZipSize\";s:7:\"40.31MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150620_instalacionweb_5825995d740b63467161111101141_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:42269643;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:67:\"20150620_instalacionweb_5825995d740b63467161111101141_installer.php\";s:4:\"Size\";i:360348;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1390944;s:4:\"File\";s:66:\"20150620_instalacionweb_5825995d740b63467161111101141_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:101:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_5825995d740b63467161111101141_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("19", "20150620_instalacionweb", "582599ffc854e2562161111101423", "100", "2016-11-11 10:14:28", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-11-11 10:14:23\";s:7:\"Version\";s:6:\"1.1.20\";s:9:\"VersionWP\";s:5:\"4.6.1\";s:9:\"VersionDB\";s:6:\"5.6.34\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:19;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:29:\"582599ffc854e2562161111101423\";s:8:\"NameHash\";s:53:\"20150620_instalacionweb_582599ffc854e2562161111101423\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150620_instalacionweb_582599ffc854e2562161111101423_scan.json\";s:7:\"Runtime\";s:10:\"10.66 sec.\";s:7:\"ExeSize\";s:7:\"351.9KB\";s:7:\"ZipSize\";s:7:\"40.31MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150620_instalacionweb_582599ffc854e2562161111101423_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:42269771;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:67:\"20150620_instalacionweb_582599ffc854e2562161111101423_installer.php\";s:4:\"Size\";i:360348;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1393982;s:4:\"File\";s:66:\"20150620_instalacionweb_582599ffc854e2562161111101423_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:101:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_582599ffc854e2562161111101423_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("20", "20150620_instalacionweb", "5831742fa38968557161120100015", "100", "2016-11-20 10:00:21", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2016-11-20 10:00:15\";s:7:\"Version\";s:6:\"1.1.20\";s:9:\"VersionWP\";s:5:\"4.6.1\";s:9:\"VersionDB\";s:6:\"5.6.34\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:20;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:29:\"5831742fa38968557161120100015\";s:8:\"NameHash\";s:53:\"20150620_instalacionweb_5831742fa38968557161120100015\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150620_instalacionweb_5831742fa38968557161120100015_scan.json\";s:7:\"Runtime\";s:10:\"12.89 sec.\";s:7:\"ExeSize\";s:7:\"351.9KB\";s:7:\"ZipSize\";s:7:\"40.32MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150620_instalacionweb_5831742fa38968557161120100015_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:42283661;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:67:\"20150620_instalacionweb_5831742fa38968557161120100015_installer.php\";s:4:\"Size\";i:360348;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1455505;s:4:\"File\";s:66:\"20150620_instalacionweb_5831742fa38968557161120100015_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:101:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_5831742fa38968557161120100015_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("21", "20150620_instalacionweb", "588b19d2c583c8175170127095842", "100", "2017-01-27 09:58:57", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-01-27 09:58:42\";s:7:\"Version\";s:6:\"1.1.28\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:21;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:29:\"588b19d2c583c8175170127095842\";s:8:\"NameHash\";s:53:\"20150620_instalacionweb_588b19d2c583c8175170127095842\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150620_instalacionweb_588b19d2c583c8175170127095842_scan.json\";s:7:\"Runtime\";s:10:\"13.90 sec.\";s:7:\"ExeSize\";s:8:\"352.39KB\";s:7:\"ZipSize\";s:7:\"39.51MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150620_instalacionweb_588b19d2c583c8175170127095842_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:41427788;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:67:\"20150620_instalacionweb_588b19d2c583c8175170127095842_installer.php\";s:4:\"Size\";i:360843;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:2279993;s:4:\"File\";s:66:\"20150620_instalacionweb_588b19d2c583c8175170127095842_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:101:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_588b19d2c583c8175170127095842_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("22", "20150620_instalacionweb", "589dac7a1d5205517170210120514", "100", "2017-02-10 12:05:19", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-10 12:05:14\";s:7:\"Version\";s:6:\"1.1.30\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:22;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:29:\"589dac7a1d5205517170210120514\";s:8:\"NameHash\";s:53:\"20150620_instalacionweb_589dac7a1d5205517170210120514\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150620_instalacionweb_589dac7a1d5205517170210120514_scan.json\";s:7:\"Runtime\";s:10:\"18.12 sec.\";s:7:\"ExeSize\";s:5:\"383KB\";s:7:\"ZipSize\";s:7:\"39.59MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150620_instalacionweb_589dac7a1d5205517170210120514_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:41508763;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:67:\"20150620_instalacionweb_589dac7a1d5205517170210120514_installer.php\";s:4:\"Size\";i:392195;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1479612;s:4:\"File\";s:66:\"20150620_instalacionweb_589dac7a1d5205517170210120514_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:101:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_589dac7a1d5205517170210120514_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("23", "20150620_instalacionweb", "58a580b1b92757534170216103633", "100", "2017-02-16 10:36:39", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-16 10:36:33\";s:7:\"Version\";s:6:\"1.1.30\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:23;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:29:\"58a580b1b92757534170216103633\";s:8:\"NameHash\";s:53:\"20150620_instalacionweb_58a580b1b92757534170216103633\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150620_instalacionweb_58a580b1b92757534170216103633_scan.json\";s:7:\"Runtime\";s:10:\"15.80 sec.\";s:7:\"ExeSize\";s:5:\"383KB\";s:7:\"ZipSize\";s:7:\"39.75MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150620_instalacionweb_58a580b1b92757534170216103633_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:41676089;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:67:\"20150620_instalacionweb_58a580b1b92757534170216103633_installer.php\";s:4:\"Size\";i:392195;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":12:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1913815;s:4:\"File\";s:66:\"20150620_instalacionweb_58a580b1b92757534170216103633_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:101:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_58a580b1b92757534170216103633_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("24", "20150620_instalacionweb", "58b421a38439e7966170227125459", "100", "2017-02-27 12:55:05", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-02-27 12:54:59\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.2\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:24;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:29:\"58b421a38439e7966170227125459\";s:8:\"NameHash\";s:53:\"20150620_instalacionweb_58b421a38439e7966170227125459\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150620_instalacionweb_58b421a38439e7966170227125459_scan.json\";s:7:\"Runtime\";s:10:\"13.78 sec.\";s:7:\"ExeSize\";s:8:\"394.71KB\";s:7:\"ZipSize\";s:7:\"40.46MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150620_instalacionweb_58b421a38439e7966170227125459_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:42430209;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:67:\"20150620_instalacionweb_58b421a38439e7966170227125459_installer.php\";s:4:\"Size\";i:404183;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1420657;s:4:\"File\";s:66:\"20150620_instalacionweb_58b421a38439e7966170227125459_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:101:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_58b421a38439e7966170227125459_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("25", "20150620_instalacionweb", "58c7d7d341acb7338170314114523", "100", "2017-03-14 11:46:22", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-03-14 11:45:23\";s:7:\"Version\";s:6:\"1.1.34\";s:9:\"VersionWP\";s:5:\"4.7.3\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:25;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:29:\"58c7d7d341acb7338170314114523\";s:8:\"NameHash\";s:53:\"20150620_instalacionweb_58c7d7d341acb7338170314114523\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:63:\"20150620_instalacionweb_58c7d7d341acb7338170314114523_scan.json\";s:7:\"Runtime\";s:10:\"15.66 sec.\";s:7:\"ExeSize\";s:8:\"394.71KB\";s:7:\"ZipSize\";s:7:\"39.38MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:65:\"20150620_instalacionweb_58c7d7d341acb7338170314114523_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:41298042;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:67:\"20150620_instalacionweb_58c7d7d341acb7338170314114523_installer.php\";s:4:\"Size\";i:404183;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1826846;s:4:\"File\";s:66:\"20150620_instalacionweb_58c7d7d341acb7338170314114523_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:101:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_58c7d7d341acb7338170314114523_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("26", "20150620_instalacionweb", "1e25df296f90ee257385170512093811", "100", "2017-05-12 09:38:20", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-05-12 09:38:11\";s:7:\"Version\";s:5:\"1.2.6\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:26;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"1e25df296f90ee257385170512093811\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_1e25df296f90ee257385170512093811\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_1e25df296f90ee257385170512093811_scan.json\";s:7:\"Runtime\";s:10:\"14.09 sec.\";s:7:\"ExeSize\";s:7:\"422.1KB\";s:7:\"ZipSize\";s:7:\"40.12MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_1e25df296f90ee257385170512093811_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:42069263;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:70:\"20150620_instalacionweb_1e25df296f90ee257385170512093811_installer.php\";s:4:\"Size\";i:432234;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1392222;s:4:\"File\";s:69:\"20150620_instalacionweb_1e25df296f90ee257385170512093811_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_1e25df296f90ee257385170512093811_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("27", "20150620_instalacionweb", "7018085fd81c53c98886170601102700", "100", "2017-06-01 10:27:21", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-06-01 10:27:00\";s:7:\"Version\";s:5:\"1.2.8\";s:9:\"VersionWP\";s:5:\"4.7.5\";s:9:\"VersionDB\";s:6:\"5.6.35\";s:10:\"VersionPHP\";s:6:\"5.4.45\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:27;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"7018085fd81c53c98886170601102700\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_7018085fd81c53c98886170601102700\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_7018085fd81c53c98886170601102700_scan.json\";s:7:\"Runtime\";s:10:\"15.34 sec.\";s:7:\"ExeSize\";s:8:\"428.44KB\";s:7:\"ZipSize\";s:7:\"40.61MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":14:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_7018085fd81c53c98886170601102700_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:42587067;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";r:1;}s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:70:\"20150620_instalacionweb_7018085fd81c53c98886170601102700_installer.php\";s:4:\"Size\";i:438718;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:2297635;s:4:\"File\";s:69:\"20150620_instalacionweb_7018085fd81c53c98886170601102700_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_7018085fd81c53c98886170601102700_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("28", "20150620_instalacionweb", "081ed5f83fae5da84131170919111301", "100", "2017-09-19 11:13:09", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-09-19 11:13:01\";s:7:\"Version\";s:6:\"1.2.24\";s:9:\"VersionWP\";s:5:\"4.8.1\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"7.0.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:28;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"081ed5f83fae5da84131170919111301\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_081ed5f83fae5da84131170919111301\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_081ed5f83fae5da84131170919111301_scan.json\";s:7:\"Runtime\";s:10:\"16.23 sec.\";s:7:\"ExeSize\";s:8:\"435.04KB\";s:7:\"ZipSize\";s:7:\"37.64MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_081ed5f83fae5da84131170919111301_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:39470308;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_081ed5f83fae5da84131170919111301_installer.php\";s:4:\"Size\";i:445481;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1417681;s:4:\"File\";s:69:\"20150620_instalacionweb_081ed5f83fae5da84131170919111301_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_081ed5f83fae5da84131170919111301_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("29", "20150620_instalacionweb", "eec8d61e6533a3e07003171026113126", "100", "2017-10-26 11:31:32", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-10-26 11:31:26\";s:7:\"Version\";s:6:\"1.2.26\";s:9:\"VersionWP\";s:5:\"4.8.2\";s:9:\"VersionDB\";s:6:\"5.6.37\";s:10:\"VersionPHP\";s:6:\"7.0.24\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:29;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"eec8d61e6533a3e07003171026113126\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_eec8d61e6533a3e07003171026113126\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_eec8d61e6533a3e07003171026113126_scan.json\";s:7:\"Runtime\";s:10:\"14.28 sec.\";s:7:\"ExeSize\";s:8:\"438.35KB\";s:7:\"ZipSize\";s:7:\"37.94MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_eec8d61e6533a3e07003171026113126_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:39787432;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_eec8d61e6533a3e07003171026113126_installer.php\";s:4:\"Size\";i:448869;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1399236;s:4:\"File\";s:69:\"20150620_instalacionweb_eec8d61e6533a3e07003171026113126_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_eec8d61e6533a3e07003171026113126_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("30", "20150620_instalacionweb", "05f9b1011bf406ee4492171121095114", "100", "2017-11-21 09:51:22", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-11-21 09:51:14\";s:7:\"Version\";s:6:\"1.2.30\";s:9:\"VersionWP\";s:5:\"4.8.3\";s:9:\"VersionDB\";s:6:\"5.6.38\";s:10:\"VersionPHP\";s:6:\"7.0.25\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:30;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"05f9b1011bf406ee4492171121095114\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_05f9b1011bf406ee4492171121095114\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_05f9b1011bf406ee4492171121095114_scan.json\";s:7:\"Runtime\";s:10:\"20.38 sec.\";s:7:\"ExeSize\";s:8:\"443.36KB\";s:7:\"ZipSize\";s:7:\"37.74MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_05f9b1011bf406ee4492171121095114_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:39570434;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_05f9b1011bf406ee4492171121095114_installer.php\";s:4:\"Size\";i:454003;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1373188;s:4:\"File\";s:69:\"20150620_instalacionweb_05f9b1011bf406ee4492171121095114_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_05f9b1011bf406ee4492171121095114_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("31", "20150620_instalacionweb", "c2c0abf391914a199679171212091638", "100", "2017-12-12 09:18:30", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-12-12 09:16:38\";s:7:\"Version\";s:6:\"1.2.30\";s:9:\"VersionWP\";s:5:\"4.9.1\";s:9:\"VersionDB\";s:6:\"5.6.38\";s:10:\"VersionPHP\";s:6:\"7.0.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:31;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"c2c0abf391914a199679171212091638\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_c2c0abf391914a199679171212091638\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_c2c0abf391914a199679171212091638_scan.json\";s:7:\"Runtime\";s:10:\"26.73 sec.\";s:7:\"ExeSize\";s:8:\"443.36KB\";s:7:\"ZipSize\";s:7:\"36.51MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_c2c0abf391914a199679171212091638_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:38284092;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_c2c0abf391914a199679171212091638_installer.php\";s:4:\"Size\";i:454003;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:902686;s:4:\"File\";s:69:\"20150620_instalacionweb_c2c0abf391914a199679171212091638_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_c2c0abf391914a199679171212091638_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("32", "20150620_instalacionweb", "9a9ece74b6ce4f737907171213192159", "100", "2017-12-13 19:22:07", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2017-12-13 19:21:59\";s:7:\"Version\";s:6:\"1.2.30\";s:9:\"VersionWP\";s:5:\"4.9.1\";s:9:\"VersionDB\";s:6:\"5.6.38\";s:10:\"VersionPHP\";s:6:\"7.0.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:32;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"9a9ece74b6ce4f737907171213192159\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_9a9ece74b6ce4f737907171213192159\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_9a9ece74b6ce4f737907171213192159_scan.json\";s:7:\"Runtime\";s:10:\"13.85 sec.\";s:7:\"ExeSize\";s:8:\"443.36KB\";s:7:\"ZipSize\";s:7:\"36.51MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_9a9ece74b6ce4f737907171213192159_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:38282519;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_9a9ece74b6ce4f737907171213192159_installer.php\";s:4:\"Size\";i:454003;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:897353;s:4:\"File\";s:69:\"20150620_instalacionweb_9a9ece74b6ce4f737907171213192159_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_9a9ece74b6ce4f737907171213192159_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("33", "20150620_instalacionweb", "6d2f2753bcf591396007180117183544", "100", "2018-01-17 18:35:50", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-01-17 18:35:44\";s:7:\"Version\";s:6:\"1.2.32\";s:9:\"VersionWP\";s:5:\"4.9.2\";s:9:\"VersionDB\";s:6:\"5.6.38\";s:10:\"VersionPHP\";s:6:\"7.0.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:33;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"6d2f2753bcf591396007180117183544\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_6d2f2753bcf591396007180117183544\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_6d2f2753bcf591396007180117183544_scan.json\";s:7:\"Runtime\";s:10:\"11.29 sec.\";s:7:\"ExeSize\";s:8:\"444.01KB\";s:7:\"ZipSize\";s:7:\"35.84MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_6d2f2753bcf591396007180117183544_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:37579645;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_6d2f2753bcf591396007180117183544_installer.php\";s:4:\"Size\";i:454669;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:995682;s:4:\"File\";s:69:\"20150620_instalacionweb_6d2f2753bcf591396007180117183544_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_6d2f2753bcf591396007180117183544_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("34", "20150620_instalacionweb", "1c7913e96a9c04663405180130080017", "100", "2018-01-30 08:00:46", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-01-30 08:00:17\";s:7:\"Version\";s:6:\"1.2.32\";s:9:\"VersionWP\";s:5:\"4.9.2\";s:9:\"VersionDB\";s:6:\"5.6.38\";s:10:\"VersionPHP\";s:6:\"7.0.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:34;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"1c7913e96a9c04663405180130080017\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_1c7913e96a9c04663405180130080017\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_1c7913e96a9c04663405180130080017_scan.json\";s:7:\"Runtime\";s:10:\"20.26 sec.\";s:7:\"ExeSize\";s:8:\"444.01KB\";s:7:\"ZipSize\";s:7:\"36.03MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_1c7913e96a9c04663405180130080017_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:37780232;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_1c7913e96a9c04663405180130080017_installer.php\";s:4:\"Size\";i:454669;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1154871;s:4:\"File\";s:69:\"20150620_instalacionweb_1c7913e96a9c04663405180130080017_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_1c7913e96a9c04663405180130080017_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("35", "20150620_instalacionweb", "bd87022c593739641337180131111624", "100", "2018-01-31 11:16:30", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-01-31 11:16:24\";s:7:\"Version\";s:6:\"1.2.32\";s:9:\"VersionWP\";s:5:\"4.9.2\";s:9:\"VersionDB\";s:6:\"5.6.38\";s:10:\"VersionPHP\";s:6:\"7.0.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:35;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"bd87022c593739641337180131111624\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_bd87022c593739641337180131111624\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_bd87022c593739641337180131111624_scan.json\";s:7:\"Runtime\";s:10:\"13.63 sec.\";s:7:\"ExeSize\";s:8:\"444.01KB\";s:7:\"ZipSize\";s:7:\"36.04MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_bd87022c593739641337180131111624_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:37793980;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_bd87022c593739641337180131111624_installer.php\";s:4:\"Size\";i:454669;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1155843;s:4:\"File\";s:69:\"20150620_instalacionweb_bd87022c593739641337180131111624_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_bd87022c593739641337180131111624_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("36", "20150620_instalacionweb", "155dfd07a4a526286394180205184945", "100", "2018-02-05 18:51:00", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-02-05 18:49:45\";s:7:\"Version\";s:6:\"1.2.32\";s:9:\"VersionWP\";s:5:\"4.9.2\";s:9:\"VersionDB\";s:6:\"5.6.38\";s:10:\"VersionPHP\";s:6:\"7.0.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:36;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"155dfd07a4a526286394180205184945\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_155dfd07a4a526286394180205184945\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_155dfd07a4a526286394180205184945_scan.json\";s:7:\"Runtime\";s:10:\"15.91 sec.\";s:7:\"ExeSize\";s:8:\"444.01KB\";s:7:\"ZipSize\";s:4:\"36MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":18:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_155dfd07a4a526286394180205184945_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:37748107;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_155dfd07a4a526286394180205184945_installer.php\";s:4:\"Size\";i:454669;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:907415;s:4:\"File\";s:69:\"20150620_instalacionweb_155dfd07a4a526286394180205184945_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_155dfd07a4a526286394180205184945_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("37", "20150620_instalacionweb", "cede7fde221974ff7782180321145303", "100", "2018-03-21 14:53:10", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-03-21 14:53:03\";s:7:\"Version\";s:6:\"1.2.34\";s:9:\"VersionWP\";s:5:\"4.9.4\";s:9:\"VersionDB\";s:6:\"5.6.39\";s:10:\"VersionPHP\";s:6:\"7.0.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:37;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"cede7fde221974ff7782180321145303\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_cede7fde221974ff7782180321145303\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_cede7fde221974ff7782180321145303_scan.json\";s:7:\"Runtime\";s:10:\"16.23 sec.\";s:7:\"ExeSize\";s:8:\"445.29KB\";s:7:\"ZipSize\";s:7:\"33.61MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_cede7fde221974ff7782180321145303_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:35246700;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_cede7fde221974ff7782180321145303_installer.php\";s:4:\"Size\";i:455982;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:922284;s:4:\"File\";s:69:\"20150620_instalacionweb_cede7fde221974ff7782180321145303_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_cede7fde221974ff7782180321145303_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("38", "20150620_instalacionweb", "6893e6c7d5a9c5984762180421050945", "100", "2018-04-21 05:09:52", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-04-21 05:09:45\";s:7:\"Version\";s:6:\"1.2.34\";s:9:\"VersionWP\";s:5:\"4.9.5\";s:9:\"VersionDB\";s:6:\"5.6.39\";s:10:\"VersionPHP\";s:6:\"7.0.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:38;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"6893e6c7d5a9c5984762180421050945\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_6893e6c7d5a9c5984762180421050945\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_6893e6c7d5a9c5984762180421050945_scan.json\";s:7:\"Runtime\";s:10:\"25.75 sec.\";s:7:\"ExeSize\";s:8:\"445.29KB\";s:7:\"ZipSize\";s:7:\"33.94MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_6893e6c7d5a9c5984762180421050945_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:35591153;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_6893e6c7d5a9c5984762180421050945_installer.php\";s:4:\"Size\";i:455982;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:937698;s:4:\"File\";s:69:\"20150620_instalacionweb_6893e6c7d5a9c5984762180421050945_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_6893e6c7d5a9c5984762180421050945_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("39", "20150620_instalacionweb", "cf2a5fb2c25be3c39623180508134703", "100", "2018-05-08 13:47:09", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-05-08 13:47:03\";s:7:\"Version\";s:6:\"1.2.36\";s:9:\"VersionWP\";s:5:\"4.9.5\";s:9:\"VersionDB\";s:6:\"5.6.39\";s:10:\"VersionPHP\";s:6:\"7.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:39;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"cf2a5fb2c25be3c39623180508134703\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_cf2a5fb2c25be3c39623180508134703\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_cf2a5fb2c25be3c39623180508134703_scan.json\";s:7:\"Runtime\";s:10:\"16.12 sec.\";s:7:\"ExeSize\";s:8:\"445.93KB\";s:7:\"ZipSize\";s:7:\"34.09MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_cf2a5fb2c25be3c39623180508134703_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:35743300;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_cf2a5fb2c25be3c39623180508134703_installer.php\";s:4:\"Size\";i:456628;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:940954;s:4:\"File\";s:69:\"20150620_instalacionweb_cf2a5fb2c25be3c39623180508134703_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_cf2a5fb2c25be3c39623180508134703_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("40", "20150620_instalacionweb", "7d5408ae744fd2126500180529214614", "100", "2018-05-29 21:46:20", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-05-29 21:46:14\";s:7:\"Version\";s:6:\"1.2.38\";s:9:\"VersionWP\";s:5:\"4.9.6\";s:9:\"VersionDB\";s:6:\"5.6.39\";s:10:\"VersionPHP\";s:6:\"7.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:40;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"7d5408ae744fd2126500180529214614\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_7d5408ae744fd2126500180529214614\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_7d5408ae744fd2126500180529214614_scan.json\";s:7:\"Runtime\";s:10:\"16.61 sec.\";s:7:\"ExeSize\";s:8:\"445.93KB\";s:7:\"ZipSize\";s:7:\"36.18MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_7d5408ae744fd2126500180529214614_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:37941353;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_7d5408ae744fd2126500180529214614_installer.php\";s:4:\"Size\";i:456628;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1671675;s:4:\"File\";s:69:\"20150620_instalacionweb_7d5408ae744fd2126500180529214614_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_7d5408ae744fd2126500180529214614_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("41", "20150620_instalacionweb", "112d6163d65809606372180610143536", "100", "2018-06-10 14:36:12", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-06-10 14:35:36\";s:7:\"Version\";s:6:\"1.2.40\";s:9:\"VersionWP\";s:5:\"4.9.6\";s:9:\"VersionDB\";s:6:\"5.6.39\";s:10:\"VersionPHP\";s:6:\"7.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:41;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"112d6163d65809606372180610143536\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_112d6163d65809606372180610143536\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_112d6163d65809606372180610143536_scan.json\";s:7:\"Runtime\";s:10:\"16.64 sec.\";s:7:\"ExeSize\";s:8:\"445.93KB\";s:7:\"ZipSize\";s:7:\"39.61MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_112d6163d65809606372180610143536_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:41534653;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_112d6163d65809606372180610143536_installer.php\";s:4:\"Size\";i:456628;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1813529;s:4:\"File\";s:69:\"20150620_instalacionweb_112d6163d65809606372180610143536_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_112d6163d65809606372180610143536_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("42", "20150620_instalacionweb", "795c0c89f45f74035068180823060113", "100", "2018-08-23 06:02:05", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-08-23 06:01:13\";s:7:\"Version\";s:6:\"1.2.40\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.40\";s:10:\"VersionPHP\";s:6:\"7.0.31\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:42;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"795c0c89f45f74035068180823060113\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_795c0c89f45f74035068180823060113\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_795c0c89f45f74035068180823060113_scan.json\";s:7:\"Runtime\";s:10:\"18.78 sec.\";s:7:\"ExeSize\";s:8:\"445.93KB\";s:7:\"ZipSize\";s:7:\"40.01MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_795c0c89f45f74035068180823060113_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:41949551;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":7:{s:4:\"File\";s:70:\"20150620_instalacionweb_795c0c89f45f74035068180823060113_installer.php\";s:4:\"Size\";i:456628;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1872707;s:4:\"File\";s:69:\"20150620_instalacionweb_795c0c89f45f74035068180823060113_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_795c0c89f45f74035068180823060113_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("43", "20150620_instalacionweb", "76a943de63f917d48461180914083854", "100", "2018-09-14 08:40:20", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-14 08:38:54\";s:7:\"Version\";s:6:\"1.2.42\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.40\";s:10:\"VersionPHP\";s:6:\"7.0.31\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:43;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:32:\"76a943de63f917d48461180914083854\";s:8:\"NameHash\";s:56:\"20150620_instalacionweb_76a943de63f917d48461180914083854\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:66:\"20150620_instalacionweb_76a943de63f917d48461180914083854_scan.json\";s:7:\"Runtime\";s:10:\"17.25 sec.\";s:7:\"ExeSize\";s:7:\"472.5KB\";s:7:\"ZipSize\";s:7:\"39.96MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20150620_instalacionweb_76a943de63f917d48461180914083854_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:41903242;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";s:70:\"20150620_instalacionweb_76a943de63f917d48461180914083854_installer.php\";s:4:\"Size\";i:483838;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1695132;s:4:\"File\";s:69:\"20150620_instalacionweb_76a943de63f917d48461180914083854_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:104:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_76a943de63f917d48461180914083854_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("44", "20150620_instalacionweb", "5148d3dd97cf1b434792_20181114085943", "100", "2018-11-14 08:59:54", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-14 08:59:43\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.41\";s:10:\"VersionPHP\";s:6:\"7.0.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:44;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"5148d3dd97cf1b434792_20181114085943\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_5148d3dd97cf1b434792_20181114085943\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_5148d3dd97cf1b434792_20181114085943_scan.json\";s:7:\"Runtime\";s:10:\"18.30 sec.\";s:7:\"ExeSize\";s:7:\"514.2KB\";s:7:\"ZipSize\";s:7:\"40.12MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_5148d3dd97cf1b434792_20181114085943_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:42063823;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";s:73:\"20150620_instalacionweb_5148d3dd97cf1b434792_20181114085943_installer.php\";s:4:\"Size\";i:526544;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1810528;s:4:\"File\";s:72:\"20150620_instalacionweb_5148d3dd97cf1b434792_20181114085943_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_5148d3dd97cf1b434792_20181114085943_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("45", "20150620_instalacionweb", "af6c55ef24f657f66273_20181119091835", "100", "2018-11-19 09:18:44", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-19 09:18:35\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.41\";s:10:\"VersionPHP\";s:6:\"7.0.32\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:45;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"af6c55ef24f657f66273_20181119091835\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_af6c55ef24f657f66273_20181119091835\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_af6c55ef24f657f66273_20181119091835_scan.json\";s:7:\"Runtime\";s:10:\"18.56 sec.\";s:7:\"ExeSize\";s:7:\"514.2KB\";s:7:\"ZipSize\";s:7:\"40.18MB\";s:6:\"Status\";N;s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_af6c55ef24f657f66273_20181119091835_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:42126771;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";i:5;s:29:\"/home/solucion/wp/wp-includes\";}}s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";s:73:\"20150620_instalacionweb_af6c55ef24f657f66273_20181119091835_installer.php\";s:4:\"Size\";i:526544;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:2455053;s:4:\"File\";s:72:\"20150620_instalacionweb_af6c55ef24f657f66273_20181119091835_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_af6c55ef24f657f66273_20181119091835_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("46", "20150620_instalacionweb", "c5687644aecd89ea8082_20190410145936", "100", "2019-04-10 15:00:02", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-04-10 14:59:36\";s:7:\"Version\";s:6:\"1.3.10\";s:9:\"VersionWP\";s:5:\"5.1.1\";s:9:\"VersionDB\";s:6:\"5.6.43\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:46;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"c5687644aecd89ea8082_20190410145936\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_c5687644aecd89ea8082_20190410145936\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_c5687644aecd89ea8082_20190410145936_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"17.26 sec.\";s:7:\"ExeSize\";s:8:\"207.33KB\";s:7:\"ZipSize\";s:7:\"45.22MB\";s:6:\"Status\";i:100;s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_c5687644aecd89ea8082_20190410145936_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:47417558;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:8550;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:73:\"20150620_instalacionweb_c5687644aecd89ea8082_20190410145936_installer.php\";s:4:\"Size\";i:212302;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:2310122;s:4:\"File\";s:72:\"20150620_instalacionweb_c5687644aecd89ea8082_20190410145936_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:34;s:16:\"tablesFinalCount\";i:34;s:14:\"tablesRowCount\";s:3:\"627\";s:16:\"tablesSizeOnDisk\";s:6:\"6.18MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.6.43\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:34:{s:25:\"bfjx9x8i_WP_SEO_404_links\";s:1:\"1\";s:21:\"bfjx9x8i_WP_SEO_Cache\";s:1:\"0\";s:27:\"bfjx9x8i_WP_SEO_Redirection\";s:1:\"0\";s:31:\"bfjx9x8i_WP_SEO_Redirection_LOG\";s:1:\"0\";s:20:\"bfjx9x8i_blc_filters\";s:1:\"0\";s:22:\"bfjx9x8i_blc_instances\";s:1:\"0\";s:18:\"bfjx9x8i_blc_links\";s:1:\"0\";s:18:\"bfjx9x8i_blc_synch\";s:1:\"0\";s:20:\"bfjx9x8i_commentmeta\";s:1:\"0\";s:17:\"bfjx9x8i_comments\";s:1:\"0\";s:28:\"bfjx9x8i_duplicator_packages\";s:2:\"30\";s:17:\"bfjx9x8i_eum_logs\";s:3:\"120\";s:22:\"bfjx9x8i_ewwwio_images\";s:1:\"1\";s:34:\"bfjx9x8i_itsec_distributed_storage\";s:1:\"3\";s:27:\"bfjx9x8i_itsec_fingerprints\";s:1:\"0\";s:32:\"bfjx9x8i_itsec_geolocation_cache\";s:1:\"0\";s:23:\"bfjx9x8i_itsec_lockouts\";s:1:\"0\";s:18:\"bfjx9x8i_itsec_log\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_logs\";s:2:\"80\";s:19:\"bfjx9x8i_itsec_temp\";s:2:\"49\";s:14:\"bfjx9x8i_links\";s:1:\"0\";s:16:\"bfjx9x8i_options\";s:3:\"314\";s:17:\"bfjx9x8i_postmeta\";s:1:\"9\";s:14:\"bfjx9x8i_posts\";s:1:\"2\";s:25:\"bfjx9x8i_smush_dir_images\";s:1:\"0\";s:27:\"bfjx9x8i_term_relationships\";s:1:\"0\";s:22:\"bfjx9x8i_term_taxonomy\";s:1:\"1\";s:17:\"bfjx9x8i_termmeta\";s:1:\"0\";s:14:\"bfjx9x8i_terms\";s:1:\"1\";s:17:\"bfjx9x8i_usermeta\";s:2:\"46\";s:14:\"bfjx9x8i_users\";s:1:\"1\";s:28:\"bfjx9x8i_wpfront_ure_options\";s:1:\"3\";s:24:\"bfjx9x8i_yoast_seo_links\";s:1:\"0\";s:23:\"bfjx9x8i_yoast_seo_meta\";s:1:\"1\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_c5687644aecd89ea8082_20190410145936_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-04-10 14:59:36\";s:7:\"Version\";s:6:\"1.3.10\";s:9:\"VersionWP\";s:5:\"5.1.1\";s:9:\"VersionDB\";s:6:\"5.6.43\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"c5687644aecd89ea8082_20190410145936\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_c5687644aecd89ea8082_20190410145936\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:158;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("47", "20150620_instalacionweb", "da811cfb885c31ad9465_20200401081830", "100", "2020-04-01 08:18:47", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-01 08:18:30\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:5:\"5.2.5\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:47;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"da811cfb885c31ad9465_20200401081830\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_da811cfb885c31ad9465_20200401081830\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_da811cfb885c31ad9465_20200401081830_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"19.88 sec.\";s:7:\"ExeSize\";s:7:\"60.53KB\";s:7:\"ZipSize\";s:7:\"46.84MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_da811cfb885c31ad9465_20200401081830_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:49117363;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:8091;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:73:\"20150620_instalacionweb_da811cfb885c31ad9465_20200401081830_installer.php\";s:4:\"Size\";i:61985;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1697696;s:4:\"File\";s:72:\"20150620_instalacionweb_da811cfb885c31ad9465_20200401081830_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:35;s:16:\"tablesFinalCount\";i:35;s:14:\"tablesRowCount\";s:5:\"1,069\";s:16:\"tablesSizeOnDisk\";s:6:\"6.38MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.27\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:35:{s:25:\"bfjx9x8i_WP_SEO_404_links\";s:1:\"1\";s:21:\"bfjx9x8i_WP_SEO_Cache\";s:1:\"0\";s:27:\"bfjx9x8i_WP_SEO_Redirection\";s:1:\"0\";s:31:\"bfjx9x8i_WP_SEO_Redirection_LOG\";s:1:\"0\";s:20:\"bfjx9x8i_blc_filters\";s:1:\"0\";s:22:\"bfjx9x8i_blc_instances\";s:1:\"0\";s:18:\"bfjx9x8i_blc_links\";s:1:\"0\";s:18:\"bfjx9x8i_blc_synch\";s:1:\"0\";s:20:\"bfjx9x8i_commentmeta\";s:1:\"0\";s:17:\"bfjx9x8i_comments\";s:1:\"0\";s:28:\"bfjx9x8i_duplicator_packages\";s:2:\"31\";s:17:\"bfjx9x8i_eum_logs\";s:3:\"427\";s:22:\"bfjx9x8i_ewwwio_images\";s:1:\"1\";s:34:\"bfjx9x8i_itsec_distributed_storage\";s:1:\"3\";s:27:\"bfjx9x8i_itsec_fingerprints\";s:1:\"0\";s:32:\"bfjx9x8i_itsec_geolocation_cache\";s:1:\"0\";s:23:\"bfjx9x8i_itsec_lockouts\";s:1:\"1\";s:18:\"bfjx9x8i_itsec_log\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_logs\";s:3:\"124\";s:28:\"bfjx9x8i_itsec_opaque_tokens\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_temp\";s:3:\"115\";s:14:\"bfjx9x8i_links\";s:1:\"0\";s:16:\"bfjx9x8i_options\";s:3:\"323\";s:17:\"bfjx9x8i_postmeta\";s:1:\"9\";s:14:\"bfjx9x8i_posts\";s:1:\"2\";s:25:\"bfjx9x8i_smush_dir_images\";s:1:\"0\";s:27:\"bfjx9x8i_term_relationships\";s:1:\"0\";s:22:\"bfjx9x8i_term_taxonomy\";s:1:\"1\";s:17:\"bfjx9x8i_termmeta\";s:1:\"0\";s:14:\"bfjx9x8i_terms\";s:1:\"1\";s:17:\"bfjx9x8i_usermeta\";s:2:\"44\";s:14:\"bfjx9x8i_users\";s:1:\"1\";s:28:\"bfjx9x8i_wpfront_ure_options\";s:1:\"3\";s:24:\"bfjx9x8i_yoast_seo_links\";s:1:\"0\";s:23:\"bfjx9x8i_yoast_seo_meta\";s:1:\"2\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_da811cfb885c31ad9465_20200401081830_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-01 08:18:30\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:5:\"5.2.5\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"da811cfb885c31ad9465_20200401081830\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_da811cfb885c31ad9465_20200401081830\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:159;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("48", "20150620_instalacionweb", "402141657e7578723221_20200401081954", "100", "2020-04-01 08:20:10", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-01 08:19:54\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:3:\"5.4\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:48;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"402141657e7578723221_20200401081954\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_402141657e7578723221_20200401081954\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_402141657e7578723221_20200401081954_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"15.88 sec.\";s:7:\"ExeSize\";s:7:\"60.53KB\";s:7:\"ZipSize\";s:7:\"48.53MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_402141657e7578723221_20200401081954_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:50889398;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:8224;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:73:\"20150620_instalacionweb_402141657e7578723221_20200401081954_installer.php\";s:4:\"Size\";i:61985;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1704045;s:4:\"File\";s:72:\"20150620_instalacionweb_402141657e7578723221_20200401081954_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:35;s:16:\"tablesFinalCount\";i:35;s:14:\"tablesRowCount\";s:5:\"1,071\";s:16:\"tablesSizeOnDisk\";s:5:\"6.4MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.27\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:35:{s:25:\"bfjx9x8i_WP_SEO_404_links\";s:1:\"1\";s:21:\"bfjx9x8i_WP_SEO_Cache\";s:1:\"0\";s:27:\"bfjx9x8i_WP_SEO_Redirection\";s:1:\"0\";s:31:\"bfjx9x8i_WP_SEO_Redirection_LOG\";s:1:\"0\";s:20:\"bfjx9x8i_blc_filters\";s:1:\"0\";s:22:\"bfjx9x8i_blc_instances\";s:1:\"0\";s:18:\"bfjx9x8i_blc_links\";s:1:\"0\";s:18:\"bfjx9x8i_blc_synch\";s:1:\"0\";s:20:\"bfjx9x8i_commentmeta\";s:1:\"0\";s:17:\"bfjx9x8i_comments\";s:1:\"0\";s:28:\"bfjx9x8i_duplicator_packages\";s:2:\"32\";s:17:\"bfjx9x8i_eum_logs\";s:3:\"428\";s:22:\"bfjx9x8i_ewwwio_images\";s:1:\"1\";s:34:\"bfjx9x8i_itsec_distributed_storage\";s:1:\"3\";s:27:\"bfjx9x8i_itsec_fingerprints\";s:1:\"0\";s:32:\"bfjx9x8i_itsec_geolocation_cache\";s:1:\"0\";s:23:\"bfjx9x8i_itsec_lockouts\";s:1:\"1\";s:18:\"bfjx9x8i_itsec_log\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_logs\";s:3:\"124\";s:28:\"bfjx9x8i_itsec_opaque_tokens\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_temp\";s:3:\"115\";s:14:\"bfjx9x8i_links\";s:1:\"0\";s:16:\"bfjx9x8i_options\";s:3:\"325\";s:17:\"bfjx9x8i_postmeta\";s:1:\"9\";s:14:\"bfjx9x8i_posts\";s:1:\"2\";s:25:\"bfjx9x8i_smush_dir_images\";s:1:\"0\";s:27:\"bfjx9x8i_term_relationships\";s:1:\"0\";s:22:\"bfjx9x8i_term_taxonomy\";s:1:\"1\";s:17:\"bfjx9x8i_termmeta\";s:1:\"0\";s:14:\"bfjx9x8i_terms\";s:1:\"1\";s:17:\"bfjx9x8i_usermeta\";s:2:\"44\";s:14:\"bfjx9x8i_users\";s:1:\"1\";s:28:\"bfjx9x8i_wpfront_ure_options\";s:1:\"3\";s:24:\"bfjx9x8i_yoast_seo_links\";s:1:\"0\";s:23:\"bfjx9x8i_yoast_seo_meta\";s:1:\"2\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_402141657e7578723221_20200401081954_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-01 08:19:54\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:3:\"5.4\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"402141657e7578723221_20200401081954\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_402141657e7578723221_20200401081954\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:159;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("49", "20150620_instalacionweb", "fe5cb3e2437f03642231_20200401093050", "100", "2020-04-01 09:32:37", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-01 09:30:50\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:49;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"fe5cb3e2437f03642231_20200401093050\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_fe5cb3e2437f03642231_20200401093050\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_fe5cb3e2437f03642231_20200401093050_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"17.51 sec.\";s:7:\"ExeSize\";s:7:\"60.53KB\";s:7:\"ZipSize\";s:7:\"48.29MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_fe5cb3e2437f03642231_20200401093050_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:50632966;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:8240;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:73:\"20150620_instalacionweb_fe5cb3e2437f03642231_20200401093050_installer.php\";s:4:\"Size\";i:61985;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:1774358;s:4:\"File\";s:72:\"20150620_instalacionweb_fe5cb3e2437f03642231_20200401093050_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:35;s:16:\"tablesFinalCount\";i:35;s:14:\"tablesRowCount\";s:5:\"1,076\";s:16:\"tablesSizeOnDisk\";s:5:\"6.4MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.27\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:35:{s:25:\"bfjx9x8i_WP_SEO_404_links\";s:1:\"1\";s:21:\"bfjx9x8i_WP_SEO_Cache\";s:1:\"0\";s:27:\"bfjx9x8i_WP_SEO_Redirection\";s:1:\"0\";s:31:\"bfjx9x8i_WP_SEO_Redirection_LOG\";s:1:\"0\";s:20:\"bfjx9x8i_blc_filters\";s:1:\"0\";s:22:\"bfjx9x8i_blc_instances\";s:1:\"0\";s:18:\"bfjx9x8i_blc_links\";s:1:\"0\";s:18:\"bfjx9x8i_blc_synch\";s:1:\"0\";s:20:\"bfjx9x8i_commentmeta\";s:1:\"0\";s:17:\"bfjx9x8i_comments\";s:1:\"0\";s:28:\"bfjx9x8i_duplicator_packages\";s:2:\"33\";s:17:\"bfjx9x8i_eum_logs\";s:3:\"433\";s:22:\"bfjx9x8i_ewwwio_images\";s:1:\"1\";s:34:\"bfjx9x8i_itsec_distributed_storage\";s:1:\"3\";s:27:\"bfjx9x8i_itsec_fingerprints\";s:1:\"0\";s:32:\"bfjx9x8i_itsec_geolocation_cache\";s:1:\"0\";s:23:\"bfjx9x8i_itsec_lockouts\";s:1:\"1\";s:18:\"bfjx9x8i_itsec_log\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_logs\";s:3:\"124\";s:28:\"bfjx9x8i_itsec_opaque_tokens\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_temp\";s:3:\"115\";s:14:\"bfjx9x8i_links\";s:1:\"0\";s:16:\"bfjx9x8i_options\";s:3:\"327\";s:17:\"bfjx9x8i_postmeta\";s:1:\"9\";s:14:\"bfjx9x8i_posts\";s:1:\"2\";s:25:\"bfjx9x8i_smush_dir_images\";s:1:\"0\";s:27:\"bfjx9x8i_term_relationships\";s:1:\"0\";s:22:\"bfjx9x8i_term_taxonomy\";s:1:\"1\";s:17:\"bfjx9x8i_termmeta\";s:1:\"0\";s:14:\"bfjx9x8i_terms\";s:1:\"1\";s:17:\"bfjx9x8i_usermeta\";s:2:\"44\";s:14:\"bfjx9x8i_users\";s:1:\"1\";s:28:\"bfjx9x8i_wpfront_ure_options\";s:1:\"3\";s:24:\"bfjx9x8i_yoast_seo_links\";s:1:\"0\";s:23:\"bfjx9x8i_yoast_seo_meta\";s:1:\"2\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_fe5cb3e2437f03642231_20200401093050_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2020-04-01 09:30:50\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"fe5cb3e2437f03642231_20200401093050\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_fe5cb3e2437f03642231_20200401093050\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:34:\"/home/solucion/wp/wp-snapshots/tmp\";s:8:\"StoreURL\";s:48:\"http://www.wp.solucioneslowcost.es/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";r:76;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:159;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("50", "20150620_instalacionweb", "bc3d073d7690877e9528_20200911133926", "100", "2020-09-11 13:39:37", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-09-11 13:39:26\";s:7:\"Version\";s:6:\"1.3.36\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:50;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"bc3d073d7690877e9528_20200911133926\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_bc3d073d7690877e9528_20200911133926\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_bc3d073d7690877e9528_20200911133926_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"27.73 sec.\";s:7:\"ExeSize\";s:7:\"61.32KB\";s:7:\"ZipSize\";s:7:\"50.49MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_bc3d073d7690877e9528_20200911133926_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:52938913;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:8945;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:73:\"20150620_instalacionweb_bc3d073d7690877e9528_20200911133926_installer.php\";s:4:\"Size\";i:62792;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4473418;s:4:\"File\";s:72:\"20150620_instalacionweb_bc3d073d7690877e9528_20200911133926_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:41;s:16:\"tablesFinalCount\";i:41;s:14:\"tablesRowCount\";s:5:\"1,491\";s:16:\"tablesSizeOnDisk\";s:6:\"8.47MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.27\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:41:{s:25:\"bfjx9x8i_WP_SEO_404_links\";s:1:\"1\";s:21:\"bfjx9x8i_WP_SEO_Cache\";s:1:\"0\";s:27:\"bfjx9x8i_WP_SEO_Redirection\";s:1:\"0\";s:31:\"bfjx9x8i_WP_SEO_Redirection_LOG\";s:1:\"0\";s:20:\"bfjx9x8i_blc_filters\";s:1:\"0\";s:22:\"bfjx9x8i_blc_instances\";s:1:\"0\";s:18:\"bfjx9x8i_blc_links\";s:1:\"0\";s:18:\"bfjx9x8i_blc_synch\";s:1:\"0\";s:20:\"bfjx9x8i_commentmeta\";s:1:\"0\";s:17:\"bfjx9x8i_comments\";s:1:\"0\";s:28:\"bfjx9x8i_duplicator_packages\";s:2:\"34\";s:17:\"bfjx9x8i_eum_logs\";s:3:\"595\";s:22:\"bfjx9x8i_ewwwio_images\";s:1:\"1\";s:34:\"bfjx9x8i_itsec_distributed_storage\";s:1:\"4\";s:27:\"bfjx9x8i_itsec_fingerprints\";s:1:\"0\";s:32:\"bfjx9x8i_itsec_geolocation_cache\";s:1:\"0\";s:23:\"bfjx9x8i_itsec_lockouts\";s:1:\"3\";s:18:\"bfjx9x8i_itsec_log\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_logs\";s:2:\"97\";s:22:\"bfjx9x8i_itsec_mutexes\";s:1:\"0\";s:28:\"bfjx9x8i_itsec_opaque_tokens\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_temp\";s:3:\"672\";s:26:\"bfjx9x8i_itsec_user_groups\";s:1:\"5\";s:14:\"bfjx9x8i_links\";s:1:\"0\";s:16:\"bfjx9x8i_options\";s:3:\"334\";s:17:\"bfjx9x8i_postmeta\";s:1:\"9\";s:14:\"bfjx9x8i_posts\";s:1:\"2\";s:25:\"bfjx9x8i_smush_dir_images\";s:1:\"0\";s:27:\"bfjx9x8i_term_relationships\";s:1:\"0\";s:22:\"bfjx9x8i_term_taxonomy\";s:1:\"1\";s:17:\"bfjx9x8i_termmeta\";s:1:\"0\";s:14:\"bfjx9x8i_terms\";s:1:\"1\";s:17:\"bfjx9x8i_usermeta\";s:2:\"44\";s:14:\"bfjx9x8i_users\";s:1:\"1\";s:28:\"bfjx9x8i_wpfront_ure_options\";s:1:\"3\";s:24:\"bfjx9x8i_yoast_indexable\";s:1:\"7\";s:34:\"bfjx9x8i_yoast_indexable_hierarchy\";s:1:\"0\";s:25:\"bfjx9x8i_yoast_migrations\";s:2:\"17\";s:27:\"bfjx9x8i_yoast_primary_term\";s:1:\"0\";s:24:\"bfjx9x8i_yoast_seo_links\";s:1:\"0\";s:23:\"bfjx9x8i_yoast_seo_meta\";s:1:\"2\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_bc3d073d7690877e9528_20200911133926_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-09-11 13:39:26\";s:7:\"Version\";s:6:\"1.3.36\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"bc3d073d7690877e9528_20200911133926\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_bc3d073d7690877e9528_20200911133926\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:74;s:8:\"Database\";r:86;s:13:\"BuildProgress\";r:163;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("51", "20150620_instalacionweb", "6573cc39c1a2a6b48973_20201018002133", "100", "2020-10-18 00:21:42", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-10-18 00:21:33\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:51;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"6573cc39c1a2a6b48973_20201018002133\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_6573cc39c1a2a6b48973_20201018002133\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_6573cc39c1a2a6b48973_20201018002133_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"26.83 sec.\";s:7:\"ExeSize\";s:7:\"61.32KB\";s:7:\"ZipSize\";s:7:\"50.15MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_6573cc39c1a2a6b48973_20201018002133_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:52590392;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:8963;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:73:\"20150620_instalacionweb_6573cc39c1a2a6b48973_20201018002133_installer.php\";s:4:\"Size\";i:62792;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4634704;s:4:\"File\";s:72:\"20150620_instalacionweb_6573cc39c1a2a6b48973_20201018002133_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:41;s:16:\"tablesFinalCount\";i:41;s:14:\"tablesRowCount\";s:5:\"1,653\";s:16:\"tablesSizeOnDisk\";s:6:\"8.58MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.27\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:41:{s:25:\"bfjx9x8i_WP_SEO_404_links\";s:1:\"1\";s:21:\"bfjx9x8i_WP_SEO_Cache\";s:1:\"0\";s:27:\"bfjx9x8i_WP_SEO_Redirection\";s:1:\"0\";s:31:\"bfjx9x8i_WP_SEO_Redirection_LOG\";s:1:\"0\";s:20:\"bfjx9x8i_blc_filters\";s:1:\"0\";s:22:\"bfjx9x8i_blc_instances\";s:1:\"0\";s:18:\"bfjx9x8i_blc_links\";s:1:\"0\";s:18:\"bfjx9x8i_blc_synch\";s:1:\"0\";s:20:\"bfjx9x8i_commentmeta\";s:1:\"0\";s:17:\"bfjx9x8i_comments\";s:1:\"0\";s:28:\"bfjx9x8i_duplicator_packages\";s:2:\"35\";s:17:\"bfjx9x8i_eum_logs\";s:3:\"618\";s:22:\"bfjx9x8i_ewwwio_images\";s:1:\"1\";s:34:\"bfjx9x8i_itsec_distributed_storage\";s:1:\"4\";s:27:\"bfjx9x8i_itsec_fingerprints\";s:1:\"0\";s:32:\"bfjx9x8i_itsec_geolocation_cache\";s:1:\"0\";s:23:\"bfjx9x8i_itsec_lockouts\";s:1:\"5\";s:18:\"bfjx9x8i_itsec_log\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_logs\";s:3:\"236\";s:22:\"bfjx9x8i_itsec_mutexes\";s:1:\"0\";s:28:\"bfjx9x8i_itsec_opaque_tokens\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_temp\";s:3:\"807\";s:26:\"bfjx9x8i_itsec_user_groups\";s:1:\"5\";s:14:\"bfjx9x8i_links\";s:1:\"0\";s:16:\"bfjx9x8i_options\";s:3:\"332\";s:17:\"bfjx9x8i_postmeta\";s:1:\"9\";s:14:\"bfjx9x8i_posts\";s:1:\"2\";s:25:\"bfjx9x8i_smush_dir_images\";s:1:\"0\";s:27:\"bfjx9x8i_term_relationships\";s:1:\"0\";s:22:\"bfjx9x8i_term_taxonomy\";s:1:\"1\";s:17:\"bfjx9x8i_termmeta\";s:1:\"0\";s:14:\"bfjx9x8i_terms\";s:1:\"1\";s:17:\"bfjx9x8i_usermeta\";s:2:\"45\";s:14:\"bfjx9x8i_users\";s:1:\"1\";s:28:\"bfjx9x8i_wpfront_ure_options\";s:1:\"3\";s:24:\"bfjx9x8i_yoast_indexable\";s:1:\"7\";s:34:\"bfjx9x8i_yoast_indexable_hierarchy\";s:1:\"0\";s:25:\"bfjx9x8i_yoast_migrations\";s:2:\"17\";s:27:\"bfjx9x8i_yoast_primary_term\";s:1:\"0\";s:24:\"bfjx9x8i_yoast_seo_links\";s:1:\"0\";s:23:\"bfjx9x8i_yoast_seo_meta\";s:1:\"2\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_6573cc39c1a2a6b48973_20201018002133_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-10-18 00:21:33\";s:7:\"Version\";s:6:\"1.3.38\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"6573cc39c1a2a6b48973_20201018002133\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_6573cc39c1a2a6b48973_20201018002133\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:74;s:8:\"Database\";r:86;s:13:\"BuildProgress\";r:163;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("52", "20150620_instalacionweb", "f8bd78de593577965380_20201130102111", "100", "2020-11-30 10:22:30", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-11-30 10:21:11\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:52;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"f8bd78de593577965380_20201130102111\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_f8bd78de593577965380_20201130102111\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_f8bd78de593577965380_20201130102111_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"21.56 sec.\";s:7:\"ExeSize\";s:7:\"61.32KB\";s:7:\"ZipSize\";s:7:\"51.07MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_f8bd78de593577965380_20201130102111_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:53548811;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:9091;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_f8bd78de593577965380_20201130102111_installer.php\";s:4:\"Size\";i:62792;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4779066;s:4:\"File\";s:72:\"20150620_instalacionweb_f8bd78de593577965380_20201130102111_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:42;s:16:\"tablesFinalCount\";i:42;s:14:\"tablesRowCount\";s:5:\"1,805\";s:16:\"tablesSizeOnDisk\";s:6:\"8.66MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.27\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:42:{s:25:\"bfjx9x8i_WP_SEO_404_links\";s:1:\"1\";s:21:\"bfjx9x8i_WP_SEO_Cache\";s:1:\"0\";s:27:\"bfjx9x8i_WP_SEO_Redirection\";s:1:\"0\";s:31:\"bfjx9x8i_WP_SEO_Redirection_LOG\";s:1:\"0\";s:20:\"bfjx9x8i_blc_filters\";s:1:\"0\";s:22:\"bfjx9x8i_blc_instances\";s:1:\"0\";s:18:\"bfjx9x8i_blc_links\";s:1:\"0\";s:18:\"bfjx9x8i_blc_synch\";s:1:\"0\";s:20:\"bfjx9x8i_commentmeta\";s:1:\"0\";s:17:\"bfjx9x8i_comments\";s:1:\"0\";s:25:\"bfjx9x8i_csp3_subscribers\";s:1:\"0\";s:28:\"bfjx9x8i_duplicator_packages\";s:2:\"36\";s:17:\"bfjx9x8i_eum_logs\";s:3:\"665\";s:22:\"bfjx9x8i_ewwwio_images\";s:1:\"1\";s:34:\"bfjx9x8i_itsec_distributed_storage\";s:1:\"4\";s:27:\"bfjx9x8i_itsec_fingerprints\";s:1:\"0\";s:32:\"bfjx9x8i_itsec_geolocation_cache\";s:1:\"0\";s:23:\"bfjx9x8i_itsec_lockouts\";s:1:\"5\";s:18:\"bfjx9x8i_itsec_log\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_logs\";s:3:\"326\";s:22:\"bfjx9x8i_itsec_mutexes\";s:1:\"0\";s:28:\"bfjx9x8i_itsec_opaque_tokens\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_temp\";s:3:\"897\";s:26:\"bfjx9x8i_itsec_user_groups\";s:1:\"5\";s:14:\"bfjx9x8i_links\";s:1:\"0\";s:16:\"bfjx9x8i_options\";s:3:\"343\";s:17:\"bfjx9x8i_postmeta\";s:2:\"13\";s:14:\"bfjx9x8i_posts\";s:1:\"4\";s:25:\"bfjx9x8i_smush_dir_images\";s:1:\"0\";s:27:\"bfjx9x8i_term_relationships\";s:1:\"0\";s:22:\"bfjx9x8i_term_taxonomy\";s:1:\"1\";s:17:\"bfjx9x8i_termmeta\";s:1:\"0\";s:14:\"bfjx9x8i_terms\";s:1:\"1\";s:17:\"bfjx9x8i_usermeta\";s:2:\"45\";s:14:\"bfjx9x8i_users\";s:1:\"1\";s:28:\"bfjx9x8i_wpfront_ure_options\";s:1:\"3\";s:24:\"bfjx9x8i_yoast_indexable\";s:1:\"7\";s:34:\"bfjx9x8i_yoast_indexable_hierarchy\";s:1:\"0\";s:25:\"bfjx9x8i_yoast_migrations\";s:2:\"17\";s:27:\"bfjx9x8i_yoast_primary_term\";s:1:\"0\";s:24:\"bfjx9x8i_yoast_seo_links\";s:1:\"0\";s:23:\"bfjx9x8i_yoast_seo_meta\";s:1:\"2\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_f8bd78de593577965380_20201130102111_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2020-11-30 10:21:11\";s:7:\"Version\";s:6:\"1.3.40\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.27\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"f8bd78de593577965380_20201130102111\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_f8bd78de593577965380_20201130102111\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:74;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:166;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("53", "20150620_instalacionweb", "6bd9a4797537b9497593_20210217063332", "100", "2021-02-17 06:33:49", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-02-17 06:33:32\";s:7:\"Version\";s:8:\"1.3.40.1\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:53;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"6bd9a4797537b9497593_20210217063332\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_6bd9a4797537b9497593_20210217063332\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_6bd9a4797537b9497593_20210217063332_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"73.35 sec.\";s:7:\"ExeSize\";s:7:\"61.29KB\";s:7:\"ZipSize\";s:7:\"51.73MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_6bd9a4797537b9497593_20210217063332_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:54240347;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:8993;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_6bd9a4797537b9497593_20210217063332_installer.php\";s:4:\"Size\";i:62764;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4893839;s:4:\"File\";s:72:\"20150620_instalacionweb_6bd9a4797537b9497593_20210217063332_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:42;s:16:\"tablesFinalCount\";i:42;s:14:\"tablesRowCount\";s:5:\"1,943\";s:16:\"tablesSizeOnDisk\";s:6:\"8.73MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.33\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:42:{s:25:\"bfjx9x8i_WP_SEO_404_links\";s:1:\"1\";s:21:\"bfjx9x8i_WP_SEO_Cache\";s:1:\"0\";s:27:\"bfjx9x8i_WP_SEO_Redirection\";s:1:\"0\";s:31:\"bfjx9x8i_WP_SEO_Redirection_LOG\";s:1:\"0\";s:20:\"bfjx9x8i_blc_filters\";s:1:\"0\";s:22:\"bfjx9x8i_blc_instances\";s:1:\"0\";s:18:\"bfjx9x8i_blc_links\";s:1:\"0\";s:18:\"bfjx9x8i_blc_synch\";s:1:\"0\";s:20:\"bfjx9x8i_commentmeta\";s:1:\"0\";s:17:\"bfjx9x8i_comments\";s:1:\"0\";s:25:\"bfjx9x8i_csp3_subscribers\";s:1:\"0\";s:28:\"bfjx9x8i_duplicator_packages\";s:2:\"37\";s:17:\"bfjx9x8i_eum_logs\";s:3:\"714\";s:22:\"bfjx9x8i_ewwwio_images\";s:1:\"1\";s:34:\"bfjx9x8i_itsec_distributed_storage\";s:1:\"4\";s:27:\"bfjx9x8i_itsec_fingerprints\";s:1:\"0\";s:32:\"bfjx9x8i_itsec_geolocation_cache\";s:1:\"0\";s:23:\"bfjx9x8i_itsec_lockouts\";s:1:\"5\";s:18:\"bfjx9x8i_itsec_log\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_logs\";s:3:\"414\";s:22:\"bfjx9x8i_itsec_mutexes\";s:1:\"0\";s:28:\"bfjx9x8i_itsec_opaque_tokens\";s:1:\"0\";s:19:\"bfjx9x8i_itsec_temp\";s:3:\"985\";s:26:\"bfjx9x8i_itsec_user_groups\";s:1:\"5\";s:14:\"bfjx9x8i_links\";s:1:\"0\";s:16:\"bfjx9x8i_options\";s:3:\"343\";s:17:\"bfjx9x8i_postmeta\";s:2:\"13\";s:14:\"bfjx9x8i_posts\";s:1:\"4\";s:25:\"bfjx9x8i_smush_dir_images\";s:1:\"0\";s:27:\"bfjx9x8i_term_relationships\";s:1:\"0\";s:22:\"bfjx9x8i_term_taxonomy\";s:1:\"1\";s:17:\"bfjx9x8i_termmeta\";s:1:\"0\";s:14:\"bfjx9x8i_terms\";s:1:\"1\";s:17:\"bfjx9x8i_usermeta\";s:2:\"45\";s:14:\"bfjx9x8i_users\";s:1:\"1\";s:28:\"bfjx9x8i_wpfront_ure_options\";s:1:\"3\";s:24:\"bfjx9x8i_yoast_indexable\";s:1:\"7\";s:34:\"bfjx9x8i_yoast_indexable_hierarchy\";s:1:\"0\";s:25:\"bfjx9x8i_yoast_migrations\";s:2:\"17\";s:27:\"bfjx9x8i_yoast_primary_term\";s:1:\"0\";s:24:\"bfjx9x8i_yoast_seo_links\";s:1:\"0\";s:23:\"bfjx9x8i_yoast_seo_meta\";s:1:\"2\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_6bd9a4797537b9497593_20210217063332_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-02-17 06:33:32\";s:7:\"Version\";s:8:\"1.3.40.1\";s:9:\"VersionWP\";s:5:\"5.3.2\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"6bd9a4797537b9497593_20210217063332\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_6bd9a4797537b9497593_20210217063332\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:74;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:166;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("54", "20150620_instalacionweb", "b0c132608d52a0298083_20210223143923", "100", "2021-02-23 14:39:40", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-02-23 14:39:23\";s:7:\"Version\";s:8:\"1.3.40.1\";s:9:\"VersionWP\";s:5:\"5.6.2\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:54;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"b0c132608d52a0298083_20210223143923\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_b0c132608d52a0298083_20210223143923\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_b0c132608d52a0298083_20210223143923_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"31.13 sec.\";s:7:\"ExeSize\";s:7:\"61.29KB\";s:7:\"ZipSize\";s:7:\"56.15MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_b0c132608d52a0298083_20210223143923_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:58876228;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:9444;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_b0c132608d52a0298083_20210223143923_installer.php\";s:4:\"Size\";i:62764;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4918032;s:4:\"File\";s:72:\"20150620_instalacionweb_b0c132608d52a0298083_20210223143923_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:42;s:16:\"tablesFinalCount\";i:42;s:14:\"tablesRowCount\";s:5:\"1,971\";s:16:\"tablesSizeOnDisk\";s:6:\"8.74MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.33\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:42:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"38\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"720\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"4\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"5\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:3:\"430\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:4:\"1001\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"348\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:1:\"4\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"0\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"17\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_b0c132608d52a0298083_20210223143923_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-02-23 14:39:23\";s:7:\"Version\";s:8:\"1.3.40.1\";s:9:\"VersionWP\";s:5:\"5.6.2\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"b0c132608d52a0298083_20210223143923\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_b0c132608d52a0298083_20210223143923\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:74;s:8:\"Database\";r:88;s:13:\"BuildProgress\";r:166;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("55", "20150620_instalacionweb", "ad5a2f0faccb85156912_20210401063357", "100", "2021-04-01 06:34:22", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-04-01 06:33:57\";s:7:\"Version\";s:5:\"1.4.0\";s:9:\"VersionWP\";s:3:\"5.7\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:55;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"ad5a2f0faccb85156912_20210401063357\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_ad5a2f0faccb85156912_20210401063357\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_ad5a2f0faccb85156912_20210401063357_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"23.80 sec.\";s:7:\"ExeSize\";s:7:\"63.96KB\";s:7:\"ZipSize\";s:7:\"57.98MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_ad5a2f0faccb85156912_20210401063357_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:60799462;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:9728;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_ad5a2f0faccb85156912_20210401063357_installer.php\";s:4:\"Size\";i:65492;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:3252834;s:4:\"File\";s:72:\"20150620_instalacionweb_ad5a2f0faccb85156912_20210401063357_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:43;s:16:\"tablesFinalCount\";i:43;s:14:\"tablesRowCount\";s:5:\"1,624\";s:16:\"tablesSizeOnDisk\";s:6:\"8.77MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.33\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:42:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"39\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"770\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"4\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"5\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"28\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:4:\"1023\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:1:\"4\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"1\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"21\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_ad5a2f0faccb85156912_20210401063357_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-04-01 06:33:57\";s:7:\"Version\";s:5:\"1.4.0\";s:9:\"VersionWP\";s:3:\"5.7\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"ad5a2f0faccb85156912_20210401063357\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_ad5a2f0faccb85156912_20210401063357\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:169;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("56", "20150620_instalacionweb", "3566c276cf244ae06797_20210419145757", "100", "2021-04-19 14:58:10", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-04-19 14:57:57\";s:7:\"Version\";s:5:\"1.4.0\";s:9:\"VersionWP\";s:5:\"5.7.1\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:56;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"3566c276cf244ae06797_20210419145757\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_3566c276cf244ae06797_20210419145757\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_3566c276cf244ae06797_20210419145757_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"24.12 sec.\";s:7:\"ExeSize\";s:7:\"63.96KB\";s:7:\"ZipSize\";s:7:\"58.19MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_3566c276cf244ae06797_20210419145757_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:61016784;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:9716;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_3566c276cf244ae06797_20210419145757_installer.php\";s:4:\"Size\";i:65492;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:5203260;s:4:\"File\";s:72:\"20150620_instalacionweb_3566c276cf244ae06797_20210419145757_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:43;s:16:\"tablesFinalCount\";i:43;s:14:\"tablesRowCount\";s:5:\"1,668\";s:16:\"tablesSizeOnDisk\";s:6:\"8.77MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.33\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:43:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"40\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"788\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:2:\"17\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"5\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"43\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:4:\"1046\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"347\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:1:\"4\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"1\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"21\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_3566c276cf244ae06797_20210419145757_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-04-19 14:57:57\";s:7:\"Version\";s:5:\"1.4.0\";s:9:\"VersionWP\";s:5:\"5.7.1\";s:9:\"VersionDB\";s:6:\"5.7.33\";s:10:\"VersionPHP\";s:6:\"7.0.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"3566c276cf244ae06797_20210419145757\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_3566c276cf244ae06797_20210419145757\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:170;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("57", "20150620_instalacionweb", "ab7c6d2f012f4ca62592_20210526051302", "100", "2021-05-26 05:13:33", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-05-26 05:13:02\";s:7:\"Version\";s:5:\"1.4.0\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.3.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:57;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"ab7c6d2f012f4ca62592_20210526051302\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_ab7c6d2f012f4ca62592_20210526051302\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_ab7c6d2f012f4ca62592_20210526051302_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"67.48 sec.\";s:7:\"ExeSize\";s:7:\"63.96KB\";s:7:\"ZipSize\";s:7:\"58.49MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_ab7c6d2f012f4ca62592_20210526051302_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:61336143;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:9700;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_ab7c6d2f012f4ca62592_20210526051302_installer.php\";s:4:\"Size\";i:65492;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:3960032;s:4:\"File\";s:72:\"20150620_instalacionweb_ab7c6d2f012f4ca62592_20210526051302_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:43;s:16:\"tablesFinalCount\";i:43;s:14:\"tablesRowCount\";s:5:\"1,743\";s:16:\"tablesSizeOnDisk\";s:6:\"9.86MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.34\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:43:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"41\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"803\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"4\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"5\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:3:\"118\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:4:\"1102\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"345\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:1:\"4\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"1\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"21\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_ab7c6d2f012f4ca62592_20210526051302_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-05-26 05:13:02\";s:7:\"Version\";s:5:\"1.4.0\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.3.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"ab7c6d2f012f4ca62592_20210526051302\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_ab7c6d2f012f4ca62592_20210526051302\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:170;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("58", "20150620_instalacionweb", "d795e189ede61cd03163_20210531150247", "100", "2021-05-31 15:03:00", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-05-31 15:02:47\";s:7:\"Version\";s:5:\"1.4.1\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.3.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:58;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"d795e189ede61cd03163_20210531150247\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_d795e189ede61cd03163_20210531150247\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_d795e189ede61cd03163_20210531150247_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"30.97 sec.\";s:7:\"ExeSize\";s:7:\"64.14KB\";s:7:\"ZipSize\";s:7:\"57.14MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_d795e189ede61cd03163_20210531150247_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:59918660;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:11773;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_d795e189ede61cd03163_20210531150247_installer.php\";s:4:\"Size\";i:65684;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:3980475;s:4:\"File\";s:72:\"20150620_instalacionweb_d795e189ede61cd03163_20210531150247_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:43;s:16:\"tablesFinalCount\";i:43;s:14:\"tablesRowCount\";s:5:\"1,758\";s:16:\"tablesSizeOnDisk\";s:6:\"9.87MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.34\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:43:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"42\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"809\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"4\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"5\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:3:\"127\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:4:\"1111\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"346\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:1:\"4\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"1\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"21\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_d795e189ede61cd03163_20210531150247_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-05-31 15:02:47\";s:7:\"Version\";s:5:\"1.4.1\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.3.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"d795e189ede61cd03163_20210531150247\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_d795e189ede61cd03163_20210531150247\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:170;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("59", "20150620_instalacionweb", "0210c8e767ec34153695_20210630094113", "100", "2021-06-30 09:41:32", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-06-30 09:41:13\";s:7:\"Version\";s:5:\"1.4.1\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.3.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:59;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"0210c8e767ec34153695_20210630094113\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_0210c8e767ec34153695_20210630094113\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_0210c8e767ec34153695_20210630094113_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"36.28 sec.\";s:7:\"ExeSize\";s:7:\"64.14KB\";s:7:\"ZipSize\";s:7:\"57.44MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_0210c8e767ec34153695_20210630094113_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:60233470;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:11925;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_0210c8e767ec34153695_20210630094113_installer.php\";s:4:\"Size\";i:65684;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4374796;s:4:\"File\";s:72:\"20150620_instalacionweb_0210c8e767ec34153695_20210630094113_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:43;s:16:\"tablesFinalCount\";i:43;s:14:\"tablesRowCount\";s:5:\"1,815\";s:16:\"tablesSizeOnDisk\";s:7:\"10.17MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.34\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:43:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"43\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"838\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"4\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"5\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:3:\"155\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:4:\"1139\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"345\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:1:\"4\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"1\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"21\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_0210c8e767ec34153695_20210630094113_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-06-30 09:41:13\";s:7:\"Version\";s:5:\"1.4.1\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:6:\"5.7.34\";s:10:\"VersionPHP\";s:6:\"7.3.28\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"0210c8e767ec34153695_20210630094113\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_0210c8e767ec34153695_20210630094113\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:170;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("60", "20150620_instalacionweb", "58abc6335402d64b9689_20210720065712", "100", "2021-07-20 06:57:29", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-07-20 06:57:12\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.3.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:60;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"58abc6335402d64b9689_20210720065712\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_58abc6335402d64b9689_20210720065712\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_58abc6335402d64b9689_20210720065712_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"33.91 sec.\";s:7:\"ExeSize\";s:7:\"64.26KB\";s:7:\"ZipSize\";s:7:\"58.01MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_58abc6335402d64b9689_20210720065712_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:60825333;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:11945;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_58abc6335402d64b9689_20210720065712_installer.php\";s:4:\"Size\";i:65805;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:4790898;s:4:\"File\";s:72:\"20150620_instalacionweb_58abc6335402d64b9689_20210720065712_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:43;s:16:\"tablesFinalCount\";i:43;s:14:\"tablesRowCount\";s:5:\"1,831\";s:16:\"tablesSizeOnDisk\";s:7:\"10.52MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.35\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:42:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"44\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"853\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"4\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"5\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:3:\"158\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:4:\"1142\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:1:\"4\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"1\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"21\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_58abc6335402d64b9689_20210720065712_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-07-20 06:57:12\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:5:\"5.7.2\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.3.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"58abc6335402d64b9689_20210720065712\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_58abc6335402d64b9689_20210720065712\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:169;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("61", "20150620_instalacionweb", "05fc63a915aa52852206_20210901071244", "100", "2021-09-01 07:13:23", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-09-01 07:12:44\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:3:\"5.8\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.3.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:61;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"05fc63a915aa52852206_20210901071244\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_05fc63a915aa52852206_20210901071244\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_05fc63a915aa52852206_20210901071244_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"34.73 sec.\";s:7:\"ExeSize\";s:7:\"64.26KB\";s:7:\"ZipSize\";s:7:\"58.63MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_05fc63a915aa52852206_20210901071244_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:61477657;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:12991;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_05fc63a915aa52852206_20210901071244_installer.php\";s:4:\"Size\";i:65805;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:6589028;s:4:\"File\";s:72:\"20150620_instalacionweb_05fc63a915aa52852206_20210901071244_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:44;s:16:\"tablesFinalCount\";i:44;s:14:\"tablesRowCount\";s:5:\"1,425\";s:16:\"tablesSizeOnDisk\";s:7:\"12.02MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.35\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:44:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"45\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"893\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"1\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"41\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"352\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:1:\"4\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"2\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"21\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_05fc63a915aa52852206_20210901071244_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-09-01 07:12:44\";s:7:\"Version\";s:5:\"1.4.2\";s:9:\"VersionWP\";s:3:\"5.8\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.3.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"05fc63a915aa52852206_20210901071244\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_05fc63a915aa52852206_20210901071244\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:171;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("62", "20150620_instalacionweb", "ca76a5ad58c45da73003_20210929095158", "100", "2021-09-29 09:52:12", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-09-29 09:51:58\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.1\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.4.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:62;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"ca76a5ad58c45da73003_20210929095158\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_ca76a5ad58c45da73003_20210929095158\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_ca76a5ad58c45da73003_20210929095158_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"39.37 sec.\";s:7:\"ExeSize\";s:7:\"64.26KB\";s:7:\"ZipSize\";s:7:\"57.26MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_ca76a5ad58c45da73003_20210929095158_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:60044230;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:12963;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_ca76a5ad58c45da73003_20210929095158_installer.php\";s:4:\"Size\";i:65805;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:7450031;s:4:\"File\";s:72:\"20150620_instalacionweb_ca76a5ad58c45da73003_20210929095158_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:44;s:16:\"tablesFinalCount\";i:44;s:14:\"tablesRowCount\";s:5:\"1,505\";s:16:\"tablesSizeOnDisk\";s:6:\"12.7MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.35\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:43:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"46\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"925\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"2\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"92\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:1:\"4\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"2\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"21\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_ca76a5ad58c45da73003_20210929095158_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-09-29 09:51:58\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.1\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.4.23\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"ca76a5ad58c45da73003_20210929095158\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_ca76a5ad58c45da73003_20210929095158\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:170;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("63", "20150620_instalacionweb", "c22158b64202487b1173_20211021050511", "100", "2021-10-21 05:06:06", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-10-21 05:05:11\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.1\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.4.24\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:63;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"c22158b64202487b1173_20211021050511\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_c22158b64202487b1173_20211021050511\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_c22158b64202487b1173_20211021050511_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:11:\"301.60 sec.\";s:7:\"ExeSize\";s:7:\"64.26KB\";s:7:\"ZipSize\";s:7:\"57.47MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_c22158b64202487b1173_20211021050511_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:60260278;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13020;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_c22158b64202487b1173_20211021050511_installer.php\";s:4:\"Size\";i:65805;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:7913124;s:4:\"File\";s:72:\"20150620_instalacionweb_c22158b64202487b1173_20211021050511_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:14:\"tablesRowCount\";s:5:\"1,537\";s:16:\"tablesSizeOnDisk\";s:7:\"13.11MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.35\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"47\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"946\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"2\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"92\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"350\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";s:1:\"0\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:2:\"10\";s:32:\"p0aadmzbh8_wpfront_ure_post_type\";s:1:\"0\";s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"4\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"22\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_c22158b64202487b1173_20211021050511_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-10-21 05:05:11\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.1\";s:9:\"VersionDB\";s:6:\"5.7.35\";s:10:\"VersionPHP\";s:6:\"7.4.24\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"c22158b64202487b1173_20211021050511\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_c22158b64202487b1173_20211021050511\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:174;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("64", "20150620_instalacionweb", "885d813e86e8e36a7213_20211115112616", "100", "2021-11-15 11:27:10", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-11-15 11:26:16\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.2\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.25\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:64;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"885d813e86e8e36a7213_20211115112616\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_885d813e86e8e36a7213_20211115112616\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_885d813e86e8e36a7213_20211115112616_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"39.10 sec.\";s:7:\"ExeSize\";s:7:\"64.26KB\";s:7:\"ZipSize\";s:6:\"58.1MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_885d813e86e8e36a7213_20211115112616_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:60918295;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13045;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_885d813e86e8e36a7213_20211115112616_installer.php\";s:4:\"Size\";i:65805;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:8034968;s:4:\"File\";s:72:\"20150620_instalacionweb_885d813e86e8e36a7213_20211115112616_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:14:\"tablesRowCount\";s:5:\"1,547\";s:16:\"tablesSizeOnDisk\";s:6:\"13.2MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"48\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"956\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"2\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"92\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"349\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";s:1:\"0\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:2:\"10\";s:32:\"p0aadmzbh8_wpfront_ure_post_type\";s:1:\"0\";s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"4\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"22\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_885d813e86e8e36a7213_20211115112616_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-11-15 11:26:16\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.2\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.25\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"885d813e86e8e36a7213_20211115112616\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_885d813e86e8e36a7213_20211115112616\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:174;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("65", "20150620_instalacionweb", "5c432bb2ef894cfc9550_20220111155324", "100", "2022-01-11 15:53:42", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-01-11 15:53:24\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.3\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:65;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"5c432bb2ef894cfc9550_20220111155324\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_5c432bb2ef894cfc9550_20220111155324\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_5c432bb2ef894cfc9550_20220111155324_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"36.07 sec.\";s:7:\"ExeSize\";s:7:\"64.26KB\";s:7:\"ZipSize\";s:7:\"58.45MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_5c432bb2ef894cfc9550_20220111155324_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:61291689;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13099;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_5c432bb2ef894cfc9550_20220111155324_installer.php\";s:4:\"Size\";i:65805;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:8693748;s:4:\"File\";s:72:\"20150620_instalacionweb_5c432bb2ef894cfc9550_20220111155324_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:14:\"tablesRowCount\";s:5:\"1,587\";s:16:\"tablesSizeOnDisk\";s:7:\"13.77MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"49\";s:19:\"p0aadmzbh8_eum_logs\";s:3:\"996\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"2\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"92\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"349\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";s:1:\"0\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:2:\"10\";s:32:\"p0aadmzbh8_wpfront_ure_post_type\";s:1:\"0\";s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"4\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"23\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_5c432bb2ef894cfc9550_20220111155324_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-01-11 15:53:24\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.3\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"5c432bb2ef894cfc9550_20220111155324\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_5c432bb2ef894cfc9550_20220111155324\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:174;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("66", "20150620_instalacionweb", "cfa01d55e87b25d34812_20220211063336", "100", "2022-02-11 06:34:09", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-02-11 06:33:36\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:3:\"5.9\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:66;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"cfa01d55e87b25d34812_20220211063336\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_cfa01d55e87b25d34812_20220211063336\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_cfa01d55e87b25d34812_20220211063336_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"30.31 sec.\";s:7:\"ExeSize\";s:6:\"64.6KB\";s:7:\"ZipSize\";s:6:\"68.1MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_cfa01d55e87b25d34812_20220211063336_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:71408106;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13536;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_cfa01d55e87b25d34812_20220211063336_installer.php\";s:4:\"Size\";i:66149;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:9620535;s:4:\"File\";s:72:\"20150620_instalacionweb_cfa01d55e87b25d34812_20220211063336_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:14:\"tablesRowCount\";s:5:\"1,623\";s:16:\"tablesSizeOnDisk\";s:7:\"14.56MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"50\";s:19:\"p0aadmzbh8_eum_logs\";s:4:\"1031\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"2\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"92\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"350\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";s:1:\"0\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:2:\"10\";s:32:\"p0aadmzbh8_wpfront_ure_post_type\";s:1:\"0\";s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"4\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"23\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_cfa01d55e87b25d34812_20220211063336_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-02-11 06:33:36\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:3:\"5.9\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"cfa01d55e87b25d34812_20220211063336\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_cfa01d55e87b25d34812_20220211063336\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:174;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("67", "20150620_instalacionweb", "18bbfa3a33c055523874_20220303093403", "100", "2022-03-03 09:34:21", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-03-03 09:34:03\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.1\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:67;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"18bbfa3a33c055523874_20220303093403\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_18bbfa3a33c055523874_20220303093403\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_18bbfa3a33c055523874_20220303093403_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"39.60 sec.\";s:7:\"ExeSize\";s:6:\"64.6KB\";s:7:\"ZipSize\";s:7:\"68.19MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_18bbfa3a33c055523874_20220303093403_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:71504267;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13540;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_18bbfa3a33c055523874_20220303093403_installer.php\";s:4:\"Size\";i:66149;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:9937288;s:4:\"File\";s:72:\"20150620_instalacionweb_18bbfa3a33c055523874_20220303093403_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:14:\"tablesRowCount\";s:5:\"1,638\";s:16:\"tablesSizeOnDisk\";s:7:\"14.78MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"51\";s:19:\"p0aadmzbh8_eum_logs\";s:4:\"1045\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"2\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"92\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"352\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";s:1:\"0\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:2:\"10\";s:32:\"p0aadmzbh8_wpfront_ure_post_type\";s:1:\"0\";s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"4\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"23\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_18bbfa3a33c055523874_20220303093403_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-03-03 09:34:03\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.1\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"18bbfa3a33c055523874_20220303093403\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_18bbfa3a33c055523874_20220303093403\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:174;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("68", "20150620_instalacionweb", "16b8becc81581f892626_20220309060447", "100", "2022-03-09 06:06:07", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-03-09 06:04:47\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.1\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:68;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"16b8becc81581f892626_20220309060447\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_16b8becc81581f892626_20220309060447\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_16b8becc81581f892626_20220309060447_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:11:\"134.64 sec.\";s:7:\"ExeSize\";s:6:\"64.6KB\";s:7:\"ZipSize\";s:7:\"68.25MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_16b8becc81581f892626_20220309060447_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:71569041;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13570;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:36:\"/home/solucion/wp/wp-content/uploads\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";i:3;s:35:\"/home/solucion/wp/wp-content/themes\";i:4;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_16b8becc81581f892626_20220309060447_installer.php\";s:4:\"Size\";i:66149;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:10069200;s:4:\"File\";s:72:\"20150620_instalacionweb_16b8becc81581f892626_20220309060447_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:5:{i:0;s:17:\"latin1_swedish_ci\";i:1;s:18:\"utf8mb4_unicode_ci\";i:2;s:22:\"utf8mb4_unicode_520_ci\";i:3;s:18:\"utf8mb4_general_ci\";i:4;s:15:\"utf8_general_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:14:\"tablesRowCount\";s:5:\"1,645\";s:16:\"tablesSizeOnDisk\";s:7:\"14.88MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"5.7.36\";s:14:\"versionComment\";s:28:\"MySQL Community Server (GPL)\";s:18:\"tableWiseRowCounts\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"52\";s:19:\"p0aadmzbh8_eum_logs\";s:4:\"1052\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"2\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"92\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"352\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";s:1:\"0\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:2:\"10\";s:32:\"p0aadmzbh8_wpfront_ure_post_type\";s:1:\"0\";s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"4\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"23\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_16b8becc81581f892626_20220309060447_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-03-09 06:04:47\";s:7:\"Version\";s:5:\"1.4.4\";s:9:\"VersionWP\";s:5:\"5.9.1\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.27\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"16b8becc81581f892626_20220309060447\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_16b8becc81581f892626_20220309060447\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:76;s:8:\"Database\";r:90;s:13:\"BuildProgress\";r:174;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("69", "20150620_instalacionweb", "f7b64edd1b11683b1940_20220607051851", "100", "2022-06-07 05:19:00", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-06-07 05:18:51\";s:7:\"Version\";s:5:\"1.4.6\";s:9:\"VersionWP\";s:3:\"6.0\";s:9:\"VersionDB\";s:6:\"8.0.29\";s:10:\"VersionPHP\";s:6:\"7.4.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:69;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"f7b64edd1b11683b1940_20220607051851\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_f7b64edd1b11683b1940_20220607051851\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_f7b64edd1b11683b1940_20220607051851_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"10.60 sec.\";s:7:\"ExeSize\";s:6:\"64.6KB\";s:7:\"ZipSize\";s:6:\"48.7MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_f7b64edd1b11683b1940_20220607051851_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:51070782;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13201;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:38:\"/home/solucion/wp/wp-content/languages\";i:2;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:5:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";i:2;s:36:\"/home/solucion/wp/wp-content/uploads\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_f7b64edd1b11683b1940_20220607051851_installer.php\";s:4:\"Size\";i:66149;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:11863600;s:4:\"File\";s:72:\"20150620_instalacionweb_f7b64edd1b11683b1940_20220607051851_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:8:{i:0;s:17:\"latin1_general_cs\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:8:\"utf8_bin\";i:3;s:15:\"utf8_general_ci\";i:4;s:15:\"utf8_unicode_ci\";i:5;s:18:\"utf8mb4_0900_ai_ci\";i:6;s:22:\"utf8mb4_unicode_520_ci\";i:7;s:18:\"utf8mb4_unicode_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:14:\"tablesRowCount\";s:5:\"1,730\";s:16:\"tablesSizeOnDisk\";s:7:\"12.42MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"8.0.29\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:18:\"tableWiseRowCounts\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"53\";s:19:\"p0aadmzbh8_eum_logs\";s:4:\"1139\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"2\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"92\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"353\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";s:1:\"0\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:2:\"10\";s:32:\"p0aadmzbh8_wpfront_ure_post_type\";s:1:\"0\";s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"4\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"23\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_f7b64edd1b11683b1940_20220607051851_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-06-07 05:18:51\";s:7:\"Version\";s:5:\"1.4.6\";s:9:\"VersionWP\";s:3:\"6.0\";s:9:\"VersionDB\";s:6:\"8.0.29\";s:10:\"VersionPHP\";s:6:\"7.4.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"f7b64edd1b11683b1940_20220607051851\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_f7b64edd1b11683b1940_20220607051851\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:77;s:8:\"Database\";r:91;s:13:\"BuildProgress\";r:178;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("70", "20150620_instalacionweb", "cc3e91e60f2458ab1935_20220714093940", "100", "2022-07-14 09:41:08", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-07-14 09:39:40\";s:7:\"Version\";s:5:\"1.4.7\";s:9:\"VersionWP\";s:5:\"6.0.1\";s:9:\"VersionDB\";s:6:\"8.0.29\";s:10:\"VersionPHP\";s:6:\"7.4.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:70;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"cc3e91e60f2458ab1935_20220714093940\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_cc3e91e60f2458ab1935_20220714093940\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_cc3e91e60f2458ab1935_20220714093940_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"28.74 sec.\";s:7:\"ExeSize\";s:6:\"64.6KB\";s:7:\"ZipSize\";s:7:\"49.21MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":23:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_cc3e91e60f2458ab1935_20220714093940_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:51604246;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13304;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:38:\"/home/solucion/wp/wp-content/languages\";i:2;s:29:\"/home/solucion/wp/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:5:{i:0;s:17:\"/home/solucion/wp\";i:1;s:28:\"/home/solucion/wp/wp-content\";i:2;s:36:\"/home/solucion/wp/wp-content/uploads\";i:3;s:36:\"/home/solucion/wp/wp-content/plugins\";i:4;s:35:\"/home/solucion/wp/wp-content/themes\";}s:19:\"isOuterWPContentDir\";b:0;s:25:\"wpContentDirNormalizePath\";s:29:\"/home/solucion/wp/wp-content/\";}s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:73:\"20150620_instalacionweb_cc3e91e60f2458ab1935_20220714093940_installer.php\";s:4:\"Size\";i:66149;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:12355201;s:4:\"File\";s:72:\"20150620_instalacionweb_cc3e91e60f2458ab1935_20220714093940_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";s:3:\"PHP\";s:13:\"collationList\";a:8:{i:0;s:17:\"latin1_general_cs\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:8:\"utf8_bin\";i:3;s:15:\"utf8_general_ci\";i:4;s:15:\"utf8_unicode_ci\";i:5;s:18:\"utf8mb4_0900_ai_ci\";i:6;s:22:\"utf8mb4_unicode_520_ci\";i:7;s:18:\"utf8mb4_unicode_ci\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:14:\"tablesRowCount\";s:5:\"1,786\";s:16:\"tablesSizeOnDisk\";s:7:\"12.86MB\";s:18:\"varLowerCaseTables\";s:1:\"0\";s:7:\"version\";s:6:\"8.0.29\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:18:\"tableWiseRowCounts\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";s:1:\"1\";s:23:\"p0aadmzbh8_WP_SEO_Cache\";s:1:\"0\";s:29:\"p0aadmzbh8_WP_SEO_Redirection\";s:1:\"0\";s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";s:1:\"0\";s:22:\"p0aadmzbh8_blc_filters\";s:1:\"0\";s:24:\"p0aadmzbh8_blc_instances\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_links\";s:1:\"0\";s:20:\"p0aadmzbh8_blc_synch\";s:1:\"0\";s:22:\"p0aadmzbh8_commentmeta\";s:1:\"0\";s:19:\"p0aadmzbh8_comments\";s:1:\"0\";s:27:\"p0aadmzbh8_csp3_subscribers\";s:1:\"0\";s:30:\"p0aadmzbh8_duplicator_packages\";s:2:\"54\";s:19:\"p0aadmzbh8_eum_logs\";s:4:\"1174\";s:24:\"p0aadmzbh8_ewwwio_images\";s:1:\"1\";s:21:\"p0aadmzbh8_itsec_bans\";s:1:\"0\";s:33:\"p0aadmzbh8_itsec_dashboard_events\";s:1:\"2\";s:36:\"p0aadmzbh8_itsec_distributed_storage\";s:1:\"5\";s:29:\"p0aadmzbh8_itsec_fingerprints\";s:1:\"0\";s:34:\"p0aadmzbh8_itsec_geolocation_cache\";s:1:\"0\";s:25:\"p0aadmzbh8_itsec_lockouts\";s:1:\"0\";s:20:\"p0aadmzbh8_itsec_log\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_logs\";s:2:\"92\";s:24:\"p0aadmzbh8_itsec_mutexes\";s:1:\"0\";s:30:\"p0aadmzbh8_itsec_opaque_tokens\";s:1:\"0\";s:21:\"p0aadmzbh8_itsec_temp\";s:1:\"2\";s:28:\"p0aadmzbh8_itsec_user_groups\";s:1:\"5\";s:16:\"p0aadmzbh8_links\";s:1:\"0\";s:18:\"p0aadmzbh8_options\";s:3:\"352\";s:19:\"p0aadmzbh8_postmeta\";s:2:\"13\";s:16:\"p0aadmzbh8_posts\";s:1:\"4\";s:27:\"p0aadmzbh8_smush_dir_images\";s:1:\"0\";s:29:\"p0aadmzbh8_term_relationships\";s:1:\"0\";s:24:\"p0aadmzbh8_term_taxonomy\";s:1:\"1\";s:19:\"p0aadmzbh8_termmeta\";s:1:\"0\";s:16:\"p0aadmzbh8_terms\";s:1:\"1\";s:19:\"p0aadmzbh8_usermeta\";s:2:\"45\";s:16:\"p0aadmzbh8_users\";s:1:\"1\";s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";s:1:\"0\";s:30:\"p0aadmzbh8_wpfront_ure_options\";s:2:\"10\";s:32:\"p0aadmzbh8_wpfront_ure_post_type\";s:1:\"0\";s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_indexable\";s:1:\"7\";s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";s:1:\"4\";s:27:\"p0aadmzbh8_yoast_migrations\";s:2:\"23\";s:29:\"p0aadmzbh8_yoast_primary_term\";s:1:\"0\";s:26:\"p0aadmzbh8_yoast_seo_links\";s:1:\"0\";s:25:\"p0aadmzbh8_yoast_seo_meta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_cc3e91e60f2458ab1935_20220714093940_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-07-14 09:39:40\";s:7:\"Version\";s:5:\"1.4.7\";s:9:\"VersionWP\";s:5:\"6.0.1\";s:9:\"VersionDB\";s:6:\"8.0.29\";s:10:\"VersionPHP\";s:6:\"7.4.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"cc3e91e60f2458ab1935_20220714093940\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_cc3e91e60f2458ab1935_20220714093940\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:77;s:8:\"Database\";r:91;s:13:\"BuildProgress\";r:178;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("71", "20150620_instalacionweb", "cafa9bf099d2f7405281_20220928113607", "100", "2022-09-28 11:36:50", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-09-28 11:36:07\";s:7:\"Version\";s:5:\"1.5.0\";s:9:\"VersionWP\";s:5:\"6.0.2\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"7.4.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:71;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"cafa9bf099d2f7405281_20220928113607\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_cafa9bf099d2f7405281_20220928113607\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:69:\"20150620_instalacionweb_cafa9bf099d2f7405281_20220928113607_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"34.37 sec.\";s:7:\"ExeSize\";s:7:\"73.36KB\";s:7:\"ZipSize\";s:7:\"51.86MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:71:\"20150620_instalacionweb_cafa9bf099d2f7405281_20220928113607_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:54382627;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2721;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11213;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:13933;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:29:\"/home/solucion/wp/wp-includes\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:17:\"/home/solucion/wp\";i:1;s:17:\"/home/solucion/wp\";i:2;s:28:\"/home/solucion/wp/wp-content\";i:3;s:36:\"/home/solucion/wp/wp-content/uploads\";i:4;s:36:\"/home/solucion/wp/wp-content/plugins\";i:5;s:39:\"/home/solucion/wp/wp-content/mu-plugins\";i:6;s:35:\"/home/solucion/wp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:34:\"/home/solucion/wp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:77:\"20150620_instalacionweb_cafa9bf099d2f7405281_20220928113607_installer.php.bak\";s:4:\"Size\";i:75121;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:86:\"/home/solucion/wp/wp-snapshots/tmp/original_files_cafa9bf-28113607/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:66:\"/home/solucion/wp/wp-snapshots/tmp/original_files_cafa9bf-28113607\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:17:\"/home/solucion/wp\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:31:\"/home/solucion/wp/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3505:\"<?php\n\n// BEGIN iThemes Security - No modifiques ni borres esta línea\n// iThemes Security Config Details: 2\ndefine( \'DISALLOW_FILE_EDIT\', true ); // Desactivar editor de archivos - Seguridad > Ajustes > Ajustes WordPress > Editor de archivos\n// END iThemes Security - No modifiques ni borres esta línea\n\n/** \n * Configuración básica de WordPress.\n *\n * Este archivo contiene las siguientes configuraciones: ajustes de MySQL, prefijo de tablas,\n * claves secretas, idioma de WordPress y ABSPATH. Para obtener más información,\n * visita la página del Codex{@link http://codex.wordpress.org/Editing_wp-config.php Editing\n * wp-config.php} . Los ajustes de MySQL te los proporcionará tu proveedor de alojamiento web.\n *\n * This file is used by the wp-config.php creation script during the\n * installation. You don\'t have to use the web site, you can just copy this file\n * to \"wp-config.php\" and fill in the values.\n *\n * @package WordPress\n */\n\n// ** Ajustes de MySQL. Solicita estos datos a tu proveedor de alojamiento web. ** //\n/** El nombre de tu base de datos de WordPress */\ndefine(\'DB_NAME\', \'solucion_wp\');\n\n/** Tu nombre de usuario de MySQL */\ndefine(\'DB_USER\', \'solucion_wp\');\n\n/** Tu contraseña de MySQL */\ndefine(\'DB_PASSWORD\', \'SRVFHHx-16\');\n\n/** Host de MySQL (es muy probable que no necesites cambiarlo) */\ndefine(\'DB_HOST\', \'localhost\');\n\n/** Codificación de caracteres para la base de datos. */\ndefine(\'DB_CHARSET\', \'utf8\');\n\n/** Cotejamiento de la base de datos. No lo modifiques si tienes dudas. */\ndefine(\'DB_COLLATE\', \'\');\n\n/**#@+\n * Claves únicas de autentificación.\n *\n * Define cada clave secreta con una frase aleatoria distinta.\n * Puedes generarlas usando el {@link https://api.wordpress.org/secret-key/1.1/salt/ servicio de claves secretas de WordPress}\n * Puedes cambiar las claves en cualquier momento para invalidar todas las cookies existentes. Esto forzará a todos los usuarios a volver a hacer login.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\ndefine(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\ndefine(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\ndefine(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\ndefine(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\ndefine(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\ndefine(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\ndefine(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\n\n/**#@-*/\n\n/**\n * Prefijo de la base de datos de WordPress.\n *\n * Cambia el prefijo si deseas instalar multiples blogs en una sola base de datos.\n * Emplea solo números, letras y guión bajo.\n */\n$table_prefix = \'p0aadmzbh8_\';\n\n\n/**\n * Para desarrolladores: modo debug de WordPress.\n *\n * Cambia esto a true para activar la muestra de avisos durante el desarrollo.\n * Se recomienda encarecidamente a los desarrolladores de temas y plugins que usen WP_DEBUG\n * en sus entornos de desarrollo.\n */\ndefine(\'WP_DEBUG\', false);\n\n/* ¡Eso es todo, deja de editar! Feliz blogging */\n\n/** WordPress absolute path to the Wordpress directory. */\nif ( !defined(\'ABSPATH\') )\n	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\n\n/** Sets up WordPress vars and included files. */\nrequire_once(ABSPATH . \'wp-settings.php\');\n\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:18:\"DISALLOW_FILE_EDIT\";a:3:{s:3:\"src\";s:37:\"define( \'DISALLOW_FILE_EDIT\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:28:\"define( \'DISALLOW_FILE_EDIT\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:33:\"define(\'DB_NAME\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:33:\"define(\'DB_USER\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:36:\"define(\'DB_PASSWORD\', \'SRVFHHx-16\');\";s:5:\"value\";s:12:\"\'SRVFHHx-16\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:14:\", \'SRVFHHx-16\'\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:31:\"define(\'DB_HOST\', \'localhost\');\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:13:\", \'localhost\'\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:29:\"define(\'DB_CHARSET\', \'utf8\');\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:8:\", \'utf8\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:25:\"define(\'DB_COLLATE\', \'\');\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_COLLATE\'\";i:1;s:4:\", \'\'\";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:87:\"define(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\";s:5:\"value\";s:66:\"\'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:68:\", \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:94:\"define(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\";s:5:\"value\";s:66:\"\',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:68:\", \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:92:\"define(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\";s:5:\"value\";s:66:\"\'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:68:\", \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:88:\"define(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\";s:5:\"value\";s:66:\"\'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:68:\", \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:88:\"define(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\";s:5:\"value\";s:66:\"\'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:68:\", \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\";s:5:\"value\";s:66:\"\'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:93:\"define(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\";s:5:\"value\";s:66:\"\'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:68:\", \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:89:\"define(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\";s:5:\"value\";s:66:\"\'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:68:\", \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:26:\"define(\'WP_DEBUG\', false);\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'WP_DEBUG\'\";i:1;s:7:\", false\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:44:\"	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\";s:5:\"value\";s:23:\"dirname(__FILE__) . \'/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"	define(\'ABSPATH\'\";i:1;s:25:\", dirname(__FILE__) . \'/\'\";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:30:\"$table_prefix = \'p0aadmzbh8_\';\";s:5:\"value\";s:13:\"\'p0aadmzbh8_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:15:\" \'p0aadmzbh8_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:12925999;s:4:\"File\";s:72:\"20150620_instalacionweb_cafa9bf099d2f7405281_20220928113607_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:6:\"latin1\";i:1;s:7:\"utf8mb4\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:8:{i:0;s:17:\"latin1_general_cs\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:11:\"utf8mb3_bin\";i:3;s:18:\"utf8mb3_general_ci\";i:4;s:18:\"utf8mb3_unicode_ci\";i:5;s:18:\"utf8mb4_0900_ai_ci\";i:6;s:22:\"utf8mb4_unicode_520_ci\";i:7;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:1813;s:16:\"tablesSizeOnDisk\";i:13996334;s:10:\"tablesList\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:9280;}s:23:\"p0aadmzbh8_WP_SEO_Cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_WP_SEO_Redirection\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_blc_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"p0aadmzbh8_blc_instances\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"p0aadmzbh8_blc_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:20:\"p0aadmzbh8_blc_synch\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:27:\"p0aadmzbh8_csp3_subscribers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:52;s:12:\"insertedRows\";i:55;s:4:\"size\";i:344064;}s:19:\"p0aadmzbh8_eum_logs\";a:3:{s:14:\"inaccurateRows\";i:1220;s:12:\"insertedRows\";i:1220;s:4:\"size\";i:7267880;}s:24:\"p0aadmzbh8_ewwwio_images\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:10348;}s:21:\"p0aadmzbh8_itsec_bans\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_itsec_dashboard_events\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8264;}s:36:\"p0aadmzbh8_itsec_distributed_storage\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:1448380;}s:29:\"p0aadmzbh8_itsec_fingerprints\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:34:\"p0aadmzbh8_itsec_geolocation_cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_itsec_lockouts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:20:\"p0aadmzbh8_itsec_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"p0aadmzbh8_itsec_logs\";a:3:{s:14:\"inaccurateRows\";i:92;s:12:\"insertedRows\";i:92;s:4:\"size\";i:1314140;}s:24:\"p0aadmzbh8_itsec_mutexes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_itsec_opaque_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:21:\"p0aadmzbh8_itsec_temp\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:81920;}s:28:\"p0aadmzbh8_itsec_user_groups\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2436;}s:16:\"p0aadmzbh8_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:18:\"p0aadmzbh8_options\";a:3:{s:14:\"inaccurateRows\";i:325;s:12:\"insertedRows\";i:349;s:4:\"size\";i:2670592;}s:19:\"p0aadmzbh8_postmeta\";a:3:{s:14:\"inaccurateRows\";i:13;s:12:\"insertedRows\";i:13;s:4:\"size\";i:49152;}s:16:\"p0aadmzbh8_posts\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:114688;}s:27:\"p0aadmzbh8_smush_dir_images\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:24:\"p0aadmzbh8_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:16:\"p0aadmzbh8_terms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_usermeta\";a:3:{s:14:\"inaccurateRows\";i:45;s:12:\"insertedRows\";i:45;s:4:\"size\";i:65536;}s:16:\"p0aadmzbh8_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:30:\"p0aadmzbh8_wpfront_ure_options\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:11040;}s:32:\"p0aadmzbh8_wpfront_ure_post_type\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:26:\"p0aadmzbh8_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:15380;}s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:5204;}s:27:\"p0aadmzbh8_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:23;s:4:\"size\";i:8652;}s:29:\"p0aadmzbh8_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"p0aadmzbh8_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_yoast_seo_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2082;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.30\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:107:\"/home/solucion/wp/wp-snapshots/tmp/20150620_instalacionweb_cafa9bf099d2f7405281_20220928113607_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-09-28 11:36:07\";s:7:\"Version\";s:5:\"1.5.0\";s:9:\"VersionWP\";s:5:\"6.0.2\";s:9:\"VersionDB\";s:6:\"8.0.30\";s:10:\"VersionPHP\";s:6:\"7.4.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:23:\"20150620_instalacionweb\";s:4:\"Hash\";s:35:\"cafa9bf099d2f7405281_20220928113607\";s:8:\"NameHash\";s:59:\"20150620_instalacionweb_cafa9bf099d2f7405281_20220928113607\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:474;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("72", "20150620_nuevo_EXP", "3aece2faed6cd3a68273_20221214103244", "100", "2022-12-14 10:33:01", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-12-14 10:32:44\";s:7:\"Version\";s:5:\"1.5.1\";s:9:\"VersionWP\";s:5:\"6.0.3\";s:9:\"VersionDB\";s:6:\"8.0.31\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:72;s:4:\"Name\";s:18:\"20150620_nuevo_EXP\";s:4:\"Hash\";s:35:\"3aece2faed6cd3a68273_20221214103244\";s:8:\"NameHash\";s:54:\"20150620_nuevo_EXP_3aece2faed6cd3a68273_20221214103244\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:64:\"20150620_nuevo_EXP_3aece2faed6cd3a68273_20221214103244_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"48.39 sec.\";s:7:\"ExeSize\";s:7:\"73.35KB\";s:7:\"ZipSize\";s:7:\"58.75MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:66:\"20150620_nuevo_EXP_3aece2faed6cd3a68273_20221214103244_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:61607581;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2805;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11530;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14334;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:29:\"/home/solucion/wp/wp-includes\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:17:\"/home/solucion/wp\";i:1;s:17:\"/home/solucion/wp\";i:2;s:28:\"/home/solucion/wp/wp-content\";i:3;s:36:\"/home/solucion/wp/wp-content/uploads\";i:4;s:36:\"/home/solucion/wp/wp-content/plugins\";i:5;s:39:\"/home/solucion/wp/wp-content/mu-plugins\";i:6;s:35:\"/home/solucion/wp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:34:\"/home/solucion/wp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:72:\"20150620_nuevo_EXP_3aece2faed6cd3a68273_20221214103244_installer.php.bak\";s:4:\"Size\";i:75108;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:86:\"/home/solucion/wp/wp-snapshots/tmp/original_files_3aece2f-14103244/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:66:\"/home/solucion/wp/wp-snapshots/tmp/original_files_3aece2f-14103244\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:17:\"/home/solucion/wp\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:31:\"/home/solucion/wp/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3505:\"<?php\n\n// BEGIN iThemes Security - No modifiques ni borres esta línea\n// iThemes Security Config Details: 2\ndefine( \'DISALLOW_FILE_EDIT\', true ); // Desactivar editor de archivos - Seguridad > Ajustes > Ajustes WordPress > Editor de archivos\n// END iThemes Security - No modifiques ni borres esta línea\n\n/** \n * Configuración básica de WordPress.\n *\n * Este archivo contiene las siguientes configuraciones: ajustes de MySQL, prefijo de tablas,\n * claves secretas, idioma de WordPress y ABSPATH. Para obtener más información,\n * visita la página del Codex{@link http://codex.wordpress.org/Editing_wp-config.php Editing\n * wp-config.php} . Los ajustes de MySQL te los proporcionará tu proveedor de alojamiento web.\n *\n * This file is used by the wp-config.php creation script during the\n * installation. You don\'t have to use the web site, you can just copy this file\n * to \"wp-config.php\" and fill in the values.\n *\n * @package WordPress\n */\n\n// ** Ajustes de MySQL. Solicita estos datos a tu proveedor de alojamiento web. ** //\n/** El nombre de tu base de datos de WordPress */\ndefine(\'DB_NAME\', \'solucion_wp\');\n\n/** Tu nombre de usuario de MySQL */\ndefine(\'DB_USER\', \'solucion_wp\');\n\n/** Tu contraseña de MySQL */\ndefine(\'DB_PASSWORD\', \'SRVFHHx-16\');\n\n/** Host de MySQL (es muy probable que no necesites cambiarlo) */\ndefine(\'DB_HOST\', \'localhost\');\n\n/** Codificación de caracteres para la base de datos. */\ndefine(\'DB_CHARSET\', \'utf8\');\n\n/** Cotejamiento de la base de datos. No lo modifiques si tienes dudas. */\ndefine(\'DB_COLLATE\', \'\');\n\n/**#@+\n * Claves únicas de autentificación.\n *\n * Define cada clave secreta con una frase aleatoria distinta.\n * Puedes generarlas usando el {@link https://api.wordpress.org/secret-key/1.1/salt/ servicio de claves secretas de WordPress}\n * Puedes cambiar las claves en cualquier momento para invalidar todas las cookies existentes. Esto forzará a todos los usuarios a volver a hacer login.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\ndefine(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\ndefine(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\ndefine(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\ndefine(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\ndefine(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\ndefine(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\ndefine(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\n\n/**#@-*/\n\n/**\n * Prefijo de la base de datos de WordPress.\n *\n * Cambia el prefijo si deseas instalar multiples blogs en una sola base de datos.\n * Emplea solo números, letras y guión bajo.\n */\n$table_prefix = \'p0aadmzbh8_\';\n\n\n/**\n * Para desarrolladores: modo debug de WordPress.\n *\n * Cambia esto a true para activar la muestra de avisos durante el desarrollo.\n * Se recomienda encarecidamente a los desarrolladores de temas y plugins que usen WP_DEBUG\n * en sus entornos de desarrollo.\n */\ndefine(\'WP_DEBUG\', false);\n\n/* ¡Eso es todo, deja de editar! Feliz blogging */\n\n/** WordPress absolute path to the Wordpress directory. */\nif ( !defined(\'ABSPATH\') )\n	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\n\n/** Sets up WordPress vars and included files. */\nrequire_once(ABSPATH . \'wp-settings.php\');\n\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:18:\"DISALLOW_FILE_EDIT\";a:3:{s:3:\"src\";s:37:\"define( \'DISALLOW_FILE_EDIT\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:28:\"define( \'DISALLOW_FILE_EDIT\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:33:\"define(\'DB_NAME\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:33:\"define(\'DB_USER\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:36:\"define(\'DB_PASSWORD\', \'SRVFHHx-16\');\";s:5:\"value\";s:12:\"\'SRVFHHx-16\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:14:\", \'SRVFHHx-16\'\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:31:\"define(\'DB_HOST\', \'localhost\');\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:13:\", \'localhost\'\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:29:\"define(\'DB_CHARSET\', \'utf8\');\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:8:\", \'utf8\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:25:\"define(\'DB_COLLATE\', \'\');\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_COLLATE\'\";i:1;s:4:\", \'\'\";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:87:\"define(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\";s:5:\"value\";s:66:\"\'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:68:\", \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:94:\"define(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\";s:5:\"value\";s:66:\"\',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:68:\", \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:92:\"define(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\";s:5:\"value\";s:66:\"\'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:68:\", \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:88:\"define(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\";s:5:\"value\";s:66:\"\'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:68:\", \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:88:\"define(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\";s:5:\"value\";s:66:\"\'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:68:\", \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\";s:5:\"value\";s:66:\"\'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:93:\"define(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\";s:5:\"value\";s:66:\"\'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:68:\", \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:89:\"define(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\";s:5:\"value\";s:66:\"\'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:68:\", \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:26:\"define(\'WP_DEBUG\', false);\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'WP_DEBUG\'\";i:1;s:7:\", false\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:44:\"	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\";s:5:\"value\";s:23:\"dirname(__FILE__) . \'/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"	define(\'ABSPATH\'\";i:1;s:25:\", dirname(__FILE__) . \'/\'\";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:30:\"$table_prefix = \'p0aadmzbh8_\';\";s:5:\"value\";s:13:\"\'p0aadmzbh8_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:15:\" \'p0aadmzbh8_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:12273817;s:4:\"File\";s:67:\"20150620_nuevo_EXP_3aece2faed6cd3a68273_20221214103244_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:6:\"latin1\";i:1;s:7:\"utf8mb4\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:8:{i:0;s:17:\"latin1_general_cs\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:11:\"utf8mb3_bin\";i:3;s:18:\"utf8mb3_general_ci\";i:4;s:18:\"utf8mb3_unicode_ci\";i:5;s:18:\"utf8mb4_0900_ai_ci\";i:6;s:22:\"utf8mb4_unicode_520_ci\";i:7;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:1777;s:16:\"tablesSizeOnDisk\";i:15784371;s:10:\"tablesList\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:9280;}s:23:\"p0aadmzbh8_WP_SEO_Cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_WP_SEO_Redirection\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_blc_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"p0aadmzbh8_blc_instances\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"p0aadmzbh8_blc_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:20:\"p0aadmzbh8_blc_synch\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:27:\"p0aadmzbh8_csp3_subscribers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:52;s:12:\"insertedRows\";i:56;s:4:\"size\";i:344064;}s:19:\"p0aadmzbh8_eum_logs\";a:3:{s:14:\"inaccurateRows\";i:1275;s:12:\"insertedRows\";i:1275;s:4:\"size\";i:7951984;}s:24:\"p0aadmzbh8_ewwwio_images\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:10348;}s:21:\"p0aadmzbh8_itsec_bans\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_itsec_dashboard_events\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8336;}s:36:\"p0aadmzbh8_itsec_distributed_storage\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2546736;}s:29:\"p0aadmzbh8_itsec_fingerprints\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:34:\"p0aadmzbh8_itsec_geolocation_cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_itsec_lockouts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:20:\"p0aadmzbh8_itsec_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"p0aadmzbh8_itsec_logs\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:1319624;}s:24:\"p0aadmzbh8_itsec_mutexes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_itsec_opaque_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:21:\"p0aadmzbh8_itsec_temp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:28:\"p0aadmzbh8_itsec_user_groups\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2436;}s:16:\"p0aadmzbh8_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:18:\"p0aadmzbh8_options\";a:3:{s:14:\"inaccurateRows\";i:323;s:12:\"insertedRows\";i:349;s:4:\"size\";i:2670592;}s:19:\"p0aadmzbh8_postmeta\";a:3:{s:14:\"inaccurateRows\";i:13;s:12:\"insertedRows\";i:13;s:4:\"size\";i:49152;}s:16:\"p0aadmzbh8_posts\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:114688;}s:27:\"p0aadmzbh8_smush_dir_images\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:24:\"p0aadmzbh8_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:16:\"p0aadmzbh8_terms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_usermeta\";a:3:{s:14:\"inaccurateRows\";i:45;s:12:\"insertedRows\";i:45;s:4:\"size\";i:65536;}s:16:\"p0aadmzbh8_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:30:\"p0aadmzbh8_wpfront_ure_options\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:11040;}s:32:\"p0aadmzbh8_wpfront_ure_post_type\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:26:\"p0aadmzbh8_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:15380;}s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5225;}s:27:\"p0aadmzbh8_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:23;s:4:\"size\";i:8652;}s:29:\"p0aadmzbh8_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"p0aadmzbh8_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_yoast_seo_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2082;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.31\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:102:\"/home/solucion/wp/wp-snapshots/tmp/20150620_nuevo_EXP_3aece2faed6cd3a68273_20221214103244_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-12-14 10:32:44\";s:7:\"Version\";s:5:\"1.5.1\";s:9:\"VersionWP\";s:5:\"6.0.3\";s:9:\"VersionDB\";s:6:\"8.0.31\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20150620_nuevo_EXP\";s:4:\"Hash\";s:35:\"3aece2faed6cd3a68273_20221214103244\";s:8:\"NameHash\";s:54:\"20150620_nuevo_EXP_3aece2faed6cd3a68273_20221214103244\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:474;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("73", "20150620_nuevo_EXP", "66a72cc1040477c38006_20221231152729", "100", "2022-12-31 15:27:42", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-12-31 15:27:29\";s:7:\"Version\";s:5:\"1.5.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.31\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:73;s:4:\"Name\";s:18:\"20150620_nuevo_EXP\";s:4:\"Hash\";s:35:\"66a72cc1040477c38006_20221231152729\";s:8:\"NameHash\";s:54:\"20150620_nuevo_EXP_66a72cc1040477c38006_20221231152729\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:64:\"20150620_nuevo_EXP_66a72cc1040477c38006_20221231152729_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"42.19 sec.\";s:7:\"ExeSize\";s:7:\"73.35KB\";s:7:\"ZipSize\";s:7:\"61.15MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:66:\"20150620_nuevo_EXP_66a72cc1040477c38006_20221231152729_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:64118446;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2817;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11635;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14451;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:29:\"/home/solucion/wp/wp-includes\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:17:\"/home/solucion/wp\";i:1;s:17:\"/home/solucion/wp\";i:2;s:28:\"/home/solucion/wp/wp-content\";i:3;s:36:\"/home/solucion/wp/wp-content/uploads\";i:4;s:36:\"/home/solucion/wp/wp-content/plugins\";i:5;s:39:\"/home/solucion/wp/wp-content/mu-plugins\";i:6;s:35:\"/home/solucion/wp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:34:\"/home/solucion/wp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:72:\"20150620_nuevo_EXP_66a72cc1040477c38006_20221231152729_installer.php.bak\";s:4:\"Size\";i:75108;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:86:\"/home/solucion/wp/wp-snapshots/tmp/original_files_66a72cc-31152729/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:66:\"/home/solucion/wp/wp-snapshots/tmp/original_files_66a72cc-31152729\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:17:\"/home/solucion/wp\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:31:\"/home/solucion/wp/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3505:\"<?php\n\n// BEGIN iThemes Security - No modifiques ni borres esta línea\n// iThemes Security Config Details: 2\ndefine( \'DISALLOW_FILE_EDIT\', true ); // Desactivar editor de archivos - Seguridad > Ajustes > Ajustes WordPress > Editor de archivos\n// END iThemes Security - No modifiques ni borres esta línea\n\n/** \n * Configuración básica de WordPress.\n *\n * Este archivo contiene las siguientes configuraciones: ajustes de MySQL, prefijo de tablas,\n * claves secretas, idioma de WordPress y ABSPATH. Para obtener más información,\n * visita la página del Codex{@link http://codex.wordpress.org/Editing_wp-config.php Editing\n * wp-config.php} . Los ajustes de MySQL te los proporcionará tu proveedor de alojamiento web.\n *\n * This file is used by the wp-config.php creation script during the\n * installation. You don\'t have to use the web site, you can just copy this file\n * to \"wp-config.php\" and fill in the values.\n *\n * @package WordPress\n */\n\n// ** Ajustes de MySQL. Solicita estos datos a tu proveedor de alojamiento web. ** //\n/** El nombre de tu base de datos de WordPress */\ndefine(\'DB_NAME\', \'solucion_wp\');\n\n/** Tu nombre de usuario de MySQL */\ndefine(\'DB_USER\', \'solucion_wp\');\n\n/** Tu contraseña de MySQL */\ndefine(\'DB_PASSWORD\', \'SRVFHHx-16\');\n\n/** Host de MySQL (es muy probable que no necesites cambiarlo) */\ndefine(\'DB_HOST\', \'localhost\');\n\n/** Codificación de caracteres para la base de datos. */\ndefine(\'DB_CHARSET\', \'utf8\');\n\n/** Cotejamiento de la base de datos. No lo modifiques si tienes dudas. */\ndefine(\'DB_COLLATE\', \'\');\n\n/**#@+\n * Claves únicas de autentificación.\n *\n * Define cada clave secreta con una frase aleatoria distinta.\n * Puedes generarlas usando el {@link https://api.wordpress.org/secret-key/1.1/salt/ servicio de claves secretas de WordPress}\n * Puedes cambiar las claves en cualquier momento para invalidar todas las cookies existentes. Esto forzará a todos los usuarios a volver a hacer login.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\ndefine(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\ndefine(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\ndefine(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\ndefine(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\ndefine(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\ndefine(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\ndefine(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\n\n/**#@-*/\n\n/**\n * Prefijo de la base de datos de WordPress.\n *\n * Cambia el prefijo si deseas instalar multiples blogs en una sola base de datos.\n * Emplea solo números, letras y guión bajo.\n */\n$table_prefix = \'p0aadmzbh8_\';\n\n\n/**\n * Para desarrolladores: modo debug de WordPress.\n *\n * Cambia esto a true para activar la muestra de avisos durante el desarrollo.\n * Se recomienda encarecidamente a los desarrolladores de temas y plugins que usen WP_DEBUG\n * en sus entornos de desarrollo.\n */\ndefine(\'WP_DEBUG\', false);\n\n/* ¡Eso es todo, deja de editar! Feliz blogging */\n\n/** WordPress absolute path to the Wordpress directory. */\nif ( !defined(\'ABSPATH\') )\n	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\n\n/** Sets up WordPress vars and included files. */\nrequire_once(ABSPATH . \'wp-settings.php\');\n\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:18:\"DISALLOW_FILE_EDIT\";a:3:{s:3:\"src\";s:37:\"define( \'DISALLOW_FILE_EDIT\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:28:\"define( \'DISALLOW_FILE_EDIT\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:33:\"define(\'DB_NAME\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:33:\"define(\'DB_USER\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:36:\"define(\'DB_PASSWORD\', \'SRVFHHx-16\');\";s:5:\"value\";s:12:\"\'SRVFHHx-16\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:14:\", \'SRVFHHx-16\'\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:31:\"define(\'DB_HOST\', \'localhost\');\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:13:\", \'localhost\'\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:29:\"define(\'DB_CHARSET\', \'utf8\');\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:8:\", \'utf8\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:25:\"define(\'DB_COLLATE\', \'\');\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_COLLATE\'\";i:1;s:4:\", \'\'\";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:87:\"define(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\";s:5:\"value\";s:66:\"\'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:68:\", \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:94:\"define(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\";s:5:\"value\";s:66:\"\',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:68:\", \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:92:\"define(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\";s:5:\"value\";s:66:\"\'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:68:\", \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:88:\"define(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\";s:5:\"value\";s:66:\"\'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:68:\", \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:88:\"define(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\";s:5:\"value\";s:66:\"\'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:68:\", \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\";s:5:\"value\";s:66:\"\'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:93:\"define(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\";s:5:\"value\";s:66:\"\'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:68:\", \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:89:\"define(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\";s:5:\"value\";s:66:\"\'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:68:\", \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:26:\"define(\'WP_DEBUG\', false);\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'WP_DEBUG\'\";i:1;s:7:\", false\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:44:\"	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\";s:5:\"value\";s:23:\"dirname(__FILE__) . \'/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"	define(\'ABSPATH\'\";i:1;s:25:\", dirname(__FILE__) . \'/\'\";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:30:\"$table_prefix = \'p0aadmzbh8_\';\";s:5:\"value\";s:13:\"\'p0aadmzbh8_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:15:\" \'p0aadmzbh8_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:12398025;s:4:\"File\";s:67:\"20150620_nuevo_EXP_66a72cc1040477c38006_20221231152729_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:6:\"latin1\";i:1;s:7:\"utf8mb4\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:8:{i:0;s:17:\"latin1_general_cs\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:11:\"utf8mb3_bin\";i:3;s:18:\"utf8mb3_general_ci\";i:4;s:18:\"utf8mb3_unicode_ci\";i:5;s:18:\"utf8mb4_0900_ai_ci\";i:6;s:22:\"utf8mb4_unicode_520_ci\";i:7;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:1801;s:16:\"tablesSizeOnDisk\";i:15874503;s:10:\"tablesList\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:9280;}s:23:\"p0aadmzbh8_WP_SEO_Cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_WP_SEO_Redirection\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_blc_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"p0aadmzbh8_blc_instances\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"p0aadmzbh8_blc_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:20:\"p0aadmzbh8_blc_synch\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:27:\"p0aadmzbh8_csp3_subscribers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:52;s:12:\"insertedRows\";i:57;s:4:\"size\";i:344064;}s:19:\"p0aadmzbh8_eum_logs\";a:3:{s:14:\"inaccurateRows\";i:1284;s:12:\"insertedRows\";i:1286;s:4:\"size\";i:8042116;}s:24:\"p0aadmzbh8_ewwwio_images\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:10348;}s:21:\"p0aadmzbh8_itsec_bans\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_itsec_dashboard_events\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8336;}s:36:\"p0aadmzbh8_itsec_distributed_storage\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2546736;}s:29:\"p0aadmzbh8_itsec_fingerprints\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:34:\"p0aadmzbh8_itsec_geolocation_cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_itsec_lockouts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:20:\"p0aadmzbh8_itsec_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"p0aadmzbh8_itsec_logs\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:1319624;}s:24:\"p0aadmzbh8_itsec_mutexes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_itsec_opaque_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:21:\"p0aadmzbh8_itsec_temp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:28:\"p0aadmzbh8_itsec_user_groups\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2436;}s:16:\"p0aadmzbh8_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:18:\"p0aadmzbh8_options\";a:3:{s:14:\"inaccurateRows\";i:338;s:12:\"insertedRows\";i:349;s:4:\"size\";i:2670592;}s:19:\"p0aadmzbh8_postmeta\";a:3:{s:14:\"inaccurateRows\";i:13;s:12:\"insertedRows\";i:13;s:4:\"size\";i:49152;}s:16:\"p0aadmzbh8_posts\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:114688;}s:27:\"p0aadmzbh8_smush_dir_images\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:24:\"p0aadmzbh8_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:16:\"p0aadmzbh8_terms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_usermeta\";a:3:{s:14:\"inaccurateRows\";i:45;s:12:\"insertedRows\";i:45;s:4:\"size\";i:65536;}s:16:\"p0aadmzbh8_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:30:\"p0aadmzbh8_wpfront_ure_options\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:11040;}s:32:\"p0aadmzbh8_wpfront_ure_post_type\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:26:\"p0aadmzbh8_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:15380;}s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5225;}s:27:\"p0aadmzbh8_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:23;s:4:\"size\";i:8652;}s:29:\"p0aadmzbh8_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"p0aadmzbh8_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_yoast_seo_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2082;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.31\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:102:\"/home/solucion/wp/wp-snapshots/tmp/20150620_nuevo_EXP_66a72cc1040477c38006_20221231152729_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2022-12-31 15:27:29\";s:7:\"Version\";s:5:\"1.5.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.31\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20150620_nuevo_EXP\";s:4:\"Hash\";s:35:\"66a72cc1040477c38006_20221231152729\";s:8:\"NameHash\";s:54:\"20150620_nuevo_EXP_66a72cc1040477c38006_20221231152729\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:474;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("74", "20150620_edifica", "bb74e35d408f9dad7457_20230118095254", "100", "2023-01-18 09:53:11", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-01-18 09:52:54\";s:7:\"Version\";s:5:\"1.5.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:74;s:4:\"Name\";s:16:\"20150620_edifica\";s:4:\"Hash\";s:35:\"bb74e35d408f9dad7457_20230118095254\";s:8:\"NameHash\";s:52:\"20150620_edifica_bb74e35d408f9dad7457_20230118095254\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20150620_edifica_bb74e35d408f9dad7457_20230118095254_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"50.58 sec.\";s:7:\"ExeSize\";s:7:\"73.35KB\";s:7:\"ZipSize\";s:7:\"58.82MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:64:\"20150620_edifica_bb74e35d408f9dad7457_20230118095254_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:61679831;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2809;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11532;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14340;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:29:\"/home/solucion/wp/wp-includes\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:17:\"/home/solucion/wp\";i:1;s:17:\"/home/solucion/wp\";i:2;s:28:\"/home/solucion/wp/wp-content\";i:3;s:36:\"/home/solucion/wp/wp-content/uploads\";i:4;s:36:\"/home/solucion/wp/wp-content/plugins\";i:5;s:39:\"/home/solucion/wp/wp-content/mu-plugins\";i:6;s:35:\"/home/solucion/wp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:34:\"/home/solucion/wp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20150620_edifica_bb74e35d408f9dad7457_20230118095254_installer.php.bak\";s:4:\"Size\";i:75106;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:86:\"/home/solucion/wp/wp-snapshots/tmp/original_files_bb74e35-18095254/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:66:\"/home/solucion/wp/wp-snapshots/tmp/original_files_bb74e35-18095254\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:17:\"/home/solucion/wp\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:31:\"/home/solucion/wp/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3505:\"<?php\n\n// BEGIN iThemes Security - No modifiques ni borres esta línea\n// iThemes Security Config Details: 2\ndefine( \'DISALLOW_FILE_EDIT\', true ); // Desactivar editor de archivos - Seguridad > Ajustes > Ajustes WordPress > Editor de archivos\n// END iThemes Security - No modifiques ni borres esta línea\n\n/** \n * Configuración básica de WordPress.\n *\n * Este archivo contiene las siguientes configuraciones: ajustes de MySQL, prefijo de tablas,\n * claves secretas, idioma de WordPress y ABSPATH. Para obtener más información,\n * visita la página del Codex{@link http://codex.wordpress.org/Editing_wp-config.php Editing\n * wp-config.php} . Los ajustes de MySQL te los proporcionará tu proveedor de alojamiento web.\n *\n * This file is used by the wp-config.php creation script during the\n * installation. You don\'t have to use the web site, you can just copy this file\n * to \"wp-config.php\" and fill in the values.\n *\n * @package WordPress\n */\n\n// ** Ajustes de MySQL. Solicita estos datos a tu proveedor de alojamiento web. ** //\n/** El nombre de tu base de datos de WordPress */\ndefine(\'DB_NAME\', \'solucion_wp\');\n\n/** Tu nombre de usuario de MySQL */\ndefine(\'DB_USER\', \'solucion_wp\');\n\n/** Tu contraseña de MySQL */\ndefine(\'DB_PASSWORD\', \'SRVFHHx-16\');\n\n/** Host de MySQL (es muy probable que no necesites cambiarlo) */\ndefine(\'DB_HOST\', \'localhost\');\n\n/** Codificación de caracteres para la base de datos. */\ndefine(\'DB_CHARSET\', \'utf8\');\n\n/** Cotejamiento de la base de datos. No lo modifiques si tienes dudas. */\ndefine(\'DB_COLLATE\', \'\');\n\n/**#@+\n * Claves únicas de autentificación.\n *\n * Define cada clave secreta con una frase aleatoria distinta.\n * Puedes generarlas usando el {@link https://api.wordpress.org/secret-key/1.1/salt/ servicio de claves secretas de WordPress}\n * Puedes cambiar las claves en cualquier momento para invalidar todas las cookies existentes. Esto forzará a todos los usuarios a volver a hacer login.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\ndefine(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\ndefine(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\ndefine(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\ndefine(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\ndefine(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\ndefine(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\ndefine(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\n\n/**#@-*/\n\n/**\n * Prefijo de la base de datos de WordPress.\n *\n * Cambia el prefijo si deseas instalar multiples blogs en una sola base de datos.\n * Emplea solo números, letras y guión bajo.\n */\n$table_prefix = \'p0aadmzbh8_\';\n\n\n/**\n * Para desarrolladores: modo debug de WordPress.\n *\n * Cambia esto a true para activar la muestra de avisos durante el desarrollo.\n * Se recomienda encarecidamente a los desarrolladores de temas y plugins que usen WP_DEBUG\n * en sus entornos de desarrollo.\n */\ndefine(\'WP_DEBUG\', false);\n\n/* ¡Eso es todo, deja de editar! Feliz blogging */\n\n/** WordPress absolute path to the Wordpress directory. */\nif ( !defined(\'ABSPATH\') )\n	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\n\n/** Sets up WordPress vars and included files. */\nrequire_once(ABSPATH . \'wp-settings.php\');\n\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:18:\"DISALLOW_FILE_EDIT\";a:3:{s:3:\"src\";s:37:\"define( \'DISALLOW_FILE_EDIT\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:28:\"define( \'DISALLOW_FILE_EDIT\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:33:\"define(\'DB_NAME\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:33:\"define(\'DB_USER\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:36:\"define(\'DB_PASSWORD\', \'SRVFHHx-16\');\";s:5:\"value\";s:12:\"\'SRVFHHx-16\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:14:\", \'SRVFHHx-16\'\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:31:\"define(\'DB_HOST\', \'localhost\');\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:13:\", \'localhost\'\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:29:\"define(\'DB_CHARSET\', \'utf8\');\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:8:\", \'utf8\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:25:\"define(\'DB_COLLATE\', \'\');\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_COLLATE\'\";i:1;s:4:\", \'\'\";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:87:\"define(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\";s:5:\"value\";s:66:\"\'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:68:\", \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:94:\"define(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\";s:5:\"value\";s:66:\"\',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:68:\", \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:92:\"define(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\";s:5:\"value\";s:66:\"\'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:68:\", \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:88:\"define(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\";s:5:\"value\";s:66:\"\'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:68:\", \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:88:\"define(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\";s:5:\"value\";s:66:\"\'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:68:\", \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\";s:5:\"value\";s:66:\"\'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:93:\"define(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\";s:5:\"value\";s:66:\"\'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:68:\", \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:89:\"define(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\";s:5:\"value\";s:66:\"\'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:68:\", \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:26:\"define(\'WP_DEBUG\', false);\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'WP_DEBUG\'\";i:1;s:7:\", false\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:44:\"	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\";s:5:\"value\";s:23:\"dirname(__FILE__) . \'/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"	define(\'ABSPATH\'\";i:1;s:25:\", dirname(__FILE__) . \'/\'\";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:30:\"$table_prefix = \'p0aadmzbh8_\';\";s:5:\"value\";s:13:\"\'p0aadmzbh8_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:15:\" \'p0aadmzbh8_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:12664331;s:4:\"File\";s:65:\"20150620_edifica_bb74e35d408f9dad7457_20230118095254_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:6:\"latin1\";i:1;s:7:\"utf8mb4\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:8:{i:0;s:17:\"latin1_general_cs\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:11:\"utf8mb3_bin\";i:3;s:18:\"utf8mb3_general_ci\";i:4;s:18:\"utf8mb3_unicode_ci\";i:5;s:18:\"utf8mb4_0900_ai_ci\";i:6;s:22:\"utf8mb4_unicode_520_ci\";i:7;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:1803;s:16:\"tablesSizeOnDisk\";i:16103351;s:10:\"tablesList\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:9280;}s:23:\"p0aadmzbh8_WP_SEO_Cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_WP_SEO_Redirection\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_blc_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"p0aadmzbh8_blc_instances\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"p0aadmzbh8_blc_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:20:\"p0aadmzbh8_blc_synch\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:27:\"p0aadmzbh8_csp3_subscribers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:52;s:12:\"insertedRows\";i:58;s:4:\"size\";i:344064;}s:19:\"p0aadmzbh8_eum_logs\";a:3:{s:14:\"inaccurateRows\";i:1300;s:12:\"insertedRows\";i:1300;s:4:\"size\";i:8270964;}s:24:\"p0aadmzbh8_ewwwio_images\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:10348;}s:21:\"p0aadmzbh8_itsec_bans\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_itsec_dashboard_events\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8336;}s:36:\"p0aadmzbh8_itsec_distributed_storage\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2546736;}s:29:\"p0aadmzbh8_itsec_fingerprints\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:34:\"p0aadmzbh8_itsec_geolocation_cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_itsec_lockouts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:20:\"p0aadmzbh8_itsec_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"p0aadmzbh8_itsec_logs\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:1319624;}s:24:\"p0aadmzbh8_itsec_mutexes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_itsec_opaque_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:21:\"p0aadmzbh8_itsec_temp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:28:\"p0aadmzbh8_itsec_user_groups\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2436;}s:16:\"p0aadmzbh8_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:18:\"p0aadmzbh8_options\";a:3:{s:14:\"inaccurateRows\";i:324;s:12:\"insertedRows\";i:349;s:4:\"size\";i:2670592;}s:19:\"p0aadmzbh8_postmeta\";a:3:{s:14:\"inaccurateRows\";i:13;s:12:\"insertedRows\";i:13;s:4:\"size\";i:49152;}s:16:\"p0aadmzbh8_posts\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:114688;}s:27:\"p0aadmzbh8_smush_dir_images\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:24:\"p0aadmzbh8_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:16:\"p0aadmzbh8_terms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_usermeta\";a:3:{s:14:\"inaccurateRows\";i:45;s:12:\"insertedRows\";i:45;s:4:\"size\";i:65536;}s:16:\"p0aadmzbh8_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:30:\"p0aadmzbh8_wpfront_ure_options\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:11040;}s:32:\"p0aadmzbh8_wpfront_ure_post_type\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:26:\"p0aadmzbh8_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:15380;}s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5225;}s:27:\"p0aadmzbh8_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:23;s:4:\"size\";i:8652;}s:29:\"p0aadmzbh8_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"p0aadmzbh8_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_yoast_seo_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2082;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.32\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:100:\"/home/solucion/wp/wp-snapshots/tmp/20150620_edifica_bb74e35d408f9dad7457_20230118095254_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-01-18 09:52:54\";s:7:\"Version\";s:5:\"1.5.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20150620_edifica\";s:4:\"Hash\";s:35:\"bb74e35d408f9dad7457_20230118095254\";s:8:\"NameHash\";s:52:\"20150620_edifica_bb74e35d408f9dad7457_20230118095254\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:474;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("75", "20150620_bodente", "b7936927b6123bb72167_20230215112110", "100", "2023-02-15 11:21:25", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-02-15 11:21:10\";s:7:\"Version\";s:7:\"1.5.2.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:75;s:4:\"Name\";s:16:\"20150620_bodente\";s:4:\"Hash\";s:35:\"b7936927b6123bb72167_20230215112110\";s:8:\"NameHash\";s:52:\"20150620_bodente_b7936927b6123bb72167_20230215112110\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20150620_bodente_b7936927b6123bb72167_20230215112110_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"48.75 sec.\";s:7:\"ExeSize\";s:7:\"73.35KB\";s:7:\"ZipSize\";s:7:\"59.01MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:64:\"20150620_bodente_b7936927b6123bb72167_20230215112110_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:61873977;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2810;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11526;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14335;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:29:\"/home/solucion/wp/wp-includes\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:17:\"/home/solucion/wp\";i:1;s:17:\"/home/solucion/wp\";i:2;s:28:\"/home/solucion/wp/wp-content\";i:3;s:36:\"/home/solucion/wp/wp-content/uploads\";i:4;s:36:\"/home/solucion/wp/wp-content/plugins\";i:5;s:39:\"/home/solucion/wp/wp-content/mu-plugins\";i:6;s:35:\"/home/solucion/wp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:34:\"/home/solucion/wp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20150620_bodente_b7936927b6123bb72167_20230215112110_installer.php.bak\";s:4:\"Size\";i:75108;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:86:\"/home/solucion/wp/wp-snapshots/tmp/original_files_b793692-15112110/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:66:\"/home/solucion/wp/wp-snapshots/tmp/original_files_b793692-15112110\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:17:\"/home/solucion/wp\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:31:\"/home/solucion/wp/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3505:\"<?php\n\n// BEGIN iThemes Security - No modifiques ni borres esta línea\n// iThemes Security Config Details: 2\ndefine( \'DISALLOW_FILE_EDIT\', true ); // Desactivar editor de archivos - Seguridad > Ajustes > Ajustes WordPress > Editor de archivos\n// END iThemes Security - No modifiques ni borres esta línea\n\n/** \n * Configuración básica de WordPress.\n *\n * Este archivo contiene las siguientes configuraciones: ajustes de MySQL, prefijo de tablas,\n * claves secretas, idioma de WordPress y ABSPATH. Para obtener más información,\n * visita la página del Codex{@link http://codex.wordpress.org/Editing_wp-config.php Editing\n * wp-config.php} . Los ajustes de MySQL te los proporcionará tu proveedor de alojamiento web.\n *\n * This file is used by the wp-config.php creation script during the\n * installation. You don\'t have to use the web site, you can just copy this file\n * to \"wp-config.php\" and fill in the values.\n *\n * @package WordPress\n */\n\n// ** Ajustes de MySQL. Solicita estos datos a tu proveedor de alojamiento web. ** //\n/** El nombre de tu base de datos de WordPress */\ndefine(\'DB_NAME\', \'solucion_wp\');\n\n/** Tu nombre de usuario de MySQL */\ndefine(\'DB_USER\', \'solucion_wp\');\n\n/** Tu contraseña de MySQL */\ndefine(\'DB_PASSWORD\', \'SRVFHHx-16\');\n\n/** Host de MySQL (es muy probable que no necesites cambiarlo) */\ndefine(\'DB_HOST\', \'localhost\');\n\n/** Codificación de caracteres para la base de datos. */\ndefine(\'DB_CHARSET\', \'utf8\');\n\n/** Cotejamiento de la base de datos. No lo modifiques si tienes dudas. */\ndefine(\'DB_COLLATE\', \'\');\n\n/**#@+\n * Claves únicas de autentificación.\n *\n * Define cada clave secreta con una frase aleatoria distinta.\n * Puedes generarlas usando el {@link https://api.wordpress.org/secret-key/1.1/salt/ servicio de claves secretas de WordPress}\n * Puedes cambiar las claves en cualquier momento para invalidar todas las cookies existentes. Esto forzará a todos los usuarios a volver a hacer login.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\ndefine(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\ndefine(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\ndefine(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\ndefine(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\ndefine(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\ndefine(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\ndefine(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\n\n/**#@-*/\n\n/**\n * Prefijo de la base de datos de WordPress.\n *\n * Cambia el prefijo si deseas instalar multiples blogs en una sola base de datos.\n * Emplea solo números, letras y guión bajo.\n */\n$table_prefix = \'p0aadmzbh8_\';\n\n\n/**\n * Para desarrolladores: modo debug de WordPress.\n *\n * Cambia esto a true para activar la muestra de avisos durante el desarrollo.\n * Se recomienda encarecidamente a los desarrolladores de temas y plugins que usen WP_DEBUG\n * en sus entornos de desarrollo.\n */\ndefine(\'WP_DEBUG\', false);\n\n/* ¡Eso es todo, deja de editar! Feliz blogging */\n\n/** WordPress absolute path to the Wordpress directory. */\nif ( !defined(\'ABSPATH\') )\n	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\n\n/** Sets up WordPress vars and included files. */\nrequire_once(ABSPATH . \'wp-settings.php\');\n\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:18:\"DISALLOW_FILE_EDIT\";a:3:{s:3:\"src\";s:37:\"define( \'DISALLOW_FILE_EDIT\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:28:\"define( \'DISALLOW_FILE_EDIT\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:33:\"define(\'DB_NAME\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:33:\"define(\'DB_USER\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:36:\"define(\'DB_PASSWORD\', \'SRVFHHx-16\');\";s:5:\"value\";s:12:\"\'SRVFHHx-16\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:14:\", \'SRVFHHx-16\'\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:31:\"define(\'DB_HOST\', \'localhost\');\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:13:\", \'localhost\'\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:29:\"define(\'DB_CHARSET\', \'utf8\');\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:8:\", \'utf8\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:25:\"define(\'DB_COLLATE\', \'\');\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_COLLATE\'\";i:1;s:4:\", \'\'\";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:87:\"define(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\";s:5:\"value\";s:66:\"\'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:68:\", \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:94:\"define(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\";s:5:\"value\";s:66:\"\',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:68:\", \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:92:\"define(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\";s:5:\"value\";s:66:\"\'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:68:\", \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:88:\"define(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\";s:5:\"value\";s:66:\"\'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:68:\", \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:88:\"define(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\";s:5:\"value\";s:66:\"\'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:68:\", \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\";s:5:\"value\";s:66:\"\'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:93:\"define(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\";s:5:\"value\";s:66:\"\'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:68:\", \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:89:\"define(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\";s:5:\"value\";s:66:\"\'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:68:\", \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:26:\"define(\'WP_DEBUG\', false);\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'WP_DEBUG\'\";i:1;s:7:\", false\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:44:\"	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\";s:5:\"value\";s:23:\"dirname(__FILE__) . \'/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"	define(\'ABSPATH\'\";i:1;s:25:\", dirname(__FILE__) . \'/\'\";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:30:\"$table_prefix = \'p0aadmzbh8_\';\";s:5:\"value\";s:13:\"\'p0aadmzbh8_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:15:\" \'p0aadmzbh8_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:13038308;s:4:\"File\";s:65:\"20150620_bodente_b7936927b6123bb72167_20230215112110_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:6:\"latin1\";i:1;s:7:\"utf8mb4\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:8:{i:0;s:17:\"latin1_general_cs\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:11:\"utf8mb3_bin\";i:3;s:18:\"utf8mb3_general_ci\";i:4;s:18:\"utf8mb3_unicode_ci\";i:5;s:18:\"utf8mb4_0900_ai_ci\";i:6;s:22:\"utf8mb4_unicode_520_ci\";i:7;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:1833;s:16:\"tablesSizeOnDisk\";i:16433199;s:10:\"tablesList\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:9280;}s:23:\"p0aadmzbh8_WP_SEO_Cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_WP_SEO_Redirection\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_blc_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"p0aadmzbh8_blc_instances\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"p0aadmzbh8_blc_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:20:\"p0aadmzbh8_blc_synch\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:27:\"p0aadmzbh8_csp3_subscribers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:52;s:12:\"insertedRows\";i:59;s:4:\"size\";i:344064;}s:19:\"p0aadmzbh8_eum_logs\";a:3:{s:14:\"inaccurateRows\";i:1326;s:12:\"insertedRows\";i:1326;s:4:\"size\";i:8600812;}s:24:\"p0aadmzbh8_ewwwio_images\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:10348;}s:21:\"p0aadmzbh8_itsec_bans\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_itsec_dashboard_events\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8336;}s:36:\"p0aadmzbh8_itsec_distributed_storage\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2546736;}s:29:\"p0aadmzbh8_itsec_fingerprints\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:34:\"p0aadmzbh8_itsec_geolocation_cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_itsec_lockouts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:20:\"p0aadmzbh8_itsec_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"p0aadmzbh8_itsec_logs\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:1319624;}s:24:\"p0aadmzbh8_itsec_mutexes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_itsec_opaque_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:21:\"p0aadmzbh8_itsec_temp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:28:\"p0aadmzbh8_itsec_user_groups\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2436;}s:16:\"p0aadmzbh8_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:18:\"p0aadmzbh8_options\";a:3:{s:14:\"inaccurateRows\";i:328;s:12:\"insertedRows\";i:352;s:4:\"size\";i:2670592;}s:19:\"p0aadmzbh8_postmeta\";a:3:{s:14:\"inaccurateRows\";i:13;s:12:\"insertedRows\";i:13;s:4:\"size\";i:49152;}s:16:\"p0aadmzbh8_posts\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:114688;}s:27:\"p0aadmzbh8_smush_dir_images\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:24:\"p0aadmzbh8_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:16:\"p0aadmzbh8_terms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_usermeta\";a:3:{s:14:\"inaccurateRows\";i:45;s:12:\"insertedRows\";i:45;s:4:\"size\";i:65536;}s:16:\"p0aadmzbh8_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:30:\"p0aadmzbh8_wpfront_ure_options\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:11040;}s:32:\"p0aadmzbh8_wpfront_ure_post_type\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:26:\"p0aadmzbh8_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:7;s:12:\"insertedRows\";i:7;s:4:\"size\";i:15380;}s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5225;}s:27:\"p0aadmzbh8_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:23;s:4:\"size\";i:8652;}s:29:\"p0aadmzbh8_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"p0aadmzbh8_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_yoast_seo_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2082;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.32\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:100:\"/home/solucion/wp/wp-snapshots/tmp/20150620_bodente_b7936927b6123bb72167_20230215112110_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-02-15 11:21:10\";s:7:\"Version\";s:7:\"1.5.2.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20150620_bodente\";s:4:\"Hash\";s:35:\"b7936927b6123bb72167_20230215112110\";s:8:\"NameHash\";s:52:\"20150620_bodente_b7936927b6123bb72167_20230215112110\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:474;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("76", "20150620_bodente", "8e71d373574d0eb28970_20230320103649", "100", "2023-03-20 10:37:12", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-20 10:36:49\";s:7:\"Version\";s:5:\"1.5.3\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:76;s:4:\"Name\";s:16:\"20150620_bodente\";s:4:\"Hash\";s:35:\"8e71d373574d0eb28970_20230320103649\";s:8:\"NameHash\";s:52:\"20150620_bodente_8e71d373574d0eb28970_20230320103649\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20150620_bodente_8e71d373574d0eb28970_20230320103649_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:9:\"3.55 sec.\";s:7:\"ExeSize\";s:7:\"73.34KB\";s:7:\"ZipSize\";s:6:\"2.86MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:64:\"20150620_bodente_8e71d373574d0eb28970_20230320103649_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:2997406;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2890;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11766;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:0;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:29:\"/home/solucion/wp/wp-includes\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:17:\"/home/solucion/wp\";i:1;s:17:\"/home/solucion/wp\";i:2;s:28:\"/home/solucion/wp/wp-content\";i:3;s:36:\"/home/solucion/wp/wp-content/uploads\";i:4;s:36:\"/home/solucion/wp/wp-content/plugins\";i:5;s:39:\"/home/solucion/wp/wp-content/mu-plugins\";i:6;s:35:\"/home/solucion/wp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:34:\"/home/solucion/wp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20150620_bodente_8e71d373574d0eb28970_20230320103649_installer.php.bak\";s:4:\"Size\";i:75104;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:86:\"/home/solucion/wp/wp-snapshots/tmp/original_files_8e71d37-20103649/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:66:\"/home/solucion/wp/wp-snapshots/tmp/original_files_8e71d37-20103649\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:17:\"/home/solucion/wp\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:31:\"/home/solucion/wp/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3505:\"<?php\n\n// BEGIN iThemes Security - No modifiques ni borres esta línea\n// iThemes Security Config Details: 2\ndefine( \'DISALLOW_FILE_EDIT\', true ); // Desactivar editor de archivos - Seguridad > Ajustes > Ajustes WordPress > Editor de archivos\n// END iThemes Security - No modifiques ni borres esta línea\n\n/** \n * Configuración básica de WordPress.\n *\n * Este archivo contiene las siguientes configuraciones: ajustes de MySQL, prefijo de tablas,\n * claves secretas, idioma de WordPress y ABSPATH. Para obtener más información,\n * visita la página del Codex{@link http://codex.wordpress.org/Editing_wp-config.php Editing\n * wp-config.php} . Los ajustes de MySQL te los proporcionará tu proveedor de alojamiento web.\n *\n * This file is used by the wp-config.php creation script during the\n * installation. You don\'t have to use the web site, you can just copy this file\n * to \"wp-config.php\" and fill in the values.\n *\n * @package WordPress\n */\n\n// ** Ajustes de MySQL. Solicita estos datos a tu proveedor de alojamiento web. ** //\n/** El nombre de tu base de datos de WordPress */\ndefine(\'DB_NAME\', \'solucion_wp\');\n\n/** Tu nombre de usuario de MySQL */\ndefine(\'DB_USER\', \'solucion_wp\');\n\n/** Tu contraseña de MySQL */\ndefine(\'DB_PASSWORD\', \'SRVFHHx-16\');\n\n/** Host de MySQL (es muy probable que no necesites cambiarlo) */\ndefine(\'DB_HOST\', \'localhost\');\n\n/** Codificación de caracteres para la base de datos. */\ndefine(\'DB_CHARSET\', \'utf8\');\n\n/** Cotejamiento de la base de datos. No lo modifiques si tienes dudas. */\ndefine(\'DB_COLLATE\', \'\');\n\n/**#@+\n * Claves únicas de autentificación.\n *\n * Define cada clave secreta con una frase aleatoria distinta.\n * Puedes generarlas usando el {@link https://api.wordpress.org/secret-key/1.1/salt/ servicio de claves secretas de WordPress}\n * Puedes cambiar las claves en cualquier momento para invalidar todas las cookies existentes. Esto forzará a todos los usuarios a volver a hacer login.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\ndefine(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\ndefine(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\ndefine(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\ndefine(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\ndefine(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\ndefine(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\ndefine(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\n\n/**#@-*/\n\n/**\n * Prefijo de la base de datos de WordPress.\n *\n * Cambia el prefijo si deseas instalar multiples blogs en una sola base de datos.\n * Emplea solo números, letras y guión bajo.\n */\n$table_prefix = \'p0aadmzbh8_\';\n\n\n/**\n * Para desarrolladores: modo debug de WordPress.\n *\n * Cambia esto a true para activar la muestra de avisos durante el desarrollo.\n * Se recomienda encarecidamente a los desarrolladores de temas y plugins que usen WP_DEBUG\n * en sus entornos de desarrollo.\n */\ndefine(\'WP_DEBUG\', false);\n\n/* ¡Eso es todo, deja de editar! Feliz blogging */\n\n/** WordPress absolute path to the Wordpress directory. */\nif ( !defined(\'ABSPATH\') )\n	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\n\n/** Sets up WordPress vars and included files. */\nrequire_once(ABSPATH . \'wp-settings.php\');\n\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:18:\"DISALLOW_FILE_EDIT\";a:3:{s:3:\"src\";s:37:\"define( \'DISALLOW_FILE_EDIT\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:28:\"define( \'DISALLOW_FILE_EDIT\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:33:\"define(\'DB_NAME\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:33:\"define(\'DB_USER\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:36:\"define(\'DB_PASSWORD\', \'SRVFHHx-16\');\";s:5:\"value\";s:12:\"\'SRVFHHx-16\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:14:\", \'SRVFHHx-16\'\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:31:\"define(\'DB_HOST\', \'localhost\');\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:13:\", \'localhost\'\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:29:\"define(\'DB_CHARSET\', \'utf8\');\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:8:\", \'utf8\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:25:\"define(\'DB_COLLATE\', \'\');\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_COLLATE\'\";i:1;s:4:\", \'\'\";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:87:\"define(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\";s:5:\"value\";s:66:\"\'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:68:\", \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:94:\"define(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\";s:5:\"value\";s:66:\"\',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:68:\", \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:92:\"define(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\";s:5:\"value\";s:66:\"\'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:68:\", \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:88:\"define(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\";s:5:\"value\";s:66:\"\'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:68:\", \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:88:\"define(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\";s:5:\"value\";s:66:\"\'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:68:\", \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\";s:5:\"value\";s:66:\"\'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:93:\"define(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\";s:5:\"value\";s:66:\"\'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:68:\", \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:89:\"define(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\";s:5:\"value\";s:66:\"\'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:68:\", \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:26:\"define(\'WP_DEBUG\', false);\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'WP_DEBUG\'\";i:1;s:7:\", false\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:44:\"	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\";s:5:\"value\";s:23:\"dirname(__FILE__) . \'/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"	define(\'ABSPATH\'\";i:1;s:25:\", dirname(__FILE__) . \'/\'\";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:30:\"$table_prefix = \'p0aadmzbh8_\';\";s:5:\"value\";s:13:\"\'p0aadmzbh8_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:15:\" \'p0aadmzbh8_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:13367111;s:4:\"File\";s:65:\"20150620_bodente_8e71d373574d0eb28970_20230320103649_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:6:\"latin1\";i:1;s:7:\"utf8mb4\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:8:{i:0;s:17:\"latin1_general_cs\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:11:\"utf8mb3_bin\";i:3;s:18:\"utf8mb3_general_ci\";i:4;s:18:\"utf8mb3_unicode_ci\";i:5;s:18:\"utf8mb4_0900_ai_ci\";i:6;s:22:\"utf8mb4_unicode_520_ci\";i:7;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:1917;s:16:\"tablesSizeOnDisk\";i:16717703;s:10:\"tablesList\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:9280;}s:23:\"p0aadmzbh8_WP_SEO_Cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_WP_SEO_Redirection\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_blc_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"p0aadmzbh8_blc_instances\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"p0aadmzbh8_blc_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:20:\"p0aadmzbh8_blc_synch\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:27:\"p0aadmzbh8_csp3_subscribers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:52;s:12:\"insertedRows\";i:60;s:4:\"size\";i:344064;}s:19:\"p0aadmzbh8_eum_logs\";a:3:{s:14:\"inaccurateRows\";i:1355;s:12:\"insertedRows\";i:1355;s:4:\"size\";i:8885316;}s:24:\"p0aadmzbh8_ewwwio_images\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:10348;}s:21:\"p0aadmzbh8_itsec_bans\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_itsec_dashboard_events\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8336;}s:36:\"p0aadmzbh8_itsec_distributed_storage\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2546736;}s:29:\"p0aadmzbh8_itsec_fingerprints\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:34:\"p0aadmzbh8_itsec_geolocation_cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_itsec_lockouts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:20:\"p0aadmzbh8_itsec_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"p0aadmzbh8_itsec_logs\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:1319624;}s:24:\"p0aadmzbh8_itsec_mutexes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_itsec_opaque_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:21:\"p0aadmzbh8_itsec_temp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:28:\"p0aadmzbh8_itsec_user_groups\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2436;}s:16:\"p0aadmzbh8_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:18:\"p0aadmzbh8_options\";a:3:{s:14:\"inaccurateRows\";i:353;s:12:\"insertedRows\";i:358;s:4:\"size\";i:2654208;}s:19:\"p0aadmzbh8_postmeta\";a:3:{s:14:\"inaccurateRows\";i:37;s:12:\"insertedRows\";i:37;s:4:\"size\";i:49152;}s:16:\"p0aadmzbh8_posts\";a:3:{s:14:\"inaccurateRows\";i:11;s:12:\"insertedRows\";i:11;s:4:\"size\";i:131072;}s:27:\"p0aadmzbh8_smush_dir_images\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:24:\"p0aadmzbh8_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:16:\"p0aadmzbh8_terms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_usermeta\";a:3:{s:14:\"inaccurateRows\";i:45;s:12:\"insertedRows\";i:46;s:4:\"size\";i:65536;}s:16:\"p0aadmzbh8_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:30:\"p0aadmzbh8_wpfront_ure_options\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:11040;}s:32:\"p0aadmzbh8_wpfront_ure_post_type\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:26:\"p0aadmzbh8_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:6;s:12:\"insertedRows\";i:6;s:4:\"size\";i:15380;}s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5225;}s:27:\"p0aadmzbh8_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:23;s:4:\"size\";i:8652;}s:29:\"p0aadmzbh8_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"p0aadmzbh8_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_yoast_seo_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2082;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.32\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:100:\"/home/solucion/wp/wp-snapshots/tmp/20150620_bodente_8e71d373574d0eb28970_20230320103649_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-20 10:36:49\";s:7:\"Version\";s:5:\"1.5.3\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20150620_bodente\";s:4:\"Hash\";s:35:\"8e71d373574d0eb28970_20230320103649\";s:8:\"NameHash\";s:52:\"20150620_bodente_8e71d373574d0eb28970_20230320103649\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:474;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("77", "20150620_bodente", "e3590a1214188f0c5486_20230320123318", "100", "2023-03-20 12:33:28", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-20 12:33:18\";s:7:\"Version\";s:5:\"1.5.3\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:77;s:4:\"Name\";s:16:\"20150620_bodente\";s:4:\"Hash\";s:35:\"e3590a1214188f0c5486_20230320123318\";s:8:\"NameHash\";s:52:\"20150620_bodente_e3590a1214188f0c5486_20230320123318\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20150620_bodente_e3590a1214188f0c5486_20230320123318_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";s:10:\"50.27 sec.\";s:7:\"ExeSize\";s:7:\"73.35KB\";s:7:\"ZipSize\";s:6:\"60.4MB\";s:6:\"Status\";s:5:\"100.0\";s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:64:\"20150620_bodente_e3590a1214188f0c5486_20230320123318_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:63329333;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2890;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11766;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:14655;s:10:\"\0*\0Package\";r:1;s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:29:\"/home/solucion/wp/wp-includes\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:17:\"/home/solucion/wp\";i:1;s:17:\"/home/solucion/wp\";i:2;s:28:\"/home/solucion/wp/wp-content\";i:3;s:36:\"/home/solucion/wp/wp-content/uploads\";i:4;s:36:\"/home/solucion/wp/wp-content/plugins\";i:5;s:39:\"/home/solucion/wp/wp-content/mu-plugins\";i:6;s:35:\"/home/solucion/wp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:34:\"/home/solucion/wp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20150620_bodente_e3590a1214188f0c5486_20230320123318_installer.php.bak\";s:4:\"Size\";i:75106;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:1;s:17:\"\0*\0origFileManger\";O:40:\"Duplicator\\Libs\\Snap\\SnapOrigFileManager\":4:{s:18:\"\0*\0persistanceFile\";s:86:\"/home/solucion/wp/wp-snapshots/tmp/original_files_e3590a1-20123318/entries_stored.json\";s:18:\"\0*\0origFilesFolder\";s:66:\"/home/solucion/wp/wp-snapshots/tmp/original_files_e3590a1-20123318\";s:20:\"\0*\0origFolderEntries\";a:0:{}s:11:\"\0*\0rootPath\";s:17:\"/home/solucion/wp\";}s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:31:\"/home/solucion/wp/wp-config.php\";s:16:\"\0*\0wp_config_src\";s:3505:\"<?php\n\n// BEGIN iThemes Security - No modifiques ni borres esta línea\n// iThemes Security Config Details: 2\ndefine( \'DISALLOW_FILE_EDIT\', true ); // Desactivar editor de archivos - Seguridad > Ajustes > Ajustes WordPress > Editor de archivos\n// END iThemes Security - No modifiques ni borres esta línea\n\n/** \n * Configuración básica de WordPress.\n *\n * Este archivo contiene las siguientes configuraciones: ajustes de MySQL, prefijo de tablas,\n * claves secretas, idioma de WordPress y ABSPATH. Para obtener más información,\n * visita la página del Codex{@link http://codex.wordpress.org/Editing_wp-config.php Editing\n * wp-config.php} . Los ajustes de MySQL te los proporcionará tu proveedor de alojamiento web.\n *\n * This file is used by the wp-config.php creation script during the\n * installation. You don\'t have to use the web site, you can just copy this file\n * to \"wp-config.php\" and fill in the values.\n *\n * @package WordPress\n */\n\n// ** Ajustes de MySQL. Solicita estos datos a tu proveedor de alojamiento web. ** //\n/** El nombre de tu base de datos de WordPress */\ndefine(\'DB_NAME\', \'solucion_wp\');\n\n/** Tu nombre de usuario de MySQL */\ndefine(\'DB_USER\', \'solucion_wp\');\n\n/** Tu contraseña de MySQL */\ndefine(\'DB_PASSWORD\', \'SRVFHHx-16\');\n\n/** Host de MySQL (es muy probable que no necesites cambiarlo) */\ndefine(\'DB_HOST\', \'localhost\');\n\n/** Codificación de caracteres para la base de datos. */\ndefine(\'DB_CHARSET\', \'utf8\');\n\n/** Cotejamiento de la base de datos. No lo modifiques si tienes dudas. */\ndefine(\'DB_COLLATE\', \'\');\n\n/**#@+\n * Claves únicas de autentificación.\n *\n * Define cada clave secreta con una frase aleatoria distinta.\n * Puedes generarlas usando el {@link https://api.wordpress.org/secret-key/1.1/salt/ servicio de claves secretas de WordPress}\n * Puedes cambiar las claves en cualquier momento para invalidar todas las cookies existentes. Esto forzará a todos los usuarios a volver a hacer login.\n *\n * @since 2.6.0\n */\ndefine(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\ndefine(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\ndefine(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\ndefine(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\ndefine(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\ndefine(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\ndefine(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\ndefine(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\n\n/**#@-*/\n\n/**\n * Prefijo de la base de datos de WordPress.\n *\n * Cambia el prefijo si deseas instalar multiples blogs en una sola base de datos.\n * Emplea solo números, letras y guión bajo.\n */\n$table_prefix = \'p0aadmzbh8_\';\n\n\n/**\n * Para desarrolladores: modo debug de WordPress.\n *\n * Cambia esto a true para activar la muestra de avisos durante el desarrollo.\n * Se recomienda encarecidamente a los desarrolladores de temas y plugins que usen WP_DEBUG\n * en sus entornos de desarrollo.\n */\ndefine(\'WP_DEBUG\', false);\n\n/* ¡Eso es todo, deja de editar! Feliz blogging */\n\n/** WordPress absolute path to the Wordpress directory. */\nif ( !defined(\'ABSPATH\') )\n	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\n\n/** Sets up WordPress vars and included files. */\nrequire_once(ABSPATH . \'wp-settings.php\');\n\n\";s:13:\"\0*\0wp_configs\";a:2:{s:8:\"constant\";a:17:{s:18:\"DISALLOW_FILE_EDIT\";a:3:{s:3:\"src\";s:37:\"define( \'DISALLOW_FILE_EDIT\', true );\";s:5:\"value\";s:4:\"true\";s:5:\"parts\";a:3:{i:0;s:28:\"define( \'DISALLOW_FILE_EDIT\'\";i:1;s:7:\", true \";i:2;s:2:\");\";}}s:7:\"DB_NAME\";a:3:{s:3:\"src\";s:33:\"define(\'DB_NAME\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_NAME\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:7:\"DB_USER\";a:3:{s:3:\"src\";s:33:\"define(\'DB_USER\', \'solucion_wp\');\";s:5:\"value\";s:13:\"\'solucion_wp\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_USER\'\";i:1;s:15:\", \'solucion_wp\'\";i:2;s:2:\");\";}}s:11:\"DB_PASSWORD\";a:3:{s:3:\"src\";s:36:\"define(\'DB_PASSWORD\', \'SRVFHHx-16\');\";s:5:\"value\";s:12:\"\'SRVFHHx-16\'\";s:5:\"parts\";a:3:{i:0;s:20:\"define(\'DB_PASSWORD\'\";i:1;s:14:\", \'SRVFHHx-16\'\";i:2;s:2:\");\";}}s:7:\"DB_HOST\";a:3:{s:3:\"src\";s:31:\"define(\'DB_HOST\', \'localhost\');\";s:5:\"value\";s:11:\"\'localhost\'\";s:5:\"parts\";a:3:{i:0;s:16:\"define(\'DB_HOST\'\";i:1;s:13:\", \'localhost\'\";i:2;s:2:\");\";}}s:10:\"DB_CHARSET\";a:3:{s:3:\"src\";s:29:\"define(\'DB_CHARSET\', \'utf8\');\";s:5:\"value\";s:6:\"\'utf8\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_CHARSET\'\";i:1;s:8:\", \'utf8\'\";i:2;s:2:\");\";}}s:10:\"DB_COLLATE\";a:3:{s:3:\"src\";s:25:\"define(\'DB_COLLATE\', \'\');\";s:5:\"value\";s:2:\"\'\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'DB_COLLATE\'\";i:1;s:4:\", \'\'\";i:2;s:2:\");\";}}s:8:\"AUTH_KEY\";a:3:{s:3:\"src\";s:87:\"define(\'AUTH_KEY\', \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\');\";s:5:\"value\";s:66:\"\'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'AUTH_KEY\'\";i:1;s:68:\", \'W;S6{fAk~bzQg<7!?{XW[Leq-MQR_{1F(g?8lz*-BfzH?<f/-3T9aY+_.BB*q}l/\'\";i:2;s:2:\");\";}}s:15:\"SECURE_AUTH_KEY\";a:3:{s:3:\"src\";s:94:\"define(\'SECURE_AUTH_KEY\', \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\');\";s:5:\"value\";s:66:\"\',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";s:5:\"parts\";a:3:{i:0;s:24:\"define(\'SECURE_AUTH_KEY\'\";i:1;s:68:\", \',k6hJL|`RpePjkM:@:1#RNYO$+t;#F{`PV^=<7VK_0[<~z+LrMl9[9j1VDTw8I:j\'\";i:2;s:2:\");\";}}s:13:\"LOGGED_IN_KEY\";a:3:{s:3:\"src\";s:92:\"define(\'LOGGED_IN_KEY\', \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\');\";s:5:\"value\";s:66:\"\'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";s:5:\"parts\";a:3:{i:0;s:22:\"define(\'LOGGED_IN_KEY\'\";i:1;s:68:\", \'}`>-EQsoceh#D<lVGxqs<z*O2z`x73GWzBE3^X^(1+U;&6Mk}3D-}jxRI<$bXiY-\'\";i:2;s:2:\");\";}}s:9:\"NONCE_KEY\";a:3:{s:3:\"src\";s:88:\"define(\'NONCE_KEY\', \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\');\";s:5:\"value\";s:66:\"\'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'NONCE_KEY\'\";i:1;s:68:\", \'J{MnMq< cO|(hD;.:v*)Ecz!.a#TiyCSn#50;ZZ<aQ#h(5e@]=Ur[(|_)5C||4Ie\'\";i:2;s:2:\");\";}}s:9:\"AUTH_SALT\";a:3:{s:3:\"src\";s:88:\"define(\'AUTH_SALT\', \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\');\";s:5:\"value\";s:66:\"\'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";s:5:\"parts\";a:3:{i:0;s:18:\"define(\'AUTH_SALT\'\";i:1;s:68:\", \'Fa4wZqp06|7NW!mJW70JORsviVm mVdRV7#h=|7Q(A|C?c~V`y|k%iG+3S=$ ]tU\'\";i:2;s:2:\");\";}}s:16:\"SECURE_AUTH_SALT\";a:3:{s:3:\"src\";s:95:\"define(\'SECURE_AUTH_SALT\', \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\');\";s:5:\"value\";s:66:\"\'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";s:5:\"parts\";a:3:{i:0;s:25:\"define(\'SECURE_AUTH_SALT\'\";i:1;s:68:\", \'V>1F=u-5V@<U$5bM|:W6a{R4GBGGp0[~UOdF9[.rZ|!BV#@L6wd7kVxR-4=?q~9~\'\";i:2;s:2:\");\";}}s:14:\"LOGGED_IN_SALT\";a:3:{s:3:\"src\";s:93:\"define(\'LOGGED_IN_SALT\', \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\');\";s:5:\"value\";s:66:\"\'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";s:5:\"parts\";a:3:{i:0;s:23:\"define(\'LOGGED_IN_SALT\'\";i:1;s:68:\", \'l!c)Z? k{~LKLl)dH+`SG>.pZ(n%R_N3WPKhOJsCg3!S$UViGs0@nW{!DcO([{JI\'\";i:2;s:2:\");\";}}s:10:\"NONCE_SALT\";a:3:{s:3:\"src\";s:89:\"define(\'NONCE_SALT\', \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\');\";s:5:\"value\";s:66:\"\'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";s:5:\"parts\";a:3:{i:0;s:19:\"define(\'NONCE_SALT\'\";i:1;s:68:\", \'E*Q&p8gwy*# Awi6O8F2ruAUw$Aj4`S>P>!53*]{Z1{+_.Sy4_[-enCA}3KTz{N$\'\";i:2;s:2:\");\";}}s:8:\"WP_DEBUG\";a:3:{s:3:\"src\";s:26:\"define(\'WP_DEBUG\', false);\";s:5:\"value\";s:5:\"false\";s:5:\"parts\";a:3:{i:0;s:17:\"define(\'WP_DEBUG\'\";i:1;s:7:\", false\";i:2;s:2:\");\";}}s:7:\"ABSPATH\";a:3:{s:3:\"src\";s:44:\"	define(\'ABSPATH\', dirname(__FILE__) . \'/\');\";s:5:\"value\";s:23:\"dirname(__FILE__) . \'/\'\";s:5:\"parts\";a:3:{i:0;s:17:\"	define(\'ABSPATH\'\";i:1;s:25:\", dirname(__FILE__) . \'/\'\";i:2;s:2:\");\";}}}s:8:\"variable\";a:1:{s:12:\"table_prefix\";a:3:{s:3:\"src\";s:30:\"$table_prefix = \'p0aadmzbh8_\';\";s:5:\"value\";s:13:\"\'p0aadmzbh8_\'\";s:5:\"parts\";a:2:{i:0;s:15:\"$table_prefix =\";i:1;s:15:\" \'p0aadmzbh8_\';\";}}}}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";i:13384507;s:4:\"File\";s:65:\"20150620_bodente_e3590a1214188f0c5486_20230320123318_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:3:{i:0;s:6:\"latin1\";i:1;s:7:\"utf8mb4\";i:2;s:7:\"utf8mb3\";}s:13:\"collationList\";a:8:{i:0;s:17:\"latin1_general_cs\";i:1;s:17:\"latin1_swedish_ci\";i:2;s:11:\"utf8mb3_bin\";i:3;s:18:\"utf8mb3_general_ci\";i:4;s:18:\"utf8mb3_unicode_ci\";i:5;s:18:\"utf8mb4_0900_ai_ci\";i:6;s:22:\"utf8mb4_unicode_520_ci\";i:7;s:18:\"utf8mb4_unicode_ci\";}s:10:\"engineList\";a:2:{i:0;s:6:\"MyISAM\";i:1;s:6:\"InnoDB\";}s:17:\"isTablesUpperCase\";i:1;s:15:\"isNameUpperCase\";i:0;s:4:\"name\";s:11:\"solucion_wp\";s:15:\"tablesBaseCount\";i:47;s:16:\"tablesFinalCount\";i:47;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:1916;s:16:\"tablesSizeOnDisk\";i:16717703;s:10:\"tablesList\";a:47:{s:27:\"p0aadmzbh8_WP_SEO_404_links\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:9280;}s:23:\"p0aadmzbh8_WP_SEO_Cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_WP_SEO_Redirection\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_WP_SEO_Redirection_LOG\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_blc_filters\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:24:\"p0aadmzbh8_blc_instances\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:20:\"p0aadmzbh8_blc_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:20:\"p0aadmzbh8_blc_synch\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:22:\"p0aadmzbh8_commentmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_comments\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:27:\"p0aadmzbh8_csp3_subscribers\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_duplicator_packages\";a:3:{s:14:\"inaccurateRows\";i:52;s:12:\"insertedRows\";i:61;s:4:\"size\";i:344064;}s:19:\"p0aadmzbh8_eum_logs\";a:3:{s:14:\"inaccurateRows\";i:1355;s:12:\"insertedRows\";i:1355;s:4:\"size\";i:8885316;}s:24:\"p0aadmzbh8_ewwwio_images\";a:3:{s:14:\"inaccurateRows\";i:1;s:12:\"insertedRows\";i:1;s:4:\"size\";i:10348;}s:21:\"p0aadmzbh8_itsec_bans\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:33:\"p0aadmzbh8_itsec_dashboard_events\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:8336;}s:36:\"p0aadmzbh8_itsec_distributed_storage\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2546736;}s:29:\"p0aadmzbh8_itsec_fingerprints\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:34:\"p0aadmzbh8_itsec_geolocation_cache\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_itsec_lockouts\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:98304;}s:20:\"p0aadmzbh8_itsec_log\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:49152;}s:21:\"p0aadmzbh8_itsec_logs\";a:3:{s:14:\"inaccurateRows\";i:4;s:12:\"insertedRows\";i:4;s:4:\"size\";i:1319624;}s:24:\"p0aadmzbh8_itsec_mutexes\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:30:\"p0aadmzbh8_itsec_opaque_tokens\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:2048;}s:21:\"p0aadmzbh8_itsec_temp\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:81920;}s:28:\"p0aadmzbh8_itsec_user_groups\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:2436;}s:16:\"p0aadmzbh8_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:18:\"p0aadmzbh8_options\";a:3:{s:14:\"inaccurateRows\";i:352;s:12:\"insertedRows\";i:365;s:4:\"size\";i:2654208;}s:19:\"p0aadmzbh8_postmeta\";a:3:{s:14:\"inaccurateRows\";i:37;s:12:\"insertedRows\";i:37;s:4:\"size\";i:49152;}s:16:\"p0aadmzbh8_posts\";a:3:{s:14:\"inaccurateRows\";i:11;s:12:\"insertedRows\";i:11;s:4:\"size\";i:131072;}s:27:\"p0aadmzbh8_smush_dir_images\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:29:\"p0aadmzbh8_term_relationships\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:32768;}s:24:\"p0aadmzbh8_term_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_termmeta\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:16:\"p0aadmzbh8_terms\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:49152;}s:19:\"p0aadmzbh8_usermeta\";a:3:{s:14:\"inaccurateRows\";i:45;s:12:\"insertedRows\";i:46;s:4:\"size\";i:65536;}s:16:\"p0aadmzbh8_users\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:1;s:4:\"size\";i:65536;}s:37:\"p0aadmzbh8_wpfront_ure_login_redirect\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:30:\"p0aadmzbh8_wpfront_ure_options\";a:3:{s:14:\"inaccurateRows\";i:10;s:12:\"insertedRows\";i:10;s:4:\"size\";i:11040;}s:32:\"p0aadmzbh8_wpfront_ure_post_type\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:31:\"p0aadmzbh8_wpfront_ure_taxonomy\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:4096;}s:26:\"p0aadmzbh8_yoast_indexable\";a:3:{s:14:\"inaccurateRows\";i:6;s:12:\"insertedRows\";i:6;s:4:\"size\";i:15380;}s:36:\"p0aadmzbh8_yoast_indexable_hierarchy\";a:3:{s:14:\"inaccurateRows\";i:5;s:12:\"insertedRows\";i:5;s:4:\"size\";i:5225;}s:27:\"p0aadmzbh8_yoast_migrations\";a:3:{s:14:\"inaccurateRows\";i:23;s:12:\"insertedRows\";i:23;s:4:\"size\";i:8652;}s:29:\"p0aadmzbh8_yoast_primary_term\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:26:\"p0aadmzbh8_yoast_seo_links\";a:3:{s:14:\"inaccurateRows\";i:0;s:12:\"insertedRows\";i:0;s:4:\"size\";i:1024;}s:25:\"p0aadmzbh8_yoast_seo_meta\";a:3:{s:14:\"inaccurateRows\";i:2;s:12:\"insertedRows\";i:2;s:4:\"size\";i:2082;}}s:18:\"varLowerCaseTables\";s:1:\"0\";s:8:\"dbEngine\";s:5:\"MySQL\";s:7:\"version\";s:6:\"8.0.32\";s:14:\"versionComment\";s:28:\"MySQL Community Server - GPL\";s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:100:\"/home/solucion/wp/wp-snapshots/tmp/20150620_bodente_e3590a1214188f0c5486_20230320123318_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:1;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-20 12:33:18\";s:7:\"Version\";s:5:\"1.5.3\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20150620_bodente\";s:4:\"Hash\";s:35:\"e3590a1214188f0c5486_20230320123318\";s:8:\"NameHash\";s:52:\"20150620_bodente_e3590a1214188f0c5486_20230320123318\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";r:84;s:8:\"Database\";r:234;s:13:\"BuildProgress\";r:474;}}}");
INSERT INTO `p0aadmzbh8_duplicator_packages` VALUES("78", "20150620_bodente", "f74fd754713615965151_20230322082740", "23", "2023-03-22 08:28:14", "Angel", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-22 08:27:40\";s:7:\"Version\";s:7:\"1.5.3.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:78;s:4:\"Name\";s:16:\"20150620_bodente\";s:4:\"Hash\";s:35:\"f74fd754713615965151_20230322082740\";s:8:\"NameHash\";s:52:\"20150620_bodente_f74fd754713615965151_20230322082740\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20150620_bodente_f74fd754713615965151_20230322082740_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.6\";s:6:\"WPUser\";s:5:\"Angel\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:64:\"20150620_bodente_f74fd754713615965151_20230322082740_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:17:\"/home/solucion/wp\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2890;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11766;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2023-03-22 08:27:40\";s:7:\"Version\";s:7:\"1.5.3.1\";s:9:\"VersionWP\";s:5:\"6.1.1\";s:9:\"VersionDB\";s:6:\"8.0.32\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20150620_bodente\";s:4:\"Hash\";s:35:\"f74fd754713615965151_20230322082740\";s:8:\"NameHash\";s:52:\"20150620_bodente_f74fd754713615965151_20230322082740\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20150620_bodente_f74fd754713615965151_20230322082740_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:31:\"/home/solucion/wp/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:65:\"20150620_bodente_f74fd754713615965151_20230322082740_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:18:\"varLowerCaseTables\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:100:\"/home/solucion/wp/wp-snapshots/tmp/20150620_bodente_f74fd754713615965151_20230322082740_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:26:\"/home/solucion/wp/wp-admin\";i:1;s:29:\"/home/solucion/wp/wp-includes\";i:2;s:38:\"/home/solucion/wp/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:17:\"/home/solucion/wp\";i:1;s:17:\"/home/solucion/wp\";i:2;s:28:\"/home/solucion/wp/wp-content\";i:3;s:36:\"/home/solucion/wp/wp-content/uploads\";i:4;s:36:\"/home/solucion/wp/wp-content/plugins\";i:5;s:39:\"/home/solucion/wp/wp-content/mu-plugins\";i:6;s:35:\"/home/solucion/wp/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:34:\"/home/solucion/wp/wp-snapshots/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: p0aadmzbh8_eum_logs */
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("1", "0", "EWWW Image Optimizer", "plugin", "4.5.2", "4.5.3", "automatic", "1", "2018-12-10 13:29:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("2", "0", "Smush", "plugin", "2.9.1", "3.0.0", "automatic", "1", "2018-12-10 13:29:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("3", "0", "Contact Form 7", "plugin", "5.0.5", "5.1", "automatic", "1", "2018-12-13 18:39:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("4", "0", "Smush", "plugin", "3.0.0", "3.0.1", "automatic", "1", "2018-12-13 18:39:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("5", "0", "TinyMCE Advanced", "plugin", "4.8.0", "4.8.1", "automatic", "1", "2018-12-13 18:39:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("6", "0", "WordPress 4.9.9", "core", "4.9.8", "5.0.1", "automatic", "1", "2018-12-13 18:39:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("7", "0", "Contact Form 7 (es_ES)", "translation", "5.1", "5.1", "automatic", "1", "2018-12-13 18:39:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("8", "0", "Smush (es_ES)", "translation", "3.0.1", "3.0.1", "automatic", "1", "2018-12-13 18:39:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("9", "0", "TinyMCE Advanced (es_ES)", "translation", "4.8.1", "4.8.1", "automatic", "1", "2018-12-13 18:39:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("10", "0", "Duplicator (es_ES)", "translation", "1.2.52", "1.2.52", "automatic", "1", "2018-12-14 00:12:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("11", "0", "Duplicator (es_ES)", "translation", "1.2.52", "1.2.52", "automatic", "1", "2018-12-14 20:56:23", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("12", "0", "Contact Form 7", "plugin", "5.1", "5.1.1", "automatic", "1", "2018-12-21 10:38:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("13", "0", "Duplicator", "plugin", "1.2.52", "1.3.0", "automatic", "1", "2018-12-21 10:38:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("14", "0", "GDPR Cookie Consent", "plugin", "1.7.1", "1.7.2", "automatic", "1", "2018-12-21 10:38:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("15", "0", "Smush", "plugin", "3.0.1", "3.0.2", "automatic", "1", "2018-12-21 10:38:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("16", "0", "TinyMCE Advanced", "plugin", "4.8.1", "4.8.2", "automatic", "1", "2018-12-21 10:38:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("17", "0", "Yoast SEO", "plugin", "9.2.1", "9.3", "automatic", "1", "2018-12-21 10:38:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("18", "0", "Smush (es_ES)", "translation", "3.0.2", "3.0.2", "automatic", "1", "2018-12-21 10:38:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("19", "0", "TinyMCE Advanced (es_ES)", "translation", "4.8.2", "4.8.2", "automatic", "1", "2018-12-21 10:38:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("20", "0", "Yoast SEO (es_ES)", "translation", "9.3", "9.3", "automatic", "1", "2018-12-21 10:38:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("21", "0", "Duplicator (es_ES)", "translation", "1.3.0", "1.3.0", "automatic", "1", "2018-12-24 20:53:29", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("22", "0", "Yoast SEO (es_ES)", "translation", "9.3", "9.3", "automatic", "1", "2018-12-28 01:11:51", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("23", "0", "Duplicator (es_ES)", "translation", "1.3.0", "1.3.0", "automatic", "1", "2018-12-28 20:06:17", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("24", "0", "iThemes Security (es_ES)", "translation", "7.2.0", "7.2.0", "automatic", "1", "2018-12-28 20:06:17", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("25", "0", "Admin Custom Login", "plugin", "2.7.8", "2.7.9", "automatic", "1", "2019-01-01 03:05:04", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("26", "0", "Duplicator", "plugin", "1.3.0", "1.3.2", "automatic", "1", "2019-01-01 03:05:04", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("27", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.3.2", "7.3.3", "automatic", "1", "2019-01-01 03:05:04", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("28", "0", "iThemes Security (es_ES)", "translation", "7.2.0", "7.2.0", "automatic", "1", "2019-01-01 03:05:04", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("29", "0", "Social Mobile Messaging Bar", "plugin", "1.1.7", "1.1.8", "automatic", "1", "2019-01-03 08:23:22", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("30", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.3.3", "7.3.3", "automatic", "1", "2019-01-03 08:23:22", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("31", "0", "GDPR Cookie Consent", "plugin", "1.7.2", "1.7.3", "automatic", "1", "2019-01-11 07:16:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("32", "0", "Yoast SEO", "plugin", "9.3", "9.4", "automatic", "1", "2019-01-11 07:16:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("33", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.7.3", "1.7.3", "automatic", "1", "2019-01-11 07:16:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("34", "0", "Smush (es_ES)", "translation", "3.0.2", "3.0.2", "automatic", "1", "2019-01-11 07:16:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("35", "0", "Yoast SEO (es_ES)", "translation", "9.4", "9.4", "automatic", "1", "2019-01-11 07:16:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("36", "0", "Duplicator", "plugin", "1.3.2", "1.3.4", "automatic", "1", "2019-01-17 13:06:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("37", "0", "EWWW Image Optimizer", "plugin", "4.5.3", "4.6.0", "automatic", "1", "2019-01-17 13:06:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("38", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.3.3", "7.4.1", "automatic", "1", "2019-01-17 13:06:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("39", "0", "TinyMCE Advanced", "plugin", "4.8.2", "5.0.0", "automatic", "1", "2019-01-17 13:06:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("40", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.6.0", "4.6.0", "automatic", "1", "2019-01-17 13:06:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("41", "0", "Lazy Load (es_ES)", "translation", "0.6.1", "0.6.1", "automatic", "1", "2019-01-17 13:06:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("42", "0", "TinyMCE Advanced (es_ES)", "translation", "5.0.0", "5.0.0", "automatic", "1", "2019-01-17 13:06:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("43", "0", "Yoast SEO (es_ES)", "translation", "9.4", "9.4", "automatic", "1", "2019-01-17 13:06:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("44", "0", "Contact Form 7 Honeypot", "plugin", "1.13", "1.14", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("45", "0", "EWWW Image Optimizer", "plugin", "4.6.0", "4.6.1", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("46", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.4.1", "7.4.2", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("47", "0", "TinyMCE Advanced", "plugin", "5.0.0", "5.0.1", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("48", "0", "W3 Total Cache", "plugin", "0.9.7", "0.9.7.1", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("49", "0", "WPFront User Role Editor", "plugin", "2.14.1", "2.14.2", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("50", "0", "Yoast SEO", "plugin", "9.4", "9.5", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("51", "0", "Contact Form 7 Honeypot (es_ES)", "translation", "1.14", "1.14", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("52", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.6.1", "4.6.1", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("53", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.4.2", "7.4.2", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("54", "0", "Yoast SEO (es_ES)", "translation", "9.5", "9.5", "automatic", "1", "2019-01-29 22:16:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("55", "0", "Akismet Anti-Spam", "plugin", "4.1", "4.1.1", "automatic", "1", "2019-02-01 05:53:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("56", "0", "EWWW Image Optimizer", "plugin", "4.6.1", "4.6.2", "automatic", "1", "2019-02-01 05:53:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("57", "0", "W3 Total Cache", "plugin", "0.9.7.1", "0.9.7.2", "automatic", "1", "2019-02-01 05:53:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("58", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.6.2", "4.6.2", "automatic", "1", "2019-02-05 02:11:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("59", "0", "Smush", "plugin", "3.0.2", "3.1.1", "automatic", "1", "2019-02-11 23:48:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("60", "0", "WordPress (es_ES)", "translation", "4.9.9", "4.9.9", "automatic", "1", "2019-02-11 23:48:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("61", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.6.2", "4.6.2", "automatic", "1", "2019-02-11 23:48:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("62", "0", "Smush (es_ES)", "translation", "3.1.1", "3.1.1", "automatic", "1", "2019-02-11 23:48:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("63", "0", "Yoast SEO", "plugin", "9.5", "9.6", "automatic", "1", "2019-02-12 13:49:16", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("64", "0", "Yoast SEO (es_ES)", "translation", "9.6", "9.6", "automatic", "1", "2019-02-12 13:49:16", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("65", "0", "EWWW Image Optimizer", "plugin", "4.6.2", "4.6.3", "automatic", "1", "2019-02-14 04:24:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("66", "0", "iThemes Security", "plugin", "7.2.0", "7.3.0", "automatic", "1", "2019-02-15 14:54:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("67", "0", "iThemes Security (es_ES)", "translation", "7.3.0", "7.3.0", "automatic", "1", "2019-02-15 14:54:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("68", "0", "Admin Custom Login", "plugin", "2.7.9", "2.8.0", "automatic", "1", "2019-02-19 16:50:22", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("69", "0", "Coming Soon Page &amp; Maintenance Mode by SeedProd ", "plugin", "5.0.23", "5.0.24", "automatic", "1", "2019-02-22 03:18:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("70", "0", "Duplicator", "plugin", "1.3.4", "1.3.6", "automatic", "1", "2019-02-22 03:18:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("71", "0", "iThemes Security", "plugin", "7.3.0", "7.3.1", "automatic", "1", "2019-02-22 03:18:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("72", "0", "Duplicator", "plugin", "1.3.6", "1.3.8", "automatic", "1", "2019-02-25 08:27:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("73", "0", "Coming Soon Page & Maintenance Mode by SeedProd (es_ES)", "translation", "5.0.24", "5.0.24", "automatic", "1", "2019-02-25 08:27:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("74", "0", "Admin Custom Login", "plugin", "2.8.0", "2.8.1", "automatic", "1", "2019-02-28 07:32:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("75", "0", "Yoast SEO", "plugin", "9.6", "9.7", "automatic", "1", "2019-02-28 07:32:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("76", "0", "Yoast SEO (es_ES)", "translation", "9.7", "9.7", "automatic", "1", "2019-02-28 07:32:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("77", "0", "Admin Custom Login", "plugin", "2.8.1", "2.8.2", "automatic", "1", "2019-03-01 03:48:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("78", "0", "GDPR Cookie Consent", "plugin", "1.7.3", "1.7.4", "automatic", "1", "2019-03-06 16:41:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("79", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.7.4", "1.7.4", "automatic", "1", "2019-03-06 16:41:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("80", "0", "Loco Translate", "plugin", "2.2.0", "2.2.1", "automatic", "1", "2019-03-09 12:00:44", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("81", "0", "Loco Translate (es_ES)", "translation", "2.2.1", "2.2.1", "automatic", "1", "2019-03-09 12:00:44", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("82", "0", "GDPR Cookie Consent", "plugin", "1.7.4", "1.7.5", "automatic", "1", "2019-03-12 04:55:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("83", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.7.5", "1.7.5", "automatic", "1", "2019-03-12 04:55:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("84", "0", "GDPR Cookie Consent", "plugin", "1.7.5", "1.7.6", "automatic", "1", "2019-03-14 14:25:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("85", "0", "WordPress 4.9.10", "core", "4.9.9", "5.1.1", "automatic", "1", "2019-03-14 14:25:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("86", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.7.6", "1.7.6", "automatic", "1", "2019-03-14 14:25:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("87", "0", "Duplicator", "plugin", "1.3.8", "1.3.10", "automatic", "1", "2019-03-20 00:06:52", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("88", "0", "EWWW Image Optimizer", "plugin", "4.6.3", "4.7.0", "automatic", "1", "2019-03-20 00:06:52", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("89", "0", "iThemes Security", "plugin", "7.3.1", "7.3.2", "automatic", "1", "2019-03-20 00:06:52", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("90", "0", "Smush", "plugin", "3.1.1", "3.2.0.1", "automatic", "1", "2019-03-20 00:06:52", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("91", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.7.0", "4.7.0", "automatic", "1", "2019-03-20 00:06:52", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("92", "0", "Smush (es_ES)", "translation", "3.2.0.1", "3.2.0.1", "automatic", "1", "2019-03-20 00:06:52", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("93", "0", "Admin Custom Login", "plugin", "2.8.2", "2.8.4", "automatic", "1", "2019-03-20 14:10:16", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("94", "0", "Broken Link Checker", "plugin", "1.11.5", "1.11.8", "automatic", "1", "2019-03-21 21:24:14", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("95", "0", "Broken Link Checker (es_ES)", "translation", "1.11.8", "1.11.8", "automatic", "1", "2019-03-23 07:16:12", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("96", "0", "Coming Soon Page &amp; Maintenance Mode by SeedProd ", "plugin", "5.0.24", "5.0.25", "automatic", "1", "2019-03-26 02:37:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("97", "0", "iThemes Security", "plugin", "7.3.2", "7.3.3", "automatic", "1", "2019-03-26 02:37:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("98", "0", "EWWW Image Optimizer", "plugin", "4.7.0", "4.7.1", "automatic", "1", "2019-03-27 02:02:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("99", "0", "W3 Total Cache", "plugin", "0.9.7.2", "0.9.7.3", "automatic", "1", "2019-03-27 02:02:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("100", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.7.1", "4.7.1", "automatic", "1", "2019-03-27 02:02:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("101", "0", "Easy Updates Manager", "plugin", "8.0.3", "8.0.5", "automatic", "1", "2019-03-29 16:38:12", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("102", "0", "Duplicate Post (es_ES)", "translation", "3.2.2", "3.2.2", "automatic", "1", "2019-03-29 16:38:12", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("103", "0", "Admin Custom Login", "plugin", "2.8.4", "2.8.5", "automatic", "1", "2019-03-30 04:24:52", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("104", "0", "Admin Custom Login", "plugin", "2.8.5", "2.8.6", "automatic", "1", "2019-03-31 07:59:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("105", "0", "Loco Translate", "plugin", "2.2.1", "2.2.2", "automatic", "1", "2019-03-31 07:59:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("106", "0", "Loco Translate (es_ES)", "translation", "2.2.2", "2.2.2", "automatic", "1", "2019-04-02 01:22:30", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("107", "0", "Yoast SEO", "plugin", "9.7", "10.1", "automatic", "1", "2019-04-02 10:29:23", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("108", "0", "Yoast SEO (es_ES)", "translation", "10.0.1", "10.0.1", "automatic", "1", "2019-04-02 10:29:23", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("109", "0", "EWWW Image Optimizer", "plugin", "4.7.1", "4.7.2", "automatic", "1", "2019-04-03 05:10:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("110", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.4.2", "7.5.0", "automatic", "1", "2019-04-03 05:10:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("111", "0", "Yoast SEO", "plugin", "10.1", "10.1.1", "automatic", "1", "2019-04-03 05:10:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("112", "0", "Yoast SEO (es_ES)", "translation", "10.1.1", "10.1.1", "automatic", "1", "2019-04-03 05:10:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("113", "0", "Yoast SEO", "plugin", "10.1.1", "10.1.2", "automatic", "1", "2019-04-03 14:15:47", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("114", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.7.2", "4.7.2", "automatic", "1", "2019-04-04 10:28:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("115", "0", "Yoast SEO", "plugin", "10.1.2", "10.1.3", "automatic", "1", "2019-04-06 06:39:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("116", "0", "Admin Custom Login", "plugin", "2.8.6", "2.8.7", "automatic", "1", "2019-04-10 16:57:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("117", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.5.0", "7.5.1", "automatic", "1", "2019-04-10 16:57:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("118", "0", "Resize Image After Upload", "plugin", "1.8.5", "1.8.6", "automatic", "1", "2019-04-10 16:57:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("119", "3", "WordPress 5.1.1", "core", "4.9.10", "5.1.1", "manual", "1", "2019-04-10 16:58:26", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("120", "3", "WordPress (es_ES)", "core", "4.9.10", "4.9.10", "manual", "1", "2019-04-10 16:58:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("121", "0", "Yoast SEO (es_ES)", "translation", "10.1.3", "10.1.3", "automatic", "1", "2019-04-12 15:17:29", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("122", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.5.1", "7.5.1", "automatic", "1", "2019-04-16 01:44:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("123", "0", "Admin Custom Login", "plugin", "2.8.7", "2.8.8", "automatic", "1", "2019-04-19 19:09:23", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("124", "0", "EWWW Image Optimizer", "plugin", "4.7.2", "4.7.3", "automatic", "1", "2019-04-19 19:09:23", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("125", "0", "Yoast SEO", "plugin", "10.1.3", "11.0", "automatic", "1", "2019-04-19 19:09:23", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("126", "0", "Yoast SEO (es_ES)", "translation", "11.0", "11.0", "automatic", "1", "2019-04-19 19:09:23", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("127", "0", "Autoptimize", "plugin", "2.4.4", "2.5.0", "automatic", "1", "2019-04-22 06:46:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("128", "0", "Autoptimize (es_ES)", "translation", "2.5.0", "2.5.0", "automatic", "1", "2019-04-22 06:46:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("129", "0", "Admin Custom Login", "plugin", "2.8.8", "2.9.0", "automatic", "1", "2019-04-27 19:12:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("130", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.5.1", "7.6.0", "automatic", "1", "2019-04-27 19:12:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("131", "0", "WordPress (es_ES)", "translation", "5.1.1", "5.1.1", "automatic", "1", "2019-04-27 19:12:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("132", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.6.0", "7.6.0", "automatic", "1", "2019-04-27 19:12:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("133", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.6.0", "7.6.0", "automatic", "1", "2019-04-28 13:48:57", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("134", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.6.0", "7.6.0", "automatic", "1", "2019-04-29 06:33:29", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("135", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.6.0", "7.6.0", "automatic", "1", "2019-04-29 12:48:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("136", "0", "Yoast SEO", "plugin", "11.0", "11.1", "automatic", "1", "2019-04-30 18:06:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("137", "0", "Yoast SEO (es_ES)", "translation", "11.1", "11.1", "automatic", "1", "2019-04-30 18:06:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("138", "0", "Yoast SEO (es_ES)", "translation", "11.1", "11.1", "automatic", "1", "2019-04-30 21:06:12", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("139", "0", "Duplicator", "plugin", "1.3.10", "1.3.12", "automatic", "1", "2019-05-04 12:17:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("140", "0", "Yoast SEO", "plugin", "11.1", "11.1.1", "automatic", "1", "2019-05-06 11:10:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("141", "0", "W3 Total Cache", "plugin", "0.9.7.3", "0.9.7.4", "automatic", "1", "2019-05-06 22:05:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("142", "0", "Yoast SEO (es_ES)", "translation", "11.1.1", "11.1.1", "automatic", "1", "2019-05-06 22:05:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("143", "0", "EWWW Image Optimizer", "plugin", "4.7.3", "4.7.4", "automatic", "1", "2019-05-08 11:57:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("144", "0", "Admin Custom Login", "plugin", "2.9.0", "2.9.1", "automatic", "1", "2019-05-14 08:02:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("145", "0", "Akismet Anti-Spam", "plugin", "4.1.1", "4.1.2", "automatic", "1", "2019-05-14 19:07:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("146", "0", "Yoast SEO", "plugin", "11.1.1", "11.2", "automatic", "1", "2019-05-16 10:13:33", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("147", "0", "Easy Updates Manager (es_ES)", "translation", "8.0.5", "8.0.5", "automatic", "1", "2019-05-16 10:13:33", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("148", "0", "Yoast SEO (es_ES)", "translation", "11.2", "11.2", "automatic", "1", "2019-05-16 10:13:33", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("149", "0", "Yoast SEO", "plugin", "11.2", "11.2.1", "automatic", "1", "2019-05-17 14:22:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("150", "0", "Yoast SEO (es_ES)", "translation", "11.2.1", "11.2.1", "automatic", "1", "2019-05-17 14:22:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("151", "0", "Admin Custom Login", "plugin", "2.9.1", "2.9.2", "automatic", "1", "2019-05-22 06:21:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("152", "0", "Autoptimize", "plugin", "2.5.0", "2.5.1", "automatic", "1", "2019-05-22 06:21:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("153", "0", "Contact Form 7", "plugin", "5.1.1", "5.1.3", "automatic", "1", "2019-05-22 06:21:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("154", "0", "Duplicator", "plugin", "1.3.12", "1.3.14", "automatic", "1", "2019-05-22 06:21:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("155", "0", "Social Mobile Messaging Bar", "plugin", "1.1.8", "1.1.10", "automatic", "1", "2019-05-22 06:21:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("156", "0", "Contact Form 7 (es_ES)", "translation", "5.1.3", "5.1.3", "automatic", "1", "2019-05-22 06:22:00", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("157", "0", "Yoast SEO (es_ES)", "translation", "11.2.1", "11.2.1", "automatic", "1", "2019-05-28 03:51:11", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("158", "0", "Yoast SEO", "plugin", "11.2.1", "11.3", "automatic", "1", "2019-05-28 14:21:00", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("159", "0", "Yoast SEO (es_ES)", "translation", "11.3", "11.3", "automatic", "1", "2019-05-28 14:21:00", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("160", "0", "Loco Translate", "plugin", "2.2.2", "2.3.0", "automatic", "1", "2019-06-03 05:01:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("161", "0", "Loco Translate (es_ES)", "translation", "2.3.0", "2.3.0", "automatic", "1", "2019-06-03 05:01:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("162", "0", "GDPR Cookie Consent", "plugin", "1.7.6", "1.7.7", "automatic", "1", "2019-06-03 18:33:47", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("163", "0", "EWWW Image Optimizer", "plugin", "4.7.4", "4.8.0", "automatic", "1", "2019-06-06 09:09:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("164", "0", "W3 Total Cache", "plugin", "0.9.7.4", "0.9.7.5", "automatic", "1", "2019-06-06 09:09:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("165", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.8.0", "4.8.0", "automatic", "1", "2019-06-06 09:09:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("166", "0", "iThemes Security", "plugin", "7.3.3", "7.4.0", "automatic", "1", "2019-06-11 06:55:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("167", "0", "iThemes Security (es_ES)", "translation", "7.4.0", "7.4.0", "automatic", "1", "2019-06-11 06:55:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("168", "0", "Smush (es_ES)", "translation", "3.2.1", "3.2.1", "automatic", "1", "2019-06-12 05:58:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("169", "0", "Yoast SEO", "plugin", "11.3", "11.4", "automatic", "1", "2019-06-14 04:08:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("170", "0", "Yoast SEO (es_ES)", "translation", "11.4", "11.4", "automatic", "1", "2019-06-14 04:08:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("171", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.6.0", "7.7.1", "automatic", "1", "2019-06-19 21:36:36", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("172", "0", "Social Mobile Messaging Bar", "plugin", "1.1.10", "1.1.11", "automatic", "1", "2019-06-23 04:10:34", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("173", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.7.1", "7.7.1", "automatic", "1", "2019-06-23 04:10:34", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("174", "0", "Yoast SEO", "plugin", "11.4", "11.5", "automatic", "1", "2019-06-26 01:16:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("175", "0", "Admin Custom Login", "plugin", "2.9.3", "2.9.4", "automatic", "1", "2019-06-29 14:08:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("176", "0", "EWWW Image Optimizer", "plugin", "4.8.0", "4.8.1", "automatic", "1", "2019-07-04 16:34:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("177", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.8.1", "4.8.1", "automatic", "1", "2019-07-04 16:34:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("178", "0", "Duplicate Post", "plugin", "3.2.2", "3.2.3", "automatic", "1", "2019-07-11 07:00:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("179", "0", "Duplicator", "plugin", "1.3.14", "1.3.16", "automatic", "1", "2019-07-11 07:00:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("180", "0", "Yoast SEO", "plugin", "11.5", "11.6", "automatic", "1", "2019-07-11 07:00:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("181", "0", "Duplicate Post (es_ES)", "translation", "3.2.3", "3.2.3", "automatic", "1", "2019-07-11 07:00:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("182", "0", "Yoast SEO (es_ES)", "translation", "11.6", "11.6", "automatic", "1", "2019-07-11 07:00:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("183", "0", "Duplicator", "plugin", "1.3.16", "1.3.18", "automatic", "1", "2019-07-14 02:42:39", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("184", "0", "Smush (es_ES)", "translation", "3.2.1", "3.2.1", "automatic", "1", "2019-07-14 02:42:39", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("185", "0", "GDPR Cookie Consent", "plugin", "1.7.7", "1.7.8", "automatic", "1", "2019-07-17 03:28:11", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("186", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.7.8", "1.7.8", "automatic", "1", "2019-07-17 03:28:11", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("187", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.7.8", "1.7.8", "automatic", "1", "2019-07-18 03:12:30", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("188", "0", "Smush", "plugin", "3.2.1", "3.2.2.1", "automatic", "1", "2019-07-26 01:26:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("189", "0", "Yoast SEO", "plugin", "11.6", "11.7", "automatic", "1", "2019-07-26 01:26:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("190", "0", "Smush (es_ES)", "translation", "3.2.2.1", "3.2.2.1", "automatic", "1", "2019-07-26 01:26:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("191", "0", "Yoast SEO (es_ES)", "translation", "11.7", "11.7", "automatic", "1", "2019-07-26 01:26:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("192", "0", "Yoast SEO (es_ES)", "translation", "11.7", "11.7", "automatic", "1", "2019-07-29 16:42:41", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("193", "0", "Contact Form 7", "plugin", "5.1.3", "5.1.4", "automatic", "1", "2019-08-05 08:30:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("194", "0", "Contact Form 7 (es_ES)", "translation", "5.1.4", "5.1.4", "automatic", "1", "2019-08-05 08:30:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("195", "0", "Coming Soon Page &amp; Maintenance Mode by SeedProd ", "plugin", "5.0.25", "5.0.26", "automatic", "1", "2019-08-06 08:33:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("196", "0", "Yoast SEO", "plugin", "11.7", "11.8", "automatic", "1", "2019-08-06 08:33:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("197", "0", "Coming Soon Page & Maintenance Mode by SeedProd (es_ES)", "translation", "5.0.26", "5.0.26", "automatic", "1", "2019-08-06 08:33:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("198", "0", "Yoast SEO (es_ES)", "translation", "11.8", "11.8", "automatic", "1", "2019-08-07 13:38:12", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("199", "0", "Smush", "plugin", "3.2.2.1", "3.2.4", "automatic", "1", "2019-08-08 03:09:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("200", "0", "Contact Form 7 (es_ES)", "translation", "5.1.4", "5.1.4", "automatic", "1", "2019-08-08 03:09:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("201", "0", "Smush (es_ES)", "translation", "3.2.4", "3.2.4", "automatic", "1", "2019-08-08 03:09:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("202", "0", "Yoast SEO (es_ES)", "translation", "11.8", "11.8", "automatic", "1", "2019-08-08 03:09:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("203", "0", "Smush (es_ES)", "translation", "3.2.4", "3.2.4", "automatic", "1", "2019-08-08 20:20:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("204", "0", "EWWW Image Optimizer", "plugin", "4.8.1", "4.9.0", "automatic", "1", "2019-08-14 19:09:16", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("205", "0", "GDPR Cookie Consent", "plugin", "1.7.8", "1.7.9", "automatic", "1", "2019-08-14 19:09:16", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("206", "0", "EWWW Image Optimizer", "plugin", "4.8.1", "4.9.1", "automatic", "1", "2019-08-14 22:05:02", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("207", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.9.1", "4.9.1", "automatic", "1", "2019-08-14 22:05:02", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("208", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.9.1", "4.9.1", "automatic", "1", "2019-08-15 11:33:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("209", "0", "iThemes Security", "plugin", "7.4.0", "7.4.1", "automatic", "1", "2019-08-16 12:14:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("210", "0", "iThemes Security (es_ES)", "translation", "7.4.1", "7.4.1", "automatic", "1", "2019-08-16 12:14:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("211", "0", "Yoast SEO", "plugin", "11.8", "11.9", "automatic", "1", "2019-08-20 13:34:29", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("212", "0", "Yoast SEO (es_ES)", "translation", "11.9", "11.9", "automatic", "1", "2019-08-20 13:34:29", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("213", "0", "Admin Custom Login", "plugin", "2.9.4", "2.9.5", "automatic", "1", "2019-08-20 21:15:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("214", "0", "EWWW Image Optimizer", "plugin", "4.9.1", "4.9.2", "automatic", "1", "2019-08-20 21:15:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("215", "0", "Yoast SEO (es_ES)", "translation", "11.9", "11.9", "automatic", "1", "2019-08-20 21:15:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("216", "0", "GDPR Cookie Consent", "plugin", "1.7.9", "1.8.0", "automatic", "1", "2019-08-27 23:35:29", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("217", "0", "Duplicator", "plugin", "1.3.18", "1.3.20", "automatic", "1", "2019-09-01 22:33:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("218", "0", "Duplicator (es_ES)", "translation", "1.3.20", "1.3.20", "automatic", "1", "2019-09-01 22:33:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("219", "0", "Yoast SEO", "plugin", "11.9", "12.0", "automatic", "1", "2019-09-03 16:20:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("220", "0", "Duplicator (es_ES)", "translation", "1.3.20", "1.3.20", "automatic", "1", "2019-09-03 16:20:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("221", "0", "Yoast SEO (es_ES)", "translation", "12.0", "12.0", "automatic", "1", "2019-09-03 16:20:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("222", "0", "WordPress 5.1.2", "core", "5.1.1", "5.2.3", "automatic", "1", "2019-09-05 10:07:16", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("223", "0", "Admin Custom Login", "plugin", "2.9.5", "2.9.6", "automatic", "1", "2019-09-06 23:15:33", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("224", "0", "W3 Total Cache", "plugin", "0.9.7.5", "0.10.0", "automatic", "1", "2019-09-06 23:15:33", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("225", "0", "EWWW Image Optimizer", "plugin", "4.9.2", "4.9.3", "automatic", "1", "2019-09-10 22:44:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("226", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.7.1", "7.8.0", "automatic", "1", "2019-09-10 22:44:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("227", "0", "EWWW Image Optimizer (es_ES)", "translation", "4.9.3", "4.9.3", "automatic", "1", "2019-09-10 22:44:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("228", "0", "Duplicator", "plugin", "1.3.20", "1.3.22", "automatic", "1", "2019-09-12 13:13:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("229", "0", "W3 Total Cache", "plugin", "0.10.0", "0.10.1", "automatic", "1", "2019-09-12 13:13:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("230", "3", "WordPress 5.2.3", "core", "5.1.2", "5.2.3", "manual", "1", "2019-09-12 13:14:18", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("231", "0", "TinyMCE Advanced", "plugin", "5.1.0", "5.2.1", "automatic", "1", "2019-09-13 07:10:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("232", "0", "WordPress (es_ES)", "translation", "5.2.3", "5.2.3", "automatic", "1", "2019-09-13 07:10:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("233", "0", "TinyMCE Advanced (es_ES)", "translation", "5.2.1", "5.2.1", "automatic", "1", "2019-09-13 07:10:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("234", "0", "WordPress (es_ES)", "translation", "5.2.3", "5.2.3", "automatic", "1", "2019-09-16 00:12:02", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("235", "0", "Yoast SEO", "plugin", "12.0", "12.1", "automatic", "1", "2019-09-17 17:36:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("236", "0", "Yoast SEO (es_ES)", "translation", "12.1", "12.1", "automatic", "1", "2019-09-17 17:36:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("237", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.8.0", "7.8.1", "automatic", "1", "2019-09-18 15:09:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("238", "0", "WordPress (es_ES)", "translation", "5.2.3", "5.2.3", "automatic", "1", "2019-09-18 15:09:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("239", "0", "Contact Form 7 Honeypot", "plugin", "1.14", "1.14.1", "automatic", "1", "2019-09-20 18:33:45", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("240", "0", "Honeypot for Contact Form 7 (es_ES)", "translation", "1.14.1", "1.14.1", "automatic", "1", "2019-09-20 18:33:45", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("241", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.8.1", "7.8.2", "automatic", "1", "2019-09-22 23:57:01", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("242", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.8.2", "7.8.2", "automatic", "1", "2019-09-22 23:57:01", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("243", "0", "WordPress (es_ES)", "translation", "5.2.3", "5.2.3", "automatic", "1", "2019-09-23 22:47:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("244", "0", "Honeypot for Contact Form 7 (es_ES)", "translation", "1.14.1", "1.14.1", "automatic", "1", "2019-09-23 22:47:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("245", "0", "TinyMCE Advanced (es_ES)", "translation", "5.2.1", "5.2.1", "automatic", "1", "2019-09-23 22:47:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("246", "0", "TinyMCE Advanced (es_ES)", "translation", "5.2.1", "5.2.1", "automatic", "1", "2019-09-24 09:34:00", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("247", "0", "TinyMCE Advanced (es_ES)", "translation", "5.2.1", "5.2.1", "automatic", "1", "2019-09-25 07:32:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("248", "0", "Yoast SEO (es_ES)", "translation", "12.1", "12.1", "automatic", "1", "2019-09-25 07:32:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("249", "0", "EWWW Image Optimizer", "plugin", "4.9.3", "5.0.0", "automatic", "1", "2019-09-26 22:02:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("250", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.0.0", "5.0.0", "automatic", "1", "2019-09-26 22:02:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("251", "0", "Duplicator (es_ES)", "translation", "1.3.22", "1.3.22", "automatic", "1", "2019-09-29 02:26:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("252", "0", "Coming Soon Page &amp; Maintenance Mode by SeedProd ", "plugin", "5.0.26", "5.1.0", "automatic", "1", "2019-10-01 21:18:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("253", "0", "Yoast SEO", "plugin", "12.1", "12.2", "automatic", "1", "2019-10-01 21:18:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("254", "0", "WordPress (es_ES)", "translation", "5.2.3", "5.2.3", "automatic", "1", "2019-10-01 21:18:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("255", "0", "Coming Soon Page & Maintenance Mode by SeedProd (es_ES)", "translation", "5.1.0", "5.1.0", "automatic", "1", "2019-10-01 21:18:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("256", "0", "Yoast SEO (es_ES)", "translation", "12.2", "12.2", "automatic", "1", "2019-10-01 21:18:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("257", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.8.2", "7.9.0", "automatic", "1", "2019-10-02 23:21:51", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("258", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.9.0", "7.9.0", "automatic", "1", "2019-10-02 23:21:51", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("259", "0", "WordPress (es_ES)", "translation", "5.2.3", "5.2.3", "automatic", "1", "2019-10-04 11:23:41", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("260", "0", "GDPR Cookie Consent", "plugin", "1.8.0", "1.8.1", "automatic", "1", "2019-10-08 10:23:53", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("261", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.8.1", "1.8.1", "automatic", "1", "2019-10-08 10:23:53", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("262", "0", "Easy Updates Manager", "plugin", "8.0.5", "8.1.0", "automatic", "1", "2019-10-09 02:45:43", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("263", "0", "Easy Updates Manager (es_ES)", "translation", "8.1.0", "8.1.0", "automatic", "1", "2019-10-09 02:45:43", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("264", "0", "Smush (es_ES)", "translation", "3.2.4", "3.2.4", "automatic", "1", "2019-10-10 23:44:25", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("265", "0", "Akismet Anti-Spam (es_ES)", "translation", "4.1.2", "4.1.2", "automatic", "1", "2019-10-11 21:02:31", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("266", "0", "Admin Custom Login", "plugin", "2.9.6", "2.9.7", "automatic", "1", "2019-10-22 21:14:35", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.2.9.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("267", "0", "EWWW Image Optimizer", "plugin", "5.0.0", "5.1.1", "automatic", "1", "2019-10-22 21:14:35", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.1.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("268", "0", "Loco Translate", "plugin", "2.3.0", "2.3.1", "automatic", "1", "2019-10-22 21:14:35", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.3.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("269", "0", "Yoast SEO", "plugin", "12.2", "12.3", "automatic", "1", "2019-10-22 21:14:35", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.12.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("270", "0", "WordPress 5.2.4", "core", "5.2.3", "5.2.4", "automatic", "1", "2019-10-22 21:14:35", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("271", "0", "Coming Soon Page & Maintenance Mode by SeedProd (es_ES)", "translation", "5.1.0", "5.1.0", "automatic", "1", "2019-10-22 21:14:35", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("272", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.1.1", "5.1.1", "automatic", "1", "2019-10-22 21:14:35", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("273", "0", "Loco Translate (es_ES)", "translation", "2.3.1", "2.3.1", "automatic", "1", "2019-10-22 21:14:35", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("274", "0", "Yoast SEO (es_ES)", "translation", "12.3", "12.3", "automatic", "1", "2019-10-22 21:14:35", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("275", "0", "Easy Updates Manager", "plugin", "8.1.0", "8.1.1", "automatic", "1", "2019-10-23 20:05:53", "Actualizando el plugin: Easy Updates Manager\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/stops-core-theme-and-plugin-updates.8.1.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("276", "0", "Smush", "plugin", "3.2.4", "3.3.0", "automatic", "1", "2019-10-23 20:05:53", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.3.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("277", "0", "Smush (es_ES)", "translation", "3.3.0", "3.3.0", "automatic", "1", "2019-10-23 20:05:53", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("278", "0", "Smush", "plugin", "3.3.0", "3.3.1", "automatic", "1", "2019-10-25 10:17:02", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.3.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("279", "0", "Akismet Anti-Spam", "plugin", "4.1.2", "4.1.3", "automatic", "1", "2019-11-01 12:23:55", "Actualizando el plugin: Akismet Anti-Spam\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/akismet.4.1.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("280", "0", "Easy Updates Manager", "plugin", "8.1.1", "8.2.0", "automatic", "1", "2019-11-01 12:23:55", "Actualizando el plugin: Easy Updates Manager\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/stops-core-theme-and-plugin-updates.8.2.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("281", "0", "Yoast SEO", "plugin", "12.3", "12.4", "automatic", "1", "2019-11-01 12:23:55", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.12.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("282", "0", "Akismet Anti-Spam (es_ES)", "translation", "4.1.3", "4.1.3", "automatic", "1", "2019-11-01 12:23:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("283", "0", "Contact Form 7 (es_ES)", "translation", "5.1.4", "5.1.4", "automatic", "1", "2019-11-01 12:23:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("284", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.8.1", "1.8.1", "automatic", "1", "2019-11-01 12:23:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("285", "0", "Yoast SEO (es_ES)", "translation", "12.4", "12.4", "automatic", "1", "2019-11-01 12:23:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("286", "0", "WPFront User Role Editor", "plugin", "2.14.2", "2.14.3", "automatic", "1", "2019-11-03 23:00:12", "Actualizando el plugin: WPFront User Role Editor\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wpfront-user-role-editor.2.14.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("287", "0", "WordPress (es_ES)", "translation", "5.2.4", "5.2.4", "automatic", "1", "2019-11-03 23:00:12", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("288", "0", "Honeypot for Contact Form 7 (es_ES)", "translation", "1.14.1", "1.14.1", "automatic", "1", "2019-11-03 23:00:12", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("289", "0", "Broken Link Checker", "plugin", "1.11.8", "1.11.9", "automatic", "1", "2019-11-06 16:27:37", "Actualizando el plugin: Broken Link Checker\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/broken-link-checker.1.11.9.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("290", "0", "EWWW Image Optimizer", "plugin", "5.1.1", "5.1.2", "automatic", "1", "2019-11-06 16:27:37", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.1.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("291", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.1.2", "5.1.2", "automatic", "1", "2019-11-06 16:27:37", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("292", "0", "Honeypot for Contact Form 7 (es_ES)", "translation", "1.14.1", "1.14.1", "automatic", "1", "2019-11-06 16:27:37", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("293", "0", "Admin Custom Login", "plugin", "2.9.7", "2.9.8", "automatic", "1", "2019-11-08 13:05:43", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.2.9.8.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("294", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.9.0", "7.10.0", "automatic", "1", "2019-11-08 13:05:43", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.10.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("295", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.10.0", "7.10.0", "automatic", "1", "2019-11-08 13:05:43", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("296", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.10.0", "7.10.0", "automatic", "1", "2019-11-10 02:30:39", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("297", "0", "Contact Form 7", "plugin", "5.1.4", "5.1.5", "automatic", "1", "2019-11-13 01:51:34", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.1.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("298", "0", "Contact Form 7 (es_ES)", "translation", "5.1.5", "5.1.5", "automatic", "1", "2019-11-13 01:51:34", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("299", "0", "W3 Total Cache", "plugin", "0.10.1", "0.10.2", "automatic", "1", "2019-11-14 05:06:57", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.10.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("300", "0", "Yoast SEO", "plugin", "12.4", "12.5", "automatic", "1", "2019-11-14 05:06:57", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.12.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("301", "0", "Yoast SEO (es_ES)", "translation", "12.5", "12.5", "automatic", "1", "2019-11-14 05:06:57", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("302", "0", "iThemes Security", "plugin", "7.4.1", "7.5.0", "automatic", "1", "2019-11-15 14:51:54", "Actualizando el plugin: iThemes Security\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/better-wp-security.7.5.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("303", "0", "iThemes Security (es_ES)", "translation", "7.5.0", "7.5.0", "automatic", "1", "2019-11-15 14:51:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("304", "0", "Yoast SEO (es_ES)", "translation", "12.5", "12.5", "automatic", "1", "2019-11-15 14:51:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("305", "0", "Admin Custom Login", "plugin", "2.9.8", "2.9.9", "automatic", "1", "2019-11-16 14:12:09", "Updating plugin: Admin Custom Login\n\r\n\rDownloading update from https://downloads.wordpress.org/plugin/admin-custom-login.2.9.9.zip\n\r\n\rUnpacking the update\n\r\n\rInstalling the latest version\n\r\n\rRemoving the old version of the plugin\n\r\n\rPlugin updated successfully.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("306", "0", "Duplicator", "plugin", "1.3.22", "1.3.24", "automatic", "1", "2019-11-16 14:12:09", "Updating plugin: Duplicator\n\r\n\rDownloading update from https://downloads.wordpress.org/plugin/duplicator.1.3.24.zip\n\r\n\rUnpacking the update\n\r\n\rInstalling the latest version\n\r\n\rRemoving the old version of the plugin\n\r\n\rPlugin updated successfully.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("307", "0", "Smush", "plugin", "3.3.1", "3.3.2", "automatic", "1", "2019-11-18 23:01:39", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.3.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("308", "0", "WordPress (es_ES)", "translation", "5.2.4", "5.2.4", "automatic", "1", "2019-11-18 23:01:39", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("309", "0", "Duplicator (es_ES)", "translation", "1.3.24", "1.3.24", "automatic", "1", "2019-11-18 23:01:39", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("310", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.1.2", "5.1.2", "automatic", "1", "2019-11-18 23:01:39", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("311", "0", "Smush (es_ES)", "translation", "3.3.2", "3.3.2", "automatic", "1", "2019-11-18 23:01:39", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("312", "0", "EWWW Image Optimizer", "plugin", "5.1.2", "5.1.3", "automatic", "1", "2019-11-21 09:23:18", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.1.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("313", "0", "Contact Form 7 (es_ES)", "translation", "5.1.5", "5.1.5", "automatic", "1", "2019-11-21 09:23:18", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("314", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.1.3", "5.1.3", "automatic", "1", "2019-11-21 09:23:18", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("315", "0", "W3 Total Cache", "plugin", "0.10.2", "0.11.0", "automatic", "1", "2019-11-23 16:08:18", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.11.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("316", "0", "Yoast SEO", "plugin", "12.5", "12.5.1", "automatic", "1", "2019-11-23 16:08:18", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.12.5.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("317", "0", "Yoast SEO (es_ES)", "translation", "12.5.1", "12.5.1", "automatic", "1", "2019-11-23 16:08:18", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("318", "0", "GDPR Cookie Consent", "plugin", "1.8.1", "1.8.2", "automatic", "1", "2019-11-25 09:36:31", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.8.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("319", "0", "Contact Form 7", "plugin", "5.1.5", "5.1.6", "automatic", "1", "2019-11-30 21:12:03", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.1.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("320", "0", "Yoast SEO", "plugin", "12.5.1", "12.6.2", "automatic", "1", "2019-11-30 21:12:03", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.12.6.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("321", "0", "Yoast SEO (es_ES)", "translation", "12.6.2", "12.6.2", "automatic", "1", "2019-11-30 21:12:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("322", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.10.0", "7.10.1", "automatic", "1", "2019-12-07 00:56:57", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.10.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("323", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.10.1", "7.10.1", "automatic", "1", "2019-12-08 21:36:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("324", "0", "iThemes Security", "plugin", "7.5.0", "7.6.0", "automatic", "1", "2019-12-10 01:31:17", "Actualizando el plugin: iThemes Security\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/better-wp-security.7.6.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("325", "0", "Duplicate Post", "plugin", "3.2.3", "3.2.4", "automatic", "1", "2019-12-10 20:30:27", "Updating plugin: Duplicate Post\n\r\n\rDownloading update from https://downloads.wordpress.org/plugin/duplicate-post.3.2.4.zip\n\r\n\rUnpacking the update\n\r\n\rInstalling the latest version\n\r\n\rRemoving the old version of the plugin\n\r\n\rPlugin updated successfully.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("326", "0", "iThemes Security", "plugin", "7.6.0", "7.6.1", "automatic", "1", "2019-12-10 20:30:27", "Updating plugin: iThemes Security\n\r\n\rDownloading update from https://downloads.wordpress.org/plugin/better-wp-security.7.6.1.zip\n\r\n\rUnpacking the update\n\r\n\rInstalling the latest version\n\r\n\rRemoving the old version of the plugin\n\r\n\rPlugin updated successfully.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("327", "0", "Yoast SEO", "plugin", "12.6.2", "12.7", "automatic", "1", "2019-12-10 20:30:27", "Updating plugin: Yoast SEO\n\r\n\rDownloading update from https://downloads.wordpress.org/plugin/wordpress-seo.12.7.zip\n\r\n\rUnpacking the update\n\r\n\rInstalling the latest version\n\r\n\rRemoving the old version of the plugin\n\r\n\rPlugin updated successfully.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("328", "0", "iThemes Security (es_ES)", "translation", "7.6.1", "7.6.1", "automatic", "1", "2019-12-10 20:30:27", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("329", "0", "Yoast SEO", "plugin", "12.7", "12.7.1", "automatic", "1", "2019-12-13 08:35:07", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.12.7.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("330", "0", "WordPress 5.2.5", "core", "5.2.4", "5.3.1", "automatic", "1", "2019-12-13 08:35:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("331", "0", "Duplicate Post (es_ES)", "translation", "3.2.4", "3.2.4", "automatic", "1", "2019-12-13 08:35:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("332", "0", "iThemes Security (es_ES)", "translation", "7.6.1", "7.6.1", "automatic", "1", "2019-12-13 08:35:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("333", "0", "Admin Custom Login", "plugin", "2.9.9", "3.0.0", "automatic", "1", "2019-12-19 16:52:37", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.0.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("334", "0", "W3 Total Cache", "plugin", "0.11.0", "0.12.0", "automatic", "1", "2019-12-19 16:52:37", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.12.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("335", "0", "iThemes Security (es_ES)", "translation", "7.6.1", "7.6.1", "automatic", "1", "2019-12-19 16:52:37", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("336", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.10.1", "7.10.2", "automatic", "1", "2019-12-20 08:10:51", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.10.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("337", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.10.2", "7.10.2", "automatic", "1", "2019-12-21 21:54:47", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("338", "0", "Autoptimize", "plugin", "2.5.1", "2.6.0", "automatic", "1", "2019-12-26 14:17:37", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.6.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("339", "0", "Autoptimize (es_ES)", "translation", "2.6.0", "2.6.0", "automatic", "1", "2019-12-26 14:17:37", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("340", "0", "Autoptimize", "plugin", "2.6.0", "2.6.1", "automatic", "1", "2019-12-29 01:08:32", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.6.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("341", "0", "Broken Link Checker", "plugin", "1.11.9", "1.11.10", "automatic", "1", "2020-01-03 20:03:46", "Actualizando el plugin: Broken Link Checker\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/broken-link-checker.1.11.10.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("342", "0", "Contact Form 7 (es_ES)", "translation", "5.1.6", "5.1.6", "automatic", "1", "2020-01-03 20:03:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("343", "0", "EWWW Image Optimizer", "plugin", "5.1.3", "5.1.4", "automatic", "1", "2020-01-07 21:55:01", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.1.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("344", "0", "Yoast SEO", "plugin", "12.7.1", "12.8", "automatic", "1", "2020-01-07 21:55:01", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.12.8.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("345", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.1.4", "5.1.4", "automatic", "1", "2020-01-07 21:55:01", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("346", "0", "Yoast SEO (es_ES)", "translation", "12.8", "12.8", "automatic", "1", "2020-01-07 21:55:01", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("347", "0", "Contact Form 7 (es_ES)", "translation", "5.1.6", "5.1.6", "automatic", "1", "2020-01-09 01:45:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("348", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.1.4", "5.1.4", "automatic", "1", "2020-01-09 01:45:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("349", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.10.2", "7.10.3", "automatic", "1", "2020-01-11 14:54:59", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.10.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("350", "0", "Autoptimize (es_ES)", "translation", "2.6.1", "2.6.1", "automatic", "1", "2020-01-11 14:54:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("351", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.8.2", "1.8.2", "automatic", "1", "2020-01-11 14:54:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("352", "0", "Smush", "plugin", "3.3.2", "3.4.1", "automatic", "1", "2020-01-14 16:23:36", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.4.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("353", "0", "Social Mobile Messaging Bar", "plugin", "1.1.11", "1.2.0", "automatic", "1", "2020-01-14 16:23:36", "Actualizando el plugin: Social Mobile Messaging Bar\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/social-mobile-messaging-bar.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("354", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.10.3", "7.10.3", "automatic", "1", "2020-01-14 16:23:36", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("355", "0", "Smush (es_ES)", "translation", "3.4.1", "3.4.1", "automatic", "1", "2020-01-14 16:23:36", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("356", "0", "Admin Custom Login", "plugin", "3.0.0", "3.1.1", "automatic", "1", "2020-01-16 23:13:07", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.1.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("357", "0", "Easy Updates Manager", "plugin", "8.2.0", "9.0.0", "automatic", "1", "2020-01-16 23:13:07", "Actualizando el plugin: Easy Updates Manager\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/stops-core-theme-and-plugin-updates.9.0.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("358", "0", "Smush", "plugin", "3.4.1", "3.4.2", "automatic", "1", "2020-01-16 23:13:07", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.4.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("359", "0", "Yoast SEO", "plugin", "12.8", "12.8.1", "automatic", "1", "2020-01-16 23:13:07", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.12.8.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("360", "0", "Easy Updates Manager (es_ES)", "translation", "9.0.0", "9.0.0", "automatic", "1", "2020-01-16 23:13:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("361", "0", "Smush (es_ES)", "translation", "3.4.2", "3.4.2", "automatic", "1", "2020-01-16 23:13:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("362", "0", "Yoast SEO (es_ES)", "translation", "12.8.1", "12.8.1", "automatic", "1", "2020-01-16 23:13:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("363", "0", "Easy Updates Manager", "plugin", "9.0.0", "9.0.1", "automatic", "1", "2020-01-24 01:10:07", "Actualizando el plugin: Easy Updates Manager\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/stops-core-theme-and-plugin-updates.9.0.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("364", "0", "Yoast SEO", "plugin", "12.8.1", "12.9.1", "automatic", "1", "2020-01-24 01:10:07", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.12.9.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("365", "0", "Yoast SEO (es_ES)", "translation", "12.9.1", "12.9.1", "automatic", "1", "2020-01-24 01:10:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("366", "0", "Admin Custom Login", "plugin", "3.1.1", "3.1.2", "automatic", "1", "2020-01-28 20:54:16", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.1.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("367", "0", "Akismet Anti-Spam (es_ES)", "translation", "4.1.3", "4.1.3", "automatic", "1", "2020-01-28 20:54:16", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("368", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.10.3", "7.10.3", "automatic", "1", "2020-01-28 20:54:16", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("369", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.10.3", "7.10.4", "automatic", "1", "2020-01-29 18:22:59", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.10.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("370", "0", "Admin Custom Login", "plugin", "3.1.2", "3.1.3", "automatic", "1", "2020-01-31 22:58:21", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.1.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("371", "0", "EWWW Image Optimizer", "plugin", "5.1.4", "5.2.0", "automatic", "1", "2020-01-31 22:58:21", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.2.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("372", "0", "W3 Total Cache", "plugin", "0.12.0", "0.13.0", "automatic", "1", "2020-01-31 22:58:21", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.13.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("373", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.2.0", "5.2.0", "automatic", "1", "2020-01-31 22:58:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("374", "0", "Broken Link Checker", "plugin", "1.11.10", "1.11.11", "automatic", "1", "2020-02-06 03:50:07", "Actualizando el plugin: Broken Link Checker\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/broken-link-checker.1.11.11.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("375", "0", "Yoast SEO", "plugin", "12.9.1", "13.0", "automatic", "1", "2020-02-06 03:50:07", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.13.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("376", "0", "Broken Link Checker (es_ES)", "translation", "1.11.11", "1.11.11", "automatic", "1", "2020-02-06 03:50:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("377", "0", "Yoast SEO (es_ES)", "translation", "13.0", "13.0", "automatic", "1", "2020-02-06 03:50:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("378", "0", "EWWW Image Optimizer", "plugin", "5.2.0", "5.2.1", "automatic", "1", "2020-02-08 10:25:49", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.2.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("379", "0", "Duplicator (es_ES)", "translation", "1.3.24", "1.3.24", "automatic", "1", "2020-02-08 10:25:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("380", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.2.1", "5.2.1", "automatic", "1", "2020-02-08 10:25:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("381", "0", "Duplicator", "plugin", "1.3.24", "1.3.26", "automatic", "1", "2020-02-09 18:56:08", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.3.26.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("382", "0", "Duplicator", "plugin", "1.3.26", "1.3.28", "automatic", "1", "2020-02-14 11:50:28", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.3.28.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("383", "0", "GDPR Cookie Consent", "plugin", "1.8.2", "1.8.3", "automatic", "1", "2020-02-14 11:50:28", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.8.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("384", "0", "W3 Total Cache", "plugin", "0.13.0", "0.13.1", "automatic", "1", "2020-02-14 11:50:28", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.13.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("385", "0", "Duplicator (es_ES)", "translation", "1.3.28", "1.3.28", "automatic", "1", "2020-02-14 11:50:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("386", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.8.3", "1.8.3", "automatic", "1", "2020-02-14 11:50:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("387", "0", "Yoast SEO", "plugin", "13.0", "13.1", "automatic", "1", "2020-02-20 01:50:06", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.13.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("388", "0", "WordPress (es_ES)", "translation", "5.2.5", "5.2.5", "automatic", "1", "2020-02-20 01:50:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("389", "0", "Broken Link Checker (es_ES)", "translation", "1.11.11", "1.11.11", "automatic", "1", "2020-02-20 01:50:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("390", "0", "Duplicator (es_ES)", "translation", "1.3.28", "1.3.28", "automatic", "1", "2020-02-20 01:50:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("391", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.2.1", "5.2.1", "automatic", "1", "2020-02-20 01:50:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("392", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.10.4", "7.10.4", "automatic", "1", "2020-02-20 01:50:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("393", "0", "Loco Translate (es_ES)", "translation", "2.3.1", "2.3.1", "automatic", "1", "2020-02-20 01:50:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("394", "0", "W3 Total Cache (es_ES)", "translation", "0.13.1", "0.13.1", "automatic", "1", "2020-02-20 01:50:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("395", "0", "Yoast SEO (es_ES)", "translation", "13.1", "13.1", "automatic", "1", "2020-02-20 01:50:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("396", "0", "Autoptimize", "plugin", "2.6.1", "2.6.2", "automatic", "1", "2020-02-26 20:11:08", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.6.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("397", "0", "GDPR Cookie Consent", "plugin", "1.8.3", "1.8.5", "automatic", "1", "2020-02-26 20:11:08", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.8.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("398", "0", "WordPress (es_ES)", "translation", "5.2.5", "5.2.5", "automatic", "1", "2020-02-26 20:11:08", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("399", "0", "Autoptimize (es_ES)", "translation", "2.6.2", "2.6.2", "automatic", "1", "2020-02-26 20:11:08", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("400", "0", "Duplicator (es_ES)", "translation", "1.3.28", "1.3.28", "automatic", "1", "2020-02-26 20:11:08", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("401", "0", "Easy Updates Manager (es_ES)", "translation", "9.0.1", "9.0.1", "automatic", "1", "2020-02-26 20:11:08", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("402", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.10.4", "7.10.4", "automatic", "1", "2020-02-26 20:11:08", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("403", "0", "W3 Total Cache (es_ES)", "translation", "0.13.1", "0.13.1", "automatic", "1", "2020-02-26 20:11:08", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("404", "0", "EWWW Image Optimizer", "plugin", "5.2.1", "5.2.2", "automatic", "1", "2020-02-27 19:29:19", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.2.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("405", "0", "WordPress (es_ES)", "translation", "5.2.5", "5.2.5", "automatic", "1", "2020-02-27 19:29:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("406", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.10.4", "7.10.4", "automatic", "1", "2020-02-27 19:29:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("407", "0", "Admin Custom Login", "plugin", "3.1.3", "3.1.4", "automatic", "1", "2020-02-28 20:58:44", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.1.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("408", "0", "Yoast SEO", "plugin", "13.1", "13.2", "automatic", "1", "2020-03-04 12:29:30", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.13.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("409", "0", "WordPress (es_ES)", "translation", "5.2.5", "5.2.5", "automatic", "1", "2020-03-04 12:29:30", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("410", "0", "Yoast SEO (es_ES)", "translation", "13.2", "13.2", "automatic", "1", "2020-03-04 12:29:30", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("411", "0", "Contact Form 7", "plugin", "5.1.6", "5.1.7", "automatic", "1", "2020-03-08 09:14:56", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.1.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("412", "0", "Contact Form 7 (es_ES)", "translation", "5.1.7", "5.1.7", "automatic", "1", "2020-03-08 09:14:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("413", "0", "Smush", "plugin", "3.4.2", "3.6.1", "automatic", "1", "2020-03-13 12:28:32", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.6.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("414", "0", "Smush (es_ES)", "translation", "3.6.1", "3.6.1", "automatic", "1", "2020-03-13 12:28:33", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("415", "0", "Admin Custom Login", "plugin", "3.1.4", "3.1.5", "automatic", "1", "2020-03-16 17:50:29", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.1.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("416", "0", "Yoast SEO", "plugin", "13.2", "13.3", "automatic", "1", "2020-03-17 10:34:47", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.13.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("417", "0", "Akismet Anti-Spam", "plugin", "4.1.3", "4.1.4", "automatic", "1", "2020-03-18 00:56:48", "Actualizando el plugin: Akismet Anti-Spam\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/akismet.4.1.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("418", "0", "Akismet Anti-Spam (es_ES)", "translation", "4.1.4", "4.1.4", "automatic", "1", "2020-03-18 00:56:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("419", "0", "Broken Link Checker", "plugin", "1.11.11", "1.11.12", "automatic", "1", "2020-03-24 03:18:13", "Actualizando el plugin: Broken Link Checker\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/broken-link-checker.1.11.12.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("420", "0", "Broken Link Checker (es_ES)", "translation", "1.11.12", "1.11.12", "automatic", "1", "2020-03-24 03:18:13", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("421", "0", "EWWW Image Optimizer", "plugin", "5.2.2", "5.2.3", "automatic", "1", "2020-03-26 13:15:58", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.2.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("422", "0", "GDPR Cookie Consent", "plugin", "1.8.5", "1.8.6", "automatic", "1", "2020-03-26 13:15:58", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.8.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("423", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.2.3", "5.2.3", "automatic", "1", "2020-03-26 13:15:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("424", "0", "Contact Form 7 (es_ES)", "translation", "5.1.7", "5.1.7", "automatic", "1", "2020-03-30 10:18:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("425", "0", "EWWW Image Optimizer", "plugin", "5.2.3", "5.2.4", "automatic", "1", "2020-03-31 20:29:42", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.2.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("426", "0", "Yoast SEO", "plugin", "13.3", "13.4", "automatic", "1", "2020-03-31 20:29:42", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.13.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("427", "0", "Contact Form 7 (es_ES)", "translation", "5.1.7", "5.1.7", "automatic", "1", "2020-03-31 20:29:42", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("428", "3", "WordPress 5.4", "core", "5.2.5", "5.4", "manual", "1", "2020-04-01 10:19:13", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("429", "3", "WP Downgrade | Specific Core Version (es_ES)", "translation", "1.2.0", "1.2.0", "manual", "1", "2020-04-01 11:29:26", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("430", "3", "WordPress 5.4", "core", "5.3.2", "5.4", "manual", "1", "2020-04-01 11:30:12", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("431", "3", "WordPress (es_ES)", "translation", "5.4", "5.4", "manual", "1", "2020-04-01 11:30:17", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("432", "3", "Akismet Anti-Spam (es_ES)", "translation", "4.1.4", "4.1.4", "manual", "1", "2020-04-01 11:30:17", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("433", "3", "Twenty Twenty (es_ES)", "translation", "1.2", "1.2", "manual", "1", "2020-04-01 11:30:17", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("434", "0", "EWWW Image Optimizer", "plugin", "5.2.4", "5.2.5", "automatic", "1", "2020-04-01 21:29:38", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.2.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("435", "0", "GDPR Cookie Consent", "plugin", "1.8.6", "1.8.7", "automatic", "1", "2020-04-01 21:29:38", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.8.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("436", "0", "Loco Translate", "plugin", "2.3.1", "2.3.2", "automatic", "1", "2020-04-01 21:29:38", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.3.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("437", "0", "Yoast SEO", "plugin", "13.4", "13.4.1", "automatic", "1", "2020-04-01 21:29:38", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.13.4.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("438", "0", "Loco Translate (es_ES)", "translation", "2.3.2", "2.3.2", "automatic", "1", "2020-04-04 08:54:53", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("439", "0", "Broken Link Checker (es_ES)", "translation", "1.11.12", "1.11.12", "automatic", "1", "2020-04-06 08:08:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("440", "0", "Broken Link Checker (es_ES)", "translation", "1.11.12", "1.11.12", "automatic", "1", "2020-04-06 22:07:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("441", "0", "W3 Total Cache", "plugin", "0.13.1", "0.13.2", "automatic", "1", "2020-04-08 21:57:11", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.13.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("442", "0", "Loco Translate", "plugin", "2.3.2", "2.3.3", "automatic", "1", "2020-04-09 21:04:24", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.3.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("443", "0", "Akismet Anti-Spam (es_ES)", "translation", "4.1.4", "4.1.4", "automatic", "1", "2020-04-14 08:52:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("444", "0", "Yoast SEO (es_ES)", "translation", "13.4.1", "13.4.1", "automatic", "1", "2020-04-14 08:52:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("445", "0", "Easy Updates Manager", "plugin", "9.0.1", "9.0.3", "automatic", "1", "2020-04-15 03:16:49", "Actualizando el plugin: Easy Updates Manager\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/stops-core-theme-and-plugin-updates.9.0.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("446", "0", "Yoast SEO", "plugin", "13.4.1", "13.5", "automatic", "1", "2020-04-15 03:16:49", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.13.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("447", "0", "Akismet Anti-Spam (es_ES)", "translation", "4.1.4", "4.1.4", "automatic", "1", "2020-04-15 03:16:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("448", "0", "Autoptimize (es_ES)", "translation", "2.6.2", "2.6.2", "automatic", "1", "2020-04-15 03:16:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("449", "0", "Coming Soon Page & Maintenance Mode by SeedProd (es_ES)", "translation", "5.1.0", "5.1.0", "automatic", "1", "2020-04-15 03:16:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("450", "0", "Contact Form 7 (es_ES)", "translation", "5.1.7", "5.1.7", "automatic", "1", "2020-04-15 03:16:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("451", "0", "Easy Updates Manager (es_ES)", "translation", "9.0.3", "9.0.3", "automatic", "1", "2020-04-15 03:16:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("452", "0", "iThemes Security (es_ES)", "translation", "7.6.1", "7.6.1", "automatic", "1", "2020-04-15 03:16:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("453", "0", "iThemes Security", "plugin", "7.6.1", "7.7.0", "automatic", "1", "2020-04-15 23:41:00", "Actualizando el plugin: iThemes Security\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/better-wp-security.7.7.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("454", "0", "iThemes Security (es_ES)", "translation", "7.7.0", "7.7.0", "automatic", "1", "2020-04-17 06:36:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("455", "0", "Smush (es_ES)", "translation", "3.6.1", "3.6.1", "automatic", "1", "2020-04-17 13:32:34", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("456", "0", "Duplicator", "plugin", "1.3.28", "1.3.30", "automatic", "1", "2020-04-21 01:56:38", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.3.30.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("457", "0", "iThemes Security", "plugin", "7.7.0", "7.7.1", "automatic", "1", "2020-04-21 01:56:38", "Actualizando el plugin: iThemes Security\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/better-wp-security.7.7.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("458", "0", "Duplicator (es_ES)", "translation", "1.3.30", "1.3.30", "automatic", "1", "2020-04-21 01:56:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("459", "0", "iThemes Security (es_ES)", "translation", "7.7.1", "7.7.1", "automatic", "1", "2020-04-21 01:56:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("460", "0", "Autoptimize (es_ES)", "translation", "2.6.2", "2.6.2", "automatic", "1", "2020-04-26 14:36:25", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("461", "0", "Contact Form 7 (es_ES)", "translation", "5.1.7", "5.1.7", "automatic", "1", "2020-04-26 14:36:25", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("462", "0", "Duplicate Post (es_ES)", "translation", "3.2.4", "3.2.4", "automatic", "1", "2020-04-26 14:36:25", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("463", "0", "Yoast SEO", "plugin", "13.5", "14.0", "automatic", "1", "2020-04-28 11:45:46", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("464", "0", "Yoast SEO (es_ES)", "translation", "14.0", "14.0", "automatic", "1", "2020-04-28 11:45:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("465", "0", "W3 Total Cache", "plugin", "0.13.2", "0.13.3", "automatic", "1", "2020-04-29 08:54:27", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.13.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("466", "0", "Yoast SEO", "plugin", "14.0", "14.0.1", "automatic", "1", "2020-04-29 08:54:27", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.0.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("467", "0", "Yoast SEO (es_ES)", "translation", "14.0.1", "14.0.1", "automatic", "1", "2020-04-29 08:54:27", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("468", "0", "Akismet Anti-Spam", "plugin", "4.1.4", "4.1.5", "automatic", "1", "2020-04-29 23:36:53", "Actualizando el plugin: Akismet Anti-Spam\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/akismet.4.1.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("469", "0", "EWWW Image Optimizer", "plugin", "5.2.5", "5.3.0", "automatic", "1", "2020-04-29 23:36:53", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.3.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("470", "0", "Yoast SEO", "plugin", "14.0.1", "14.0.2", "automatic", "1", "2020-04-29 23:36:53", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.0.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("471", "0", "Yoast SEO (es_ES)", "translation", "14.0.2", "14.0.2", "automatic", "1", "2020-04-29 23:36:53", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("472", "0", "Yoast SEO", "plugin", "14.0.2", "14.0.3", "automatic", "1", "2020-04-30 16:12:57", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.0.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("473", "0", "Yoast SEO (es_ES)", "translation", "14.0.3", "14.0.3", "automatic", "1", "2020-04-30 16:12:57", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("474", "0", "Yoast SEO", "plugin", "14.0.3", "14.0.4", "automatic", "1", "2020-05-01 01:59:57", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.0.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("475", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.3.0", "5.3.0", "automatic", "1", "2020-05-01 01:59:57", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("476", "0", "Autoptimize", "plugin", "2.6.2", "2.7.0", "automatic", "1", "2020-05-02 08:02:09", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.7.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("477", "0", "Autoptimize (es_ES)", "translation", "2.7.0", "2.7.0", "automatic", "1", "2020-05-02 08:02:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("478", "0", "Autoptimize (es_ES)", "translation", "2.7.0", "2.7.0", "automatic", "1", "2020-05-04 00:12:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("479", "0", "iThemes Security (es_ES)", "translation", "7.7.1", "7.7.1", "automatic", "1", "2020-05-04 00:12:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("480", "0", "Twenty Twenty (es_ES)", "translation", "1.2", "1.2", "automatic", "1", "2020-05-04 00:12:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("481", "0", "Duplicator", "plugin", "1.3.30", "1.3.32", "automatic", "1", "2020-05-05 18:30:39", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.3.32.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("482", "0", "EWWW Image Optimizer", "plugin", "5.3.0", "5.3.1", "automatic", "1", "2020-05-06 12:52:09", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.3.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("483", "0", "Autoptimize", "plugin", "2.7.0", "2.7.1", "automatic", "1", "2020-05-07 18:25:53", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.7.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("484", "0", "Duplicator (es_ES)", "translation", "1.3.32", "1.3.32", "automatic", "1", "2020-05-11 06:53:02", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("485", "0", "GDPR Cookie Consent", "plugin", "1.8.7", "1.8.8", "automatic", "1", "2020-05-12 03:39:30", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.8.8.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("486", "0", "Yoast SEO", "plugin", "14.0.4", "14.1", "automatic", "1", "2020-05-13 15:21:24", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("487", "0", "Loco Translate (es_ES)", "translation", "2.3.3", "2.3.3", "automatic", "1", "2020-05-13 15:21:24", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("488", "0", "Yoast SEO (es_ES)", "translation", "14.1", "14.1", "automatic", "1", "2020-05-13 15:21:24", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("489", "0", "Contact Form 7", "plugin", "5.1.7", "5.1.8", "automatic", "1", "2020-05-14 21:14:30", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.1.8.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("490", "0", "EWWW Image Optimizer", "plugin", "5.3.1", "5.3.2", "automatic", "1", "2020-05-14 21:14:30", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.3.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("491", "0", "Loco Translate", "plugin", "2.3.3", "2.3.4", "automatic", "1", "2020-05-15 10:25:16", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.3.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("492", "0", "Loco Translate (es_ES)", "translation", "2.3.4", "2.3.4", "automatic", "1", "2020-05-15 10:25:16", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("493", "0", "Duplicator", "plugin", "1.3.32", "1.3.34", "automatic", "1", "2020-05-16 23:15:54", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.3.34.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("494", "0", "Smush", "plugin", "3.6.1", "3.6.3", "automatic", "1", "2020-05-18 18:37:50", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.6.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("495", "0", "Smush (es_ES)", "translation", "3.6.3", "3.6.3", "automatic", "1", "2020-05-18 18:37:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("496", "0", "Contact Form 7", "plugin", "5.1.8", "5.1.9", "automatic", "1", "2020-05-20 16:32:01", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.1.9.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("497", "0", "Autoptimize", "plugin", "2.7.1", "2.7.2", "automatic", "1", "2020-05-22 10:12:44", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.7.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("498", "0", "Autoptimize (es_ES)", "translation", "2.7.2", "2.7.2", "automatic", "1", "2020-05-22 10:12:44", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("499", "0", "Broken Link Checker", "plugin", "1.11.12", "1.11.13", "automatic", "1", "2020-05-27 09:05:33", "Actualizando el plugin: Broken Link Checker\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/broken-link-checker.1.11.13.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("500", "0", "Loco Translate", "plugin", "2.3.4", "2.4.0", "automatic", "1", "2020-05-27 09:05:33", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.4.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("501", "0", "Yoast SEO", "plugin", "14.1", "14.2", "automatic", "1", "2020-05-27 09:05:33", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("502", "0", "Broken Link Checker (es_ES)", "translation", "1.11.13", "1.11.13", "automatic", "1", "2020-05-27 09:05:33", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("503", "0", "Loco Translate (es_ES)", "translation", "2.4.0", "2.4.0", "automatic", "1", "2020-05-27 09:05:33", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("504", "0", "Admin Custom Login", "plugin", "3.1.5", "3.1.6", "automatic", "1", "2020-05-30 04:16:32", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.1.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("505", "0", "W3 Total Cache", "plugin", "0.13.3", "0.14.1", "automatic", "1", "2020-05-30 04:16:32", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.14.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("506", "0", "Akismet Anti-Spam", "plugin", "4.1.5", "4.1.6", "automatic", "1", "2020-06-04 20:55:02", "Actualizando el plugin: Akismet Anti-Spam\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/akismet.4.1.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("507", "0", "Akismet Anti-Spam (es_ES)", "translation", "4.1.6", "4.1.6", "automatic", "1", "2020-06-04 20:55:02", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("508", "0", "Akismet Anti-Spam (es_ES)", "translation", "4.1.6", "4.1.6", "automatic", "1", "2020-06-05 20:51:05", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("509", "0", "Yoast SEO", "plugin", "14.2", "14.3", "automatic", "1", "2020-06-09 17:09:20", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("510", "0", "Yoast SEO (es_ES)", "translation", "14.3", "14.3", "automatic", "1", "2020-06-09 17:09:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("511", "0", "EWWW Image Optimizer", "plugin", "5.3.2", "5.4.0", "automatic", "1", "2020-06-10 04:46:56", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.4.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("512", "0", "Autoptimize", "plugin", "2.7.2", "2.7.3", "automatic", "1", "2020-06-10 13:55:15", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.7.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("513", "0", "Autoptimize (es_ES)", "translation", "2.7.3", "2.7.3", "automatic", "1", "2020-06-10 13:55:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("514", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.4.0", "5.4.0", "automatic", "1", "2020-06-10 13:55:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("515", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.4.0", "5.4.0", "automatic", "1", "2020-06-10 22:00:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("516", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.4.0", "5.4.0", "automatic", "1", "2020-06-13 15:13:18", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("517", "0", "Loco Translate (es_ES)", "translation", "2.4.0", "2.4.0", "automatic", "1", "2020-06-15 03:30:36", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("518", "0", "EWWW Image Optimizer", "plugin", "5.4.0", "5.4.1", "automatic", "1", "2020-06-17 07:25:14", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.4.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("519", "0", "W3 Total Cache", "plugin", "0.14.1", "0.14.2", "automatic", "1", "2020-06-19 18:51:27", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.14.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("520", "0", "Yoast SEO (es_ES)", "translation", "14.3", "14.3", "automatic", "1", "2020-06-22 13:59:26", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("521", "0", "Duplicator", "plugin", "1.3.34", "1.3.36", "automatic", "1", "2020-06-23 03:14:15", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.3.36.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("522", "0", "Duplicator (es_ES)", "translation", "1.3.36", "1.3.36", "automatic", "1", "2020-06-23 03:14:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("523", "0", "Yoast SEO", "plugin", "14.3", "14.4", "automatic", "1", "2020-06-23 12:54:17", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("524", "0", "Yoast SEO (es_ES)", "translation", "14.4", "14.4", "automatic", "1", "2020-06-23 12:54:17", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("525", "0", "Yoast SEO", "plugin", "14.4", "14.4.1", "automatic", "1", "2020-06-24 07:50:10", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.4.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("526", "0", "Duplicator (es_ES)", "translation", "1.3.36", "1.3.36", "automatic", "1", "2020-06-24 07:50:10", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("527", "0", "Yoast SEO (es_ES)", "translation", "14.4.1", "14.4.1", "automatic", "1", "2020-06-24 07:50:10", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("528", "0", "Coming Soon Page &amp; Maintenance Mode by SeedProd ", "plugin", "5.1.0", "5.1.2", "automatic", "1", "2020-06-26 05:48:05", "Actualizando el plugin: Coming Soon Page &amp; Maintenance Mode by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.5.1.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("529", "0", "WPFront User Role Editor", "plugin", "2.14.3", "2.14.4", "automatic", "1", "2020-06-26 05:48:05", "Actualizando el plugin: WPFront User Role Editor\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wpfront-user-role-editor.2.14.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("530", "0", "EWWW Image Optimizer", "plugin", "5.4.1", "5.5.0", "automatic", "1", "2020-07-01 07:58:51", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.5.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("531", "0", "Yoast SEO (es_ES)", "translation", "14.4.1", "14.4.1", "automatic", "1", "2020-07-01 07:58:51", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("532", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.10.4", "7.11.0", "automatic", "1", "2020-07-03 00:34:31", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.11.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("533", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.5.0", "5.5.0", "automatic", "1", "2020-07-03 00:34:31", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("534", "0", "Contact Form 7", "plugin", "5.1.9", "5.2", "automatic", "1", "2020-07-04 21:19:00", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("535", "0", "Contact Form 7 (es_ES)", "translation", "5.2", "5.2", "automatic", "1", "2020-07-04 21:19:00", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("536", "0", "Contact Form 7 (es_ES)", "translation", "5.2", "5.2", "automatic", "1", "2020-07-05 22:47:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("537", "0", "Duplicate Post", "plugin", "3.2.4", "3.2.5", "automatic", "1", "2020-07-08 06:09:45", "Actualizando el plugin: Duplicate Post\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicate-post.3.2.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("538", "0", "Yoast Duplicate Post (es_ES)", "translation", "3.2.5", "3.2.5", "automatic", "1", "2020-07-08 06:09:45", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("539", "0", "Yoast SEO", "plugin", "14.4.1", "14.5", "automatic", "1", "2020-07-08 17:18:49", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("540", "0", "Yoast Duplicate Post (es_ES)", "translation", "3.2.5", "3.2.5", "automatic", "1", "2020-07-08 17:18:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("541", "0", "Yoast SEO (es_ES)", "translation", "14.5", "14.5", "automatic", "1", "2020-07-08 17:18:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("542", "0", "Admin Custom Login", "plugin", "3.1.6", "3.1.7", "automatic", "1", "2020-07-16 15:19:12", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.1.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("543", "0", "EWWW Image Optimizer", "plugin", "5.5.0", "5.6.0", "automatic", "1", "2020-07-16 15:19:13", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.6.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("544", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.6.0", "5.6.0", "automatic", "1", "2020-07-16 15:19:13", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("545", "0", "Coming Soon Page, Under Construction &amp; Maintenance Mode by SeedProd", "plugin", "0.00", "5.1.3", "automatic", "1", "2020-07-16 21:04:30", "Actualizando el plugin: Coming Soon Page, Under Construction &amp; Maintenance Mode by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.5.1.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("546", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.11.0", "7.11.0", "automatic", "1", "2020-07-19 19:44:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("547", "0", "Autoptimize", "plugin", "2.7.3", "2.7.5", "automatic", "1", "2020-07-21 07:44:51", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.7.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("548", "0", "Autoptimize (es_ES)", "translation", "2.7.4", "2.7.4", "automatic", "1", "2020-07-21 07:44:51", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("549", "0", "Yoast SEO", "plugin", "0.00", "14.6", "automatic", "1", "2020-07-21 13:06:36", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("550", "0", "Yoast SEO (es_ES)", "translation", "14.6", "14.6", "automatic", "1", "2020-07-21 13:06:36", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("551", "0", "W3 Total Cache", "plugin", "0.14.2", "0.14.3", "automatic", "1", "2020-07-22 01:07:02", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.14.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("552", "0", "Yoast SEO", "plugin", "14.6", "14.6.1", "automatic", "1", "2020-07-22 01:07:02", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.6.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("553", "0", "Yoast SEO (es_ES)", "translation", "14.6.1", "14.6.1", "automatic", "1", "2020-07-22 01:07:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("554", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.11.0", "7.11.0", "automatic", "1", "2020-07-24 18:42:45", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("555", "0", "GDPR Cookie Consent", "plugin", "1.8.8", "1.8.9", "automatic", "1", "2020-07-28 10:51:26", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.8.9.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("556", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.8.9", "1.8.9", "automatic", "1", "2020-07-28 10:51:26", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("557", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.11.0", "7.11.0", "automatic", "1", "2020-07-28 10:51:26", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("558", "0", "Autoptimize", "plugin", "2.7.5", "2.7.6", "automatic", "1", "2020-07-29 00:24:42", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.7.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("559", "0", "Autoptimize (es_ES)", "translation", "2.7.6", "2.7.6", "automatic", "1", "2020-07-29 00:24:42", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("560", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.11.0", "7.11.0", "automatic", "1", "2020-07-30 05:54:31", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("561", "0", "Broken Link Checker (es_ES)", "translation", "1.11.13", "1.11.13", "automatic", "1", "2020-08-01 05:28:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("562", "0", "EWWW Image Optimizer", "plugin", "5.6.0", "5.6.1", "automatic", "1", "2020-08-05 04:43:17", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.6.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("563", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.6.1", "5.6.1", "automatic", "1", "2020-08-05 04:43:17", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("564", "0", "Contact Form 7", "plugin", "5.2", "5.2.1", "automatic", "1", "2020-08-05 23:15:21", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.2.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("565", "0", "EWWW Image Optimizer", "plugin", "5.6.1", "5.6.2", "automatic", "1", "2020-08-05 23:15:21", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.6.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("566", "0", "Loco Translate", "plugin", "2.4.0", "2.4.1", "automatic", "1", "2020-08-05 23:15:21", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.4.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("567", "0", "Yoast SEO", "plugin", "14.6.1", "14.7", "automatic", "1", "2020-08-05 23:15:21", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.14.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("568", "0", "Loco Translate (es_ES)", "translation", "2.4.1", "2.4.1", "automatic", "1", "2020-08-05 23:15:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("569", "0", "Yoast SEO (es_ES)", "translation", "14.7", "14.7", "automatic", "1", "2020-08-05 23:15:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("570", "0", "Contact Form 7 (es_ES)", "translation", "5.2.1", "5.2.1", "automatic", "1", "2020-08-06 13:06:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("571", "0", "Google Analytics for WordPress by MonsterInsights", "plugin", "7.11.0", "7.12.0", "automatic", "1", "2020-08-07 00:50:36", "Actualizando el plugin: Google Analytics for WordPress by MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.12.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("572", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.12.0", "7.12.0", "automatic", "1", "2020-08-07 00:50:36", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("573", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.12.0", "7.12.0", "automatic", "1", "2020-08-10 11:06:24", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("574", "0", "Easy Updates Manager", "plugin", "9.0.3", "9.0.6", "automatic", "1", "2020-08-11 18:09:46", "Actualizando el plugin: Easy Updates Manager\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/stops-core-theme-and-plugin-updates.9.0.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("575", "0", "Google Analytics for WordPress by MonsterInsights", "plugin", "7.12.0", "7.12.2", "automatic", "1", "2020-08-11 18:09:46", "Actualizando el plugin: Google Analytics for WordPress by MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.12.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("576", "0", "Loco Translate", "plugin", "2.4.1", "2.4.2", "automatic", "1", "2020-08-11 18:09:46", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.4.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("577", "0", "Easy Updates Manager (es_ES)", "translation", "9.0.6", "9.0.6", "automatic", "1", "2020-08-11 18:09:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("578", "0", "Loco Translate (es_ES)", "translation", "2.4.2", "2.4.2", "automatic", "1", "2020-08-11 18:09:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("579", "0", "GDPR Cookie Consent", "plugin", "1.8.9", "1.9.0", "automatic", "1", "2020-08-15 04:47:56", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.9.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("580", "0", "iThemes Security", "plugin", "7.7.1", "7.8.0", "automatic", "1", "2020-08-15 04:47:56", "Actualizando el plugin: iThemes Security\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/better-wp-security.7.8.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("581", "0", "W3 Total Cache", "plugin", "0.14.3", "0.14.4", "automatic", "1", "2020-08-15 04:47:56", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.14.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("582", "0", "iThemes Security (es_ES)", "translation", "7.8.0", "7.8.0", "automatic", "1", "2020-08-15 04:47:56", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("583", "0", "Admin Custom Login", "plugin", "3.1.7", "3.1.8", "automatic", "1", "2020-08-20 01:30:30", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.1.8.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("584", "0", "EWWW Image Optimizer", "plugin", "5.6.2", "5.7.0", "automatic", "1", "2020-08-20 01:30:30", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.7.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("585", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.7.0", "5.7.0", "automatic", "1", "2020-08-20 01:30:30", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("586", "0", "Autoptimize", "plugin", "2.7.6", "2.7.7", "automatic", "1", "2020-08-24 02:10:54", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.7.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("587", "0", "Broken Link Checker", "plugin", "1.11.13", "1.11.14", "automatic", "1", "2020-08-26 15:18:21", "Actualizando el plugin: Broken Link Checker\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/broken-link-checker.1.11.14.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("588", "0", "Contact Form 7", "plugin", "5.2.1", "5.2.2", "automatic", "1", "2020-08-26 15:18:21", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.2.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("589", "0", "Contact Form 7 (es_ES)", "translation", "5.2.2", "5.2.2", "automatic", "1", "2020-08-26 15:18:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("590", "0", "Loco Translate", "plugin", "2.4.2", "2.4.3", "automatic", "1", "2020-08-29 03:19:59", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.4.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("591", "0", "WP Downgrade | Specific Core Version", "plugin", "1.2.1", "1.2.2", "automatic", "1", "2020-09-05 19:17:02", "Actualizando el plugin: WP Downgrade | Specific Core Version\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-downgrade.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("592", "0", "Smush", "plugin", "3.6.3", "3.7.0", "automatic", "1", "2020-09-10 09:03:58", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.7.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("593", "0", "GDPR Cookie Consent", "plugin", "1.9.0", "1.9.1", "automatic", "1", "2020-09-11 07:43:19", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.9.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("594", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.9.1", "1.9.1", "automatic", "1", "2020-09-11 07:43:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("595", "0", "Smush (es_ES)", "translation", "3.7.0", "3.7.0", "automatic", "1", "2020-09-11 07:43:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("596", "0", "EWWW Image Optimizer", "plugin", "5.7.0", "5.7.1", "automatic", "1", "2020-09-16 17:02:25", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.7.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("597", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.7.1", "5.7.1", "automatic", "1", "2020-09-16 17:02:25", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("598", "0", "Yoast Duplicate Post", "plugin", "3.2.5", "3.2.6", "automatic", "1", "2020-09-18 05:12:21", "Actualizando el plugin: Yoast Duplicate Post\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicate-post.3.2.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("599", "0", "Yoast Duplicate Post (es_ES)", "translation", "3.2.6", "3.2.6", "automatic", "1", "2020-09-18 05:12:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("600", "0", "Duplicator", "plugin", "1.3.36", "1.3.38", "automatic", "1", "2020-09-22 12:04:00", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.3.38.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("601", "0", "W3 Total Cache", "plugin", "0.14.4", "0.15.0", "automatic", "1", "2020-09-25 08:43:35", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.15.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("602", "0", "W3 Total Cache (es_ES)", "translation", "0.15.0", "0.15.0", "automatic", "1", "2020-09-25 08:43:35", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("603", "0", "W3 Total Cache (es_ES)", "translation", "0.15.0", "0.15.0", "automatic", "1", "2020-09-25 18:20:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("604", "0", "W3 Total Cache (es_ES)", "translation", "0.15.0", "0.15.0", "automatic", "1", "2020-09-28 05:05:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("605", "0", "Smush", "plugin", "3.7.0", "3.7.1", "automatic", "1", "2020-09-29 16:18:58", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.7.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("606", "0", "Smush (es_ES)", "translation", "3.7.1", "3.7.1", "automatic", "1", "2020-09-29 16:18:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("607", "0", "Google Analytics for WordPress by MonsterInsights", "plugin", "7.12.2", "7.12.3", "automatic", "1", "2020-09-30 03:09:14", "Actualizando el plugin: Google Analytics for WordPress by MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.12.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("608", "0", "Admin Custom Login", "plugin", "3.1.8", "3.1.9", "automatic", "1", "2020-10-03 06:00:27", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.1.9.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("609", "0", "W3 Total Cache", "plugin", "0.15.0", "0.15.1", "automatic", "1", "2020-10-03 06:00:27", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.15.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("610", "0", "W3 Total Cache (es_ES)", "translation", "0.15.1", "0.15.1", "automatic", "1", "2020-10-03 17:41:08", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("611", "0", "Autoptimize", "plugin", "2.7.7", "2.7.8", "automatic", "1", "2020-10-09 07:06:16", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.7.8.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("612", "0", "Autoptimize (es_ES)", "translation", "2.7.8", "2.7.8", "automatic", "1", "2020-10-09 11:08:26", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("613", "0", "W3 Total Cache (es_ES)", "translation", "0.15.1", "0.15.1", "automatic", "1", "2020-10-11 03:52:34", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("614", "0", "W3 Total Cache (es_ES)", "translation", "0.15.1", "0.15.1", "automatic", "1", "2020-10-11 18:13:02", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("615", "0", "Admin Custom Login", "plugin", "3.1.9", "3.2.0", "automatic", "1", "2020-10-13 09:02:22", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.2.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("616", "0", "W3 Total Cache (es_ES)", "translation", "0.15.1", "0.15.1", "automatic", "1", "2020-10-15 08:01:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("617", "0", "W3 Total Cache (es_ES)", "translation", "0.15.1", "0.15.1", "automatic", "1", "2020-10-17 04:30:30", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("618", "0", "W3 Total Cache (es_ES)", "translation", "0.15.1", "0.15.1", "automatic", "1", "2020-10-18 02:21:00", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("619", "0", "Coming Soon Page, Under Construction &amp; Maintenance Mode by SeedProd", "plugin", "5.1.3", "6.0.7", "automatic", "1", "2020-10-20 12:07:19", "Actualizando el plugin: Coming Soon Page, Under Construction &amp; Maintenance Mode by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.0.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("620", "0", "Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd (es_ES)", "translation", "6.0.7", "6.0.7", "automatic", "1", "2020-10-20 12:07:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("621", "0", "W3 Total Cache (es_ES)", "translation", "0.15.1", "0.15.1", "automatic", "1", "2020-10-20 12:07:19", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("622", "0", "EWWW Image Optimizer", "plugin", "5.7.1", "5.8.0", "automatic", "1", "2020-10-21 06:12:38", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.8.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("623", "0", "Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd (es_ES)", "translation", "6.0.7", "6.0.7", "automatic", "1", "2020-10-21 06:12:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("624", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.8.0", "5.8.0", "automatic", "1", "2020-10-21 06:12:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("625", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.8.0", "5.8.0", "automatic", "1", "2020-10-21 13:02:08", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("626", "0", "W3 Total Cache (es_ES)", "translation", "0.15.1", "0.15.1", "automatic", "1", "2020-10-21 13:02:08", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("627", "0", "GDPR Cookie Consent", "plugin", "1.9.1", "1.9.3", "automatic", "1", "2020-10-22 06:22:57", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.9.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("628", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.9.2", "1.9.2", "automatic", "1", "2020-10-22 06:22:57", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("629", "0", "Akismet Anti-Spam", "plugin", "4.1.6", "4.1.7", "automatic", "1", "2020-10-24 13:44:54", "Actualizando el plugin: Akismet Anti-Spam\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/akismet.4.1.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("630", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.0.7", "6.0.8.3", "automatic", "1", "2020-10-24 13:44:54", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.0.8.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("631", "0", "Akismet Anti-Spam (es_ES)", "translation", "4.1.7", "4.1.7", "automatic", "1", "2020-10-24 13:44:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("632", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.9.3", "1.9.3", "automatic", "1", "2020-10-24 13:44:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("633", "0", "Loco Translate", "plugin", "2.4.3", "2.4.4", "automatic", "1", "2020-10-30 02:26:40", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.4.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("634", "0", "Loco Translate (es_ES)", "translation", "2.4.4", "2.4.4", "automatic", "1", "2020-10-30 02:26:40", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("635", "0", "Admin Custom Login", "plugin", "3.2.0", "3.2.1", "automatic", "1", "2020-10-31 21:26:50", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.2.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("636", "0", "EWWW Image Optimizer", "plugin", "5.8.0", "5.8.1", "automatic", "1", "2020-10-31 21:26:50", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.8.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("637", "0", "Admin Custom Login", "plugin", "3.2.1", "3.2.2", "automatic", "1", "2020-11-05 07:12:03", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.2.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("638", "0", "Broken Link Checker", "plugin", "1.11.14", "1.11.15", "automatic", "1", "2020-11-05 07:12:03", "Actualizando el plugin: Broken Link Checker\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/broken-link-checker.1.11.15.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("639", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.0.8.3", "6.0.8.4", "automatic", "1", "2020-11-05 07:12:03", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.0.8.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("640", "0", "Broken Link Checker (es_ES)", "translation", "1.11.15", "1.11.15", "automatic", "1", "2020-11-05 07:12:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("641", "0", "Google Analytics for WordPress by MonsterInsights", "plugin", "7.12.3", "7.13.0", "automatic", "1", "2020-11-06 09:26:10", "Actualizando el plugin: Google Analytics for WordPress by MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.13.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("642", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.0.8.4", "6.0.8.5", "automatic", "1", "2020-11-06 22:14:13", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.0.8.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("643", "0", "Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd (es_ES)", "translation", "6.0.8.5", "6.0.8.5", "automatic", "1", "2020-11-06 22:14:13", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("644", "0", "Smush", "plugin", "3.7.1", "3.7.2", "automatic", "1", "2020-11-12 17:44:02", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.7.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("645", "0", "W3 Total Cache", "plugin", "0.15.1", "0.15.2", "automatic", "1", "2020-11-12 17:44:02", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.0.15.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("646", "0", "Loco Translate (es_ES)", "translation", "2.4.4", "2.4.4", "automatic", "1", "2020-11-12 17:44:02", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("647", "0", "Smush (es_ES)", "translation", "3.7.2", "3.7.2", "automatic", "1", "2020-11-12 17:44:02", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("648", "0", "EWWW Image Optimizer", "plugin", "5.8.1", "5.8.2", "automatic", "1", "2020-11-13 21:57:09", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.5.8.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("649", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.0.8.5", "6.0.9.0", "automatic", "1", "2020-11-16 22:30:01", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.0.9.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("650", "0", "Duplicator", "plugin", "1.3.38", "1.3.40", "automatic", "1", "2020-11-16 22:30:01", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.3.40.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("651", "0", "GDPR Cookie Consent", "plugin", "1.9.3", "1.9.4", "automatic", "1", "2020-11-17 10:59:17", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.9.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("652", "0", "EWWW Image Optimizer (es_ES)", "translation", "5.8.2", "5.8.2", "automatic", "1", "2020-11-18 18:49:51", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("653", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.9.4", "1.9.4", "automatic", "1", "2020-11-18 18:49:51", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("654", "0", "Smush (es_ES)", "translation", "3.7.2", "3.7.2", "automatic", "1", "2020-11-18 23:27:02", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("655", "0", "Loco Translate", "plugin", "2.4.4", "2.4.5", "automatic", "1", "2020-11-20 13:56:09", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.4.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("656", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.13.0", "7.13.0", "automatic", "1", "2020-11-20 13:56:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("657", "0", "Loco Translate (es_ES)", "translation", "2.4.5", "2.4.5", "automatic", "1", "2020-11-20 13:56:09", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("658", "0", "Admin Custom Login", "plugin", "3.2.2", "3.2.3", "automatic", "1", "2020-11-22 21:04:15", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.2.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("659", "0", "Loco Translate", "plugin", "2.4.5", "2.4.6", "automatic", "1", "2020-11-22 21:04:15", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.4.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("660", "0", "Loco Translate (es_ES)", "translation", "2.4.6", "2.4.6", "automatic", "1", "2020-11-22 21:04:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("661", "0", "Smush (es_ES)", "translation", "3.7.2", "3.7.2", "automatic", "1", "2020-11-22 21:04:15", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("662", "0", "Smush", "plugin", "3.7.2", "3.7.3", "automatic", "1", "2020-11-23 15:27:57", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.7.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("663", "0", "Smush (es_ES)", "translation", "3.7.3", "3.7.3", "automatic", "1", "2020-11-23 15:27:57", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("664", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.13.0", "7.13.2", "automatic", "1", "2020-11-26 17:32:12", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.13.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("665", "0", "Admin Custom Login", "plugin", "3.2.3", "3.2.4", "automatic", "1", "2020-11-30 11:59:08", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.2.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("666", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.13.2", "7.13.2", "automatic", "1", "2020-12-03 03:06:13", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("667", "0", "Admin Custom Login", "plugin", "3.2.4", "3.2.5", "automatic", "1", "2020-12-12 06:43:46", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.2.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("668", "0", "Autoptimize", "plugin", "2.7.8", "2.8.0", "automatic", "1", "2020-12-12 06:43:46", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.8.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("669", "0", "GDPR Cookie Consent", "plugin", "1.9.4", "1.9.5", "automatic", "1", "2020-12-12 06:43:46", "Actualizando el plugin: GDPR Cookie Consent\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/cookie-law-info.1.9.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("670", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.13.2", "7.13.3", "automatic", "1", "2020-12-12 06:43:46", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.13.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("671", "0", "Smush", "plugin", "3.7.3", "3.8.2", "automatic", "1", "2020-12-12 06:43:46", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.8.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("672", "0", "Autoptimize (es_ES)", "translation", "2.8.0", "2.8.0", "automatic", "1", "2020-12-12 06:43:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("673", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.13.3", "7.13.3", "automatic", "1", "2020-12-12 06:43:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("674", "0", "Smush (es_ES)", "translation", "3.8.2", "3.8.2", "automatic", "1", "2020-12-12 06:43:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("675", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.13.3", "7.13.3", "automatic", "1", "2020-12-15 10:34:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("676", "0", "Smush (es_ES)", "translation", "3.8.2", "3.8.2", "automatic", "1", "2020-12-15 10:34:48", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("677", "0", "Autoptimize", "plugin", "2.8.0", "2.8.1", "automatic", "1", "2020-12-16 15:28:55", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.8.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("678", "0", "Duplicator", "plugin", "1.3.40", "1.3.40.1", "automatic", "1", "2020-12-16 15:28:55", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.3.40.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("679", "0", "Autoptimize (es_ES)", "translation", "2.8.1", "2.8.1", "automatic", "1", "2020-12-16 15:28:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("680", "0", "Duplicator (es_ES)", "translation", "1.3.40.1", "1.3.40.1", "automatic", "1", "2020-12-16 15:28:55", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("681", "0", "Easy Updates Manager", "plugin", "9.0.6", "9.0.7", "automatic", "1", "2020-12-17 19:49:38", "Actualizando el plugin: Easy Updates Manager\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/stops-core-theme-and-plugin-updates.9.0.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("682", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.13.3", "7.14.0", "automatic", "1", "2020-12-17 19:49:38", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.14.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("683", "0", "Loco Translate", "plugin", "2.4.6", "2.5.0", "automatic", "1", "2020-12-17 19:49:38", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.5.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("684", "0", "W3 Total Cache", "plugin", "0.15.2", "2.0.0", "automatic", "1", "2020-12-17 19:49:38", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.2.0.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("685", "0", "Easy Updates Manager (es_ES)", "translation", "9.0.7", "9.0.7", "automatic", "1", "2020-12-17 19:49:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("686", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.14.0", "7.14.0", "automatic", "1", "2020-12-17 19:49:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("687", "0", "Loco Translate (es_ES)", "translation", "2.5.0", "2.5.0", "automatic", "1", "2020-12-17 19:49:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("688", "0", "W3 Total Cache (es_ES)", "translation", "2.0.0", "2.0.0", "automatic", "1", "2020-12-17 19:49:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("689", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.14.0", "7.14.0", "automatic", "1", "2020-12-17 23:10:11", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("690", "0", "Loco Translate (es_ES)", "translation", "2.5.0", "2.5.0", "automatic", "1", "2020-12-17 23:10:11", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("691", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.14.0", "7.14.0", "automatic", "1", "2020-12-19 15:24:22", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("692", "0", "W3 Total Cache", "plugin", "2.0.0", "2.0.1", "automatic", "1", "2020-12-22 19:48:29", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.2.0.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("693", "0", "GDPR Cookie Consent (es_ES)", "translation", "1.9.5", "1.9.5", "automatic", "1", "2020-12-22 19:48:29", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("694", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.14.0", "7.14.0", "automatic", "1", "2020-12-28 01:23:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("695", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.14.0", "7.14.0", "automatic", "1", "2020-12-31 03:05:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("696", "0", "Smush (es_ES)", "translation", "3.8.2", "3.8.2", "automatic", "1", "2020-12-31 03:05:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("697", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.14.0", "7.14.0", "automatic", "1", "2021-01-03 17:50:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("698", "0", "Akismet Anti-Spam", "plugin", "4.1.7", "4.1.8", "automatic", "1", "2021-01-07 13:36:09", "Actualizando el plugin: Akismet Anti-Spam\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/akismet.4.1.8.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("699", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.0.9.0", "6.0.10.1", "automatic", "1", "2021-01-14 08:44:40", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.0.10.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("700", "0", "Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd (es_ES)", "translation", "6.0.10.1", "6.0.10.1", "automatic", "1", "2021-01-14 08:44:40", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("701", "0", "EWWW Image Optimizer", "plugin", "5.8.2", "6.0.0", "automatic", "1", "2021-01-21 20:55:54", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.6.0.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("702", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.14.0", "7.15.0", "automatic", "1", "2021-01-21 20:55:54", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.15.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("703", "0", "W3 Total Cache", "plugin", "2.0.1", "2.1.0", "automatic", "1", "2021-01-21 20:55:54", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.2.1.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("704", "0", "EWWW Image Optimizer (es_ES)", "translation", "6.0.0", "6.0.0", "automatic", "1", "2021-01-21 20:55:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("705", "0", "W3 Total Cache (es_ES)", "translation", "2.1.0", "2.1.0", "automatic", "1", "2021-01-21 20:55:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("706", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.15.0", "7.15.0", "automatic", "1", "2021-01-25 16:02:45", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("707", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.0.10.1", "6.0.11.1", "automatic", "1", "2021-01-29 04:04:40", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.0.11.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("708", "0", "EWWW Image Optimizer", "plugin", "6.0.0", "6.0.1", "automatic", "1", "2021-01-29 04:04:40", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.6.0.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("709", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.15.0", "7.15.1", "automatic", "1", "2021-01-29 04:04:40", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.15.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("710", "0", "Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd (es_ES)", "translation", "6.0.11.1", "6.0.11.1", "automatic", "1", "2021-01-29 04:04:40", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("711", "0", "W3 Total Cache (es_ES)", "translation", "2.1.0", "2.1.0", "automatic", "1", "2021-02-09 17:16:44", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("712", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.15.1", "7.16.0", "automatic", "1", "2021-02-11 20:04:00", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.16.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("713", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.16.0", "7.16.0", "automatic", "1", "2021-02-11 20:04:00", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("714", "0", "Smush", "plugin", "3.8.2", "3.8.3", "automatic", "1", "2021-02-17 08:11:36", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.8.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("715", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.16.0", "7.16.1", "automatic", "1", "2021-02-18 14:55:20", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.16.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("716", "0", "Smush (es_ES)", "translation", "3.8.3", "3.8.3", "automatic", "1", "2021-02-18 14:55:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("717", "0", "EWWW Image Optimizer", "plugin", "6.0.1", "6.0.3", "automatic", "1", "2021-02-20 01:20:33", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.6.0.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("718", "0", "W3 Total Cache", "plugin", "2.1.0", "2.1.1", "automatic", "1", "2021-02-20 01:20:33", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.2.1.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("719", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.16.1", "7.16.2", "automatic", "1", "2021-02-23 00:01:44", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.16.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("720", "3", "WordPress 5.6.2", "core", "5.3.2", "5.6.2", "manual", "1", "2021-02-23 16:37:59", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("721", "0", "Contact Form 7", "plugin", "5.2.2", "5.4", "automatic", "1", "2021-02-25 18:19:28", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("722", "0", "iThemes Security", "plugin", "7.8.0", "7.9.0", "automatic", "1", "2021-02-25 18:19:28", "Actualizando el plugin: iThemes Security\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/better-wp-security.7.9.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("723", "0", "TinyMCE Advanced", "plugin", "5.2.1", "5.6.0", "automatic", "1", "2021-02-25 18:19:28", "Actualizando el plugin: TinyMCE Advanced\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/tinymce-advanced.5.6.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("724", "0", "Yoast Duplicate Post", "plugin", "3.2.6", "4.1.1", "automatic", "1", "2021-02-25 18:19:28", "Actualizando el plugin: Yoast Duplicate Post\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicate-post.4.1.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("725", "0", "Yoast SEO", "plugin", "14.7", "15.9", "automatic", "1", "2021-02-25 18:19:28", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.15.9.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("726", "0", "Advanced Editor Tools (previously TinyMCE Advanced) (es_ES)", "translation", "5.6.0", "5.6.0", "automatic", "1", "2021-02-25 18:19:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("727", "0", "Contact Form 7 (es_ES)", "translation", "5.4", "5.4", "automatic", "1", "2021-02-25 18:19:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("728", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.16.2", "7.16.2", "automatic", "1", "2021-02-25 18:19:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("729", "0", "iThemes Security (es_ES)", "translation", "7.9.0", "7.9.0", "automatic", "1", "2021-02-25 18:19:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("730", "0", "Yoast Duplicate Post (es_ES)", "translation", "4.1.1", "4.1.1", "automatic", "1", "2021-02-25 18:19:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("731", "0", "Yoast SEO (es_ES)", "translation", "15.9", "15.9", "automatic", "1", "2021-02-25 18:19:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("732", "0", "Smush (es_ES)", "translation", "3.8.3", "3.8.3", "automatic", "1", "2021-02-26 21:21:44", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("733", "0", "Akismet Anti-Spam", "plugin", "4.1.8", "4.1.9", "automatic", "1", "2021-03-03 16:33:46", "Actualizando el plugin: Akismet Anti-Spam\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/akismet.4.1.9.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("734", "0", "Duplicator", "plugin", "1.3.40.1", "1.4.0", "automatic", "1", "2021-03-03 16:33:46", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.4.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("735", "0", "Loco Translate", "plugin", "2.5.0", "2.5.1", "automatic", "1", "2021-03-03 16:33:46", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.5.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("736", "0", "Duplicator (es_ES)", "translation", "1.3.40.1", "1.3.40.1", "automatic", "1", "2021-03-03 16:33:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("737", "0", "Loco Translate (es_ES)", "translation", "2.5.1", "2.5.1", "automatic", "1", "2021-03-03 16:33:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("738", "0", "Honeypot for Contact Form 7", "plugin", "1.14.1", "2.0.1", "automatic", "1", "2021-03-05 08:44:42", "Actualizando el plugin: Honeypot for Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7-honeypot.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("739", "0", "Yoast SEO", "plugin", "15.9", "15.9.1", "automatic", "1", "2021-03-05 08:44:42", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.15.9.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("740", "0", "Yoast SEO (es_ES)", "translation", "15.9.1", "15.9.1", "automatic", "1", "2021-03-05 08:44:42", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("741", "0", "Honeypot for Contact Form 7", "plugin", "2.0.1", "2.0.2", "automatic", "1", "2021-03-05 19:03:43", "Actualizando el plugin: Honeypot for Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7-honeypot.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("742", "0", "Honeypot for Contact Form 7 (es_ES)", "translation", "2.0.2", "2.0.2", "automatic", "1", "2021-03-05 19:03:43", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("743", "0", "Honeypot for Contact Form 7", "plugin", "2.0.2", "2.0.3", "automatic", "1", "2021-03-09 20:16:47", "Actualizando el plugin: Honeypot for Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7-honeypot.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("744", "0", "Honeypot for Contact Form 7 (es_ES)", "translation", "2.0.3", "2.0.3", "automatic", "1", "2021-03-09 20:16:47", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("745", "0", "Yoast SEO (es_ES)", "translation", "15.9.1", "15.9.1", "automatic", "1", "2021-03-09 20:16:47", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("746", "0", "Easy Updates Manager", "plugin", "9.0.7", "9.0.8", "automatic", "1", "2021-03-11 04:29:45", "Actualizando el plugin: Easy Updates Manager\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/stops-core-theme-and-plugin-updates.9.0.8.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("747", "0", "Loco Translate", "plugin", "2.5.1", "2.5.2", "automatic", "1", "2021-03-11 16:39:27", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.5.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("748", "0", "Yoast SEO", "plugin", "15.9.1", "15.9.2", "automatic", "1", "2021-03-11 16:39:27", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.15.9.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("749", "0", "Twenty Twenty-One (es_ES)", "translation", "1.0", "1.0", "automatic", "1", "2021-03-11 16:39:27", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("750", "0", "Honeypot for Contact Form 7", "plugin", "2.0.3", "2.0.4", "automatic", "1", "2021-03-12 02:04:25", "Actualizando el plugin: Honeypot for Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7-honeypot.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("751", "0", "Autoptimize (es_ES)", "translation", "2.8.1", "2.8.1", "automatic", "1", "2021-03-12 19:06:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("752", "0", "Smush (es_ES)", "translation", "3.8.3", "3.8.3", "automatic", "1", "2021-03-12 19:06:50", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("753", "0", "Broken Link Checker (es_ES)", "translation", "1.11.15", "1.11.15", "automatic", "1", "2021-03-13 06:24:07", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("754", "0", "Admin Custom Login", "plugin", "3.2.5", "3.2.6", "automatic", "1", "2021-03-16 09:21:36", "Actualizando el plugin: Admin Custom Login\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/admin-custom-login.3.2.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("755", "0", "Honeypot for Contact Form 7", "plugin", "2.0.4", "2.0.5", "automatic", "1", "2021-03-19 02:47:23", "Actualizando el plugin: Honeypot for Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7-honeypot.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("756", "0", "Yoast SEO", "plugin", "15.9.2", "16.0.2", "automatic", "1", "2021-03-19 02:47:24", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.16.0.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("757", "0", "W3 Total Cache (es_ES)", "translation", "2.1.1", "2.1.1", "automatic", "1", "2021-03-19 02:47:24", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("758", "0", "Yoast SEO (es_ES)", "translation", "16.0.2", "16.0.2", "automatic", "1", "2021-03-19 02:47:24", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("759", "0", "W3 Total Cache (es_ES)", "translation", "2.1.1", "2.1.1", "automatic", "1", "2021-03-21 21:24:00", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("760", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.0.11.1", "6.2.0", "automatic", "1", "2021-03-22 23:56:37", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.2.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("761", "0", "Google Analytics para WordPress por MonsterInsights", "plugin", "7.16.2", "7.17.0", "automatic", "1", "2021-03-23 15:39:49", "Actualizando el plugin: Google Analytics para WordPress por MonsterInsights\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/google-analytics-for-wordpress.7.17.0.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("762", "0", "Yoast Duplicate Post", "plugin", "4.1.1", "4.1.2", "automatic", "1", "2021-03-23 15:39:49", "Actualizando el plugin: Yoast Duplicate Post\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicate-post.4.1.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("763", "0", "Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd (es_ES)", "translation", "6.2.0", "6.2.0", "automatic", "1", "2021-03-23 15:39:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("764", "0", "Yoast Duplicate Post (es_ES)", "translation", "4.1.2", "4.1.2", "automatic", "1", "2021-03-23 15:39:49", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("765", "0", "Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd (es_ES)", "translation", "6.2.0", "6.2.0", "automatic", "1", "2021-03-24 04:42:18", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("766", "0", "Google Analytics for WordPress by MonsterInsights (es_ES)", "translation", "7.17.0", "7.17.0", "automatic", "1", "2021-03-24 04:42:18", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("767", "0", "Easy Updates Manager (es_ES)", "translation", "9.0.8", "9.0.8", "automatic", "1", "2021-03-25 00:42:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("768", "0", "W3 Total Cache (es_ES)", "translation", "2.1.1", "2.1.1", "automatic", "1", "2021-03-25 00:42:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("769", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.2.0", "6.2.1", "automatic", "1", "2021-03-31 12:30:02", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.2.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("770", "3", "WordPress 5.7", "core", "5.6.2", "5.7", "manual", "1", "2021-04-01 08:33:22", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("771", "0", "Autoptimize", "plugin", "2.8.1", "2.8.3", "automatic", "1", "2021-04-03 13:31:46", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.8.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("772", "0", "Autoptimize (es_ES)", "translation", "2.8.3", "2.8.3", "automatic", "1", "2021-04-03 13:31:46", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("773", "0", "Advanced Editor Tools (previously TinyMCE Advanced) (es_ES)", "translation", "5.6.0", "5.6.0", "automatic", "1", "2021-04-05 14:55:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("774", "0", "W3 Total Cache (es_ES)", "translation", "2.1.1", "2.1.1", "automatic", "1", "2021-04-05 14:55:54", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("775", "0", "Smush", "plugin", "3.8.3", "3.8.4", "automatic", "1", "2021-04-06 10:49:25", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.8.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("776", "0", "Yoast SEO", "plugin", "16.0.2", "16.1", "automatic", "1", "2021-04-06 10:49:25", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.16.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("777", "0", "Smush (es_ES)", "translation", "3.8.4", "3.8.4", "automatic", "1", "2021-04-06 10:49:25", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("778", "0", "W3 Total Cache (es_ES)", "translation", "2.1.1", "2.1.1", "automatic", "1", "2021-04-06 10:49:25", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("779", "0", "Yoast SEO (es_ES)", "translation", "16.1", "16.1", "automatic", "1", "2021-04-06 10:49:25", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("780", "0", "W3 Total Cache", "plugin", "2.1.1", "2.1.2", "automatic", "1", "2021-04-07 05:24:58", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.2.1.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("781", "0", "Yoast SEO", "plugin", "16.1", "16.1.1", "automatic", "1", "2021-04-07 05:24:58", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.16.1.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("782", "0", "Smush (es_ES)", "translation", "3.8.4", "3.8.4", "automatic", "1", "2021-04-07 05:24:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("783", "0", "W3 Total Cache (es_ES)", "translation", "2.1.2", "2.1.2", "automatic", "1", "2021-04-07 05:24:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("784", "0", "Yoast SEO (es_ES)", "translation", "16.1.1", "16.1.1", "automatic", "1", "2021-04-07 05:24:58", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("785", "0", "Smush (es_ES)", "translation", "3.8.4", "3.8.4", "automatic", "1", "2021-04-09 06:17:06", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("786", "0", "iThemes Security", "plugin", "7.9.0", "7.9.1", "automatic", "1", "2021-04-14 23:47:27", "Actualizando el plugin: iThemes Security\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/better-wp-security.7.9.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("787", "0", "WordPress 5.7.1", "core", "5.7.1", "5.7.1", "automatic", "0", "2021-04-16 11:02:42", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("788", "0", "iThemes Security (es_ES)", "translation", "7.9.1", "7.9.1", "automatic", "1", "2021-04-16 11:02:42", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("789", "0", "WordPress (es_ES)", "translation", "5.7.1", "5.7.1", "automatic", "1", "2021-04-26 00:59:53", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("790", "0", "Contact Form 7", "plugin", "5.4", "5.4.1", "automatic", "1", "2021-04-29 21:50:40", "Actualizando el plugin: Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7.5.4.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("791", "0", "Yoast SEO", "plugin", "16.1.1", "16.2", "automatic", "1", "2021-04-29 21:50:40", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.16.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("792", "0", "Contact Form 7 (es_ES)", "translation", "5.4.1", "5.4.1", "automatic", "1", "2021-04-29 21:50:40", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("793", "0", "Yoast SEO (es_ES)", "translation", "16.2", "16.2", "automatic", "1", "2021-04-29 21:50:40", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("794", "0", "Honeypot for Contact Form 7", "plugin", "2.0.5", "2.1", "automatic", "1", "2021-05-04 00:56:57", "Actualizando el plugin: Honeypot for Contact Form 7\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/contact-form-7-honeypot.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("795", "0", "Autoptimize", "plugin", "2.8.3", "2.8.4", "automatic", "1", "2021-05-04 15:47:26", "Actualizando el plugin: Autoptimize\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/autoptimize.2.8.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("796", "0", "W3 Total Cache (es_ES)", "translation", "2.1.2", "2.1.2", "automatic", "1", "2021-05-07 08:44:30", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("797", "0", "WordPress 5.7.2", "core", "5.7.2", "5.7.2", "automatic", "0", "2021-05-14 13:09:28", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("798", "0", "Yoast SEO", "plugin", "16.2", "16.3", "automatic", "1", "2021-05-18 21:18:20", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.16.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("799", "0", "Yoast SEO (es_ES)", "translation", "16.3", "16.3", "automatic", "1", "2021-05-18 21:18:20", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("800", "0", "Smush", "plugin", "3.8.4", "3.8.5", "automatic", "1", "2021-05-21 14:22:11", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.8.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("801", "0", "Smush (es_ES)", "translation", "3.8.5", "3.8.5", "automatic", "1", "2021-05-21 14:22:11", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("802", "3", "EWWW Image Optimizer", "plugin", "6.0.3", "6.1.5", "manual", "1", "2021-05-26 07:12:21", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("803", "3", "EWWW Image Optimizer (es_ES)", "translation", "6.1.5", "6.1.5", "manual", "1", "2021-05-26 07:12:24", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("804", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.2.1", "6.2.2", "automatic", "1", "2021-05-27 14:15:32", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.2.2.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("805", "0", "Duplicator", "plugin", "1.4.0", "1.4.1", "automatic", "1", "2021-05-27 14:15:32", "Actualizando el plugin: Duplicator\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/duplicator.1.4.1.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("806", "0", "Duplicator (es_ES)", "translation", "1.4.1", "1.4.1", "automatic", "1", "2021-05-27 14:15:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("807", "0", "W3 Total Cache (es_ES)", "translation", "2.1.2", "2.1.2", "automatic", "1", "2021-05-27 14:15:32", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("808", "0", "W3 Total Cache", "plugin", "2.1.2", "2.1.3", "automatic", "1", "2021-05-28 19:59:23", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.2.1.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("809", "0", "W3 Total Cache (es_ES)", "translation", "2.1.3", "2.1.3", "automatic", "1", "2021-05-28 19:59:23", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("810", "0", "Yoast SEO", "plugin", "16.3", "16.4", "automatic", "1", "2021-06-01 16:52:57", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.16.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("811", "0", "Yoast SEO (es_ES)", "translation", "16.4", "16.4", "automatic", "1", "2021-06-01 16:52:57", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("812", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.2.2", "6.2.3", "automatic", "1", "2021-06-03 18:15:40", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.2.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("813", "0", "EWWW Image Optimizer (es_ES)", "translation", "6.1.5", "6.1.5", "automatic", "1", "2021-06-05 00:04:41", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("814", "0", "Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd (es_ES)", "translation", "6.2.3", "6.2.3", "automatic", "1", "2021-06-05 23:11:43", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("815", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.2.3", "6.2.4", "automatic", "1", "2021-06-08 09:13:46", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.2.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("816", "0", "WordPress (es_ES)", "translation", "5.7.2", "5.7.2", "automatic", "1", "2021-06-11 15:00:38", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("817", "0", "Easy Updates Manager", "plugin", "9.0.8", "9.0.9", "automatic", "1", "2021-06-13 17:22:03", "Actualizando el plugin: Easy Updates Manager\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/stops-core-theme-and-plugin-updates.9.0.9.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("818", "0", "Easy Updates Manager (es_ES)", "translation", "9.0.9", "9.0.9", "automatic", "1", "2021-06-13 17:22:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("819", "0", "EWWW Image Optimizer (es_ES)", "translation", "6.1.5", "6.1.5", "automatic", "1", "2021-06-13 17:22:03", "", NULL);
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("820", "0", "Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd", "plugin", "6.2.4", "6.2.5", "automatic", "1", "2021-06-15 03:05:51", "Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/coming-soon.6.2.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/coming-soon\",\"slug\":\"coming-soon\",\"plugin\":\"coming-soon\\/coming-soon.php\",\"new_version\":\"6.2.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/coming-soon\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/coming-soon.6.2.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/icon-256x256.png?rev=2402574\",\"1x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/icon-128x128.png?rev=2402575\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/banner-772x250.png?rev=2402574\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"6.2.4\"},\"result\":true,\"name\":\"Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\",\"messages\":[\"Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/coming-soon.6.2.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/coming-soon\",\"slug\":\"coming-soon\",\"plugin\":\"coming-soon\\/coming-soon.php\",\"new_version\":\"6.2.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/coming-soon\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/coming-soon.6.2.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/icon-256x256.png?rev=2402574\",\"1x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/icon-128x128.png?rev=2402575\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/banner-772x250.png?rev=2402574\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"6.2.4\"},\"result\":true,\"name\":\"Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\",\"messages\":[\"Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/coming-soon.6.2.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/coming-soon\",\"slug\":\"coming-soon\",\"plugin\":\"coming-soon\\/coming-soon.php\",\"new_version\":\"6.2.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/coming-soon\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/coming-soon.6.2.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/icon-256x256.png?rev=2402574\",\"1x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/icon-128x128.png?rev=2402575\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/banner-772x250.png?rev=2402574\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"6.2.4\"},\"result\":true,\"name\":\"Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\",\"messages\":[\"Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/coming-soon.6.2.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/coming-soon\",\"slug\":\"coming-soon\",\"plugin\":\"coming-soon\\/coming-soon.php\",\"new_version\":\"6.2.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/coming-soon\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/coming-soon.6.2.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/icon-256x256.png?rev=2402574\",\"1x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/icon-128x128.png?rev=2402575\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/coming-soon\\/assets\\/banner-772x250.png?rev=2402574\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"6.2.4\"},\"result\":true,\"name\":\"Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\",\"messages\":[\"Actualizando el plugin: Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/coming-soon.6.2.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("821", "0", "Yoast SEO", "plugin", "16.4", "16.5", "automatic", "1", "2021-06-15 10:26:52", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.16.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.4\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 07:02:13\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-hsZ3er\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.4\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 07:02:13\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-hsZ3er\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.4\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 07:02:13\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-hsZ3er\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.4\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 07:02:13\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-hsZ3er\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("822", "0", "Yoast SEO (es_ES)", "translation", "16.5", "16.5", "automatic", "1", "2021-06-15 10:26:52", "", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.4\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 07:02:13\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-hsZ3er\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.4\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 07:02:13\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-hsZ3er\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.4\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 07:02:13\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-hsZ3er\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.4\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 07:02:13\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-hsZ3er\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("823", "0", "Yoast SEO (es_ES)", "translation", "16.5", "16.5", "automatic", "1", "2021-06-16 02:12:47", "", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 10:02:33\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-U6MNlX\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 10:02:33\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-U6MNlX\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 10:02:33\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-U6MNlX\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-15 10:02:33\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-U6MNlX\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("824", "0", "EWWW Image Optimizer", "plugin", "6.1.5", "6.1.6", "automatic", "1", "2021-06-18 09:47:26", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.6.1.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.5\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.4\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.3\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.5\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.4\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.3\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.5\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.4\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.3\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.5\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.4\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.3\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("825", "0", "W3 Total Cache", "plugin", "2.1.3", "2.1.4", "automatic", "1", "2021-06-18 09:47:26", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.2.1.4.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.5\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.4\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.3\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.5\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.4\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.3\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.5\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.4\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.3\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.5\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.4\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.3\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.4.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("826", "0", "EWWW Image Optimizer", "plugin", "6.1.6", "6.1.7", "automatic", "1", "2021-06-20 09:24:50", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.6.1.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("827", "0", "EWWW Image Optimizer (es_ES)", "translation", "6.1.7", "6.1.7", "automatic", "1", "2021-06-20 09:24:50", "", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("828", "0", "Yoast SEO (es_ES)", "translation", "16.5", "16.5", "automatic", "1", "2021-06-20 09:24:50", "", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.6\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"ewww-image-optimizer\",\"language\":\"es_ES\",\"version\":\"6.1.7\",\"updated\":\"2021-06-19 15:53:32\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-MBUUUB\\/\",\"source_files\":[\"ewww-image-optimizer-es_ES.po\",\"ewww-image-optimizer-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de EWWW Image Optimizer\",\"messages\":[\"Actualizando las traducciones de EWWW Image Optimizer (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/ewww-image-optimizer\\/6.1.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.5\",\"updated\":\"2021-06-19 15:42:26\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-B7rbam\\/\",\"source_files\":[\"wordpress-seo-es_ES-cec7bd1bfdaaa97e62a804dc5cebce26.json\",\"wordpress-seo-es_ES-5d30f2dc5a2d146ab1066bf938e68a3f.json\",\"wordpress-seo-es_ES-cd8298dd093695c568826a61b2c579f1.json\",\"wordpress-seo-es_ES-8efea5a3d570805c878c54bb489bac12.json\",\"wordpress-seo-es_ES-909d287014319554b67f83fdb9665696.json\",\"wordpress-seo-es_ES-da9aaa5a4c5f69b697bc579bfd1ad1bb.json\",\"wordpress-seo-es_ES-daa087737389000704071d4aeee2c9aa.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-3d495feca8110d24a2da076a28cae241.json\",\"wordpress-seo-es_ES-e4ee2e592a2c253bbfac66e17825fc01.json\",\"wordpress-seo-es_ES-3927e82933d513a37eaf23c47c5964d2.json\",\"wordpress-seo-es_ES-9638fa1a4067da86bfb2035ee282b07b.json\",\"wordpress-seo-es_ES-c70c6db5fb32f9a8b882a7ba78f563b8.json\",\"wordpress-seo-es_ES-8202f4ecb37ab243a796a38753fa1fad.json\",\"wordpress-seo-es_ES-53dfe0d34e02af346307da985bc81214.json\",\"wordpress-seo-es_ES-0e06887b24c3ab8517cd4a45d9c0dca7.json\",\"wordpress-seo-es_ES-e1304d148269d45ba624253e4aa36e69.json\",\"wordpress-seo-es_ES-3ac019768dec668e16e41fd89e3ccdb1.json\",\"wordpress-seo-es_ES-e8507850c1b84317cb578d6180a9ea1e.json\",\"wordpress-seo-es_ES-ff2648310ce5c837524b9073ae09a80f.json\",\"wordpress-seo-es_ES-6fdeeab4b0f94519f304d3984937b762.json\",\"wordpress-seo-es_ES-8498f4ff8c8ab2d3aa5a76695cb6de43.json\",\"wordpress-seo-es_ES-69f36ae0ba8361754e456012601af64a.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("829", "0", "W3 Total Cache", "plugin", "2.1.4", "2.1.5", "automatic", "1", "2021-06-22 09:22:52", "Actualizando el plugin: W3 Total Cache\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/w3-total-cache.2.1.5.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.4\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"coming-soon\",\"language\":\"es_ES\",\"version\":\"6.2.5\",\"updated\":\"2021-06-21 07:19:05\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-FsSXvS\\/\",\"source_files\":[\"coming-soon-es_ES.mo\",\"coming-soon-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd\",\"messages\":[\"Actualizando las traducciones de Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.4\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"coming-soon\",\"language\":\"es_ES\",\"version\":\"6.2.5\",\"updated\":\"2021-06-21 07:19:05\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-FsSXvS\\/\",\"source_files\":[\"coming-soon-es_ES.mo\",\"coming-soon-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd\",\"messages\":[\"Actualizando las traducciones de Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.4\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"coming-soon\",\"language\":\"es_ES\",\"version\":\"6.2.5\",\"updated\":\"2021-06-21 07:19:05\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-FsSXvS\\/\",\"source_files\":[\"coming-soon-es_ES.mo\",\"coming-soon-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd\",\"messages\":[\"Actualizando las traducciones de Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.4\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"coming-soon\",\"language\":\"es_ES\",\"version\":\"6.2.5\",\"updated\":\"2021-06-21 07:19:05\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-FsSXvS\\/\",\"source_files\":[\"coming-soon-es_ES.mo\",\"coming-soon-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd\",\"messages\":[\"Actualizando las traducciones de Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("830", "0", "Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd (es_ES)", "translation", "6.2.5", "6.2.5", "automatic", "1", "2021-06-22 09:22:52", "", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.4\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"coming-soon\",\"language\":\"es_ES\",\"version\":\"6.2.5\",\"updated\":\"2021-06-21 07:19:05\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-FsSXvS\\/\",\"source_files\":[\"coming-soon-es_ES.mo\",\"coming-soon-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd\",\"messages\":[\"Actualizando las traducciones de Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.4\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"coming-soon\",\"language\":\"es_ES\",\"version\":\"6.2.5\",\"updated\":\"2021-06-21 07:19:05\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-FsSXvS\\/\",\"source_files\":[\"coming-soon-es_ES.mo\",\"coming-soon-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd\",\"messages\":[\"Actualizando las traducciones de Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.4\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"coming-soon\",\"language\":\"es_ES\",\"version\":\"6.2.5\",\"updated\":\"2021-06-21 07:19:05\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-FsSXvS\\/\",\"source_files\":[\"coming-soon-es_ES.mo\",\"coming-soon-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd\",\"messages\":[\"Actualizando las traducciones de Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/w3-total-cache\",\"slug\":\"w3-total-cache\",\"plugin\":\"w3-total-cache\\/w3-total-cache.php\",\"new_version\":\"2.1.5\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/w3-total-cache\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-256x256.png?rev=1041806\",\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/icon-128x128.png?rev=1041806\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/w3-total-cache\\/assets\\/banner-772x250.jpg?rev=1041806\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6\",\"compatibility\":{},\"current_version\":\"2.1.4\"},\"result\":true,\"name\":\"W3 Total Cache\",\"messages\":[\"Actualizando el plugin: W3 Total Cache\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/w3-total-cache.2.1.5.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"coming-soon\",\"language\":\"es_ES\",\"version\":\"6.2.5\",\"updated\":\"2021-06-21 07:19:05\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-FsSXvS\\/\",\"source_files\":[\"coming-soon-es_ES.mo\",\"coming-soon-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Coming Soon Page, Maintenance Mode & Landing Pages by SeedProd\",\"messages\":[\"Actualizando las traducciones de Coming Soon Page, Maintenance Mode &amp; Landing Pages by SeedProd (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/coming-soon\\/6.2.5\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("831", "0", "Loco Translate", "plugin", "2.5.2", "2.5.3", "automatic", "1", "2021-06-23 00:45:45", "Actualizando el plugin: Loco Translate\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/loco-translate.2.5.3.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/loco-translate\",\"slug\":\"loco-translate\",\"plugin\":\"loco-translate\\/loco.php\",\"new_version\":\"2.5.3\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-256x256.png?rev=1000676\",\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-128x128.png?rev=1000676\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/banner-772x250.jpg?rev=745046\"},\"banners_rtl\":[],\"upgrade_notice\":\"<ul>\\n<li>Various improvements and bugfixes<\\/li>\\n<\\/ul>\",\"tested\":\"5.7.2\",\"requires_php\":\"5.2.4\",\"compatibility\":{},\"current_version\":\"2.5.2\"},\"result\":true,\"name\":\"Loco Translate\",\"messages\":[\"Actualizando el plugin: Loco Translate\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"loco-translate\",\"language\":\"es_ES\",\"version\":\"2.5.3\",\"updated\":\"2021-06-22 17:35:45\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-K5xNQG\\/\",\"source_files\":[\"loco-translate-es_ES.mo\",\"loco-translate-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Loco Translate\",\"messages\":[\"Actualizando las traducciones de Loco Translate (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/loco-translate\",\"slug\":\"loco-translate\",\"plugin\":\"loco-translate\\/loco.php\",\"new_version\":\"2.5.3\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-256x256.png?rev=1000676\",\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-128x128.png?rev=1000676\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/banner-772x250.jpg?rev=745046\"},\"banners_rtl\":[],\"upgrade_notice\":\"<ul>\\n<li>Various improvements and bugfixes<\\/li>\\n<\\/ul>\",\"tested\":\"5.7.2\",\"requires_php\":\"5.2.4\",\"compatibility\":{},\"current_version\":\"2.5.2\"},\"result\":true,\"name\":\"Loco Translate\",\"messages\":[\"Actualizando el plugin: Loco Translate\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"loco-translate\",\"language\":\"es_ES\",\"version\":\"2.5.3\",\"updated\":\"2021-06-22 17:35:45\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-K5xNQG\\/\",\"source_files\":[\"loco-translate-es_ES.mo\",\"loco-translate-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Loco Translate\",\"messages\":[\"Actualizando las traducciones de Loco Translate (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/loco-translate\",\"slug\":\"loco-translate\",\"plugin\":\"loco-translate\\/loco.php\",\"new_version\":\"2.5.3\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-256x256.png?rev=1000676\",\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-128x128.png?rev=1000676\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/banner-772x250.jpg?rev=745046\"},\"banners_rtl\":[],\"upgrade_notice\":\"<ul>\\n<li>Various improvements and bugfixes<\\/li>\\n<\\/ul>\",\"tested\":\"5.7.2\",\"requires_php\":\"5.2.4\",\"compatibility\":{},\"current_version\":\"2.5.2\"},\"result\":true,\"name\":\"Loco Translate\",\"messages\":[\"Actualizando el plugin: Loco Translate\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"loco-translate\",\"language\":\"es_ES\",\"version\":\"2.5.3\",\"updated\":\"2021-06-22 17:35:45\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-K5xNQG\\/\",\"source_files\":[\"loco-translate-es_ES.mo\",\"loco-translate-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Loco Translate\",\"messages\":[\"Actualizando las traducciones de Loco Translate (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/loco-translate\",\"slug\":\"loco-translate\",\"plugin\":\"loco-translate\\/loco.php\",\"new_version\":\"2.5.3\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-256x256.png?rev=1000676\",\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-128x128.png?rev=1000676\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/banner-772x250.jpg?rev=745046\"},\"banners_rtl\":[],\"upgrade_notice\":\"<ul>\\n<li>Various improvements and bugfixes<\\/li>\\n<\\/ul>\",\"tested\":\"5.7.2\",\"requires_php\":\"5.2.4\",\"compatibility\":{},\"current_version\":\"2.5.2\"},\"result\":true,\"name\":\"Loco Translate\",\"messages\":[\"Actualizando el plugin: Loco Translate\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"loco-translate\",\"language\":\"es_ES\",\"version\":\"2.5.3\",\"updated\":\"2021-06-22 17:35:45\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-K5xNQG\\/\",\"source_files\":[\"loco-translate-es_ES.mo\",\"loco-translate-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Loco Translate\",\"messages\":[\"Actualizando las traducciones de Loco Translate (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("832", "0", "Loco Translate (es_ES)", "translation", "2.5.3", "2.5.3", "automatic", "1", "2021-06-23 00:45:45", "", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/loco-translate\",\"slug\":\"loco-translate\",\"plugin\":\"loco-translate\\/loco.php\",\"new_version\":\"2.5.3\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-256x256.png?rev=1000676\",\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-128x128.png?rev=1000676\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/banner-772x250.jpg?rev=745046\"},\"banners_rtl\":[],\"upgrade_notice\":\"<ul>\\n<li>Various improvements and bugfixes<\\/li>\\n<\\/ul>\",\"tested\":\"5.7.2\",\"requires_php\":\"5.2.4\",\"compatibility\":{},\"current_version\":\"2.5.2\"},\"result\":true,\"name\":\"Loco Translate\",\"messages\":[\"Actualizando el plugin: Loco Translate\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"loco-translate\",\"language\":\"es_ES\",\"version\":\"2.5.3\",\"updated\":\"2021-06-22 17:35:45\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-K5xNQG\\/\",\"source_files\":[\"loco-translate-es_ES.mo\",\"loco-translate-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Loco Translate\",\"messages\":[\"Actualizando las traducciones de Loco Translate (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/loco-translate\",\"slug\":\"loco-translate\",\"plugin\":\"loco-translate\\/loco.php\",\"new_version\":\"2.5.3\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-256x256.png?rev=1000676\",\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-128x128.png?rev=1000676\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/banner-772x250.jpg?rev=745046\"},\"banners_rtl\":[],\"upgrade_notice\":\"<ul>\\n<li>Various improvements and bugfixes<\\/li>\\n<\\/ul>\",\"tested\":\"5.7.2\",\"requires_php\":\"5.2.4\",\"compatibility\":{},\"current_version\":\"2.5.2\"},\"result\":true,\"name\":\"Loco Translate\",\"messages\":[\"Actualizando el plugin: Loco Translate\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"loco-translate\",\"language\":\"es_ES\",\"version\":\"2.5.3\",\"updated\":\"2021-06-22 17:35:45\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-K5xNQG\\/\",\"source_files\":[\"loco-translate-es_ES.mo\",\"loco-translate-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Loco Translate\",\"messages\":[\"Actualizando las traducciones de Loco Translate (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/loco-translate\",\"slug\":\"loco-translate\",\"plugin\":\"loco-translate\\/loco.php\",\"new_version\":\"2.5.3\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-256x256.png?rev=1000676\",\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-128x128.png?rev=1000676\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/banner-772x250.jpg?rev=745046\"},\"banners_rtl\":[],\"upgrade_notice\":\"<ul>\\n<li>Various improvements and bugfixes<\\/li>\\n<\\/ul>\",\"tested\":\"5.7.2\",\"requires_php\":\"5.2.4\",\"compatibility\":{},\"current_version\":\"2.5.2\"},\"result\":true,\"name\":\"Loco Translate\",\"messages\":[\"Actualizando el plugin: Loco Translate\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"loco-translate\",\"language\":\"es_ES\",\"version\":\"2.5.3\",\"updated\":\"2021-06-22 17:35:45\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-K5xNQG\\/\",\"source_files\":[\"loco-translate-es_ES.mo\",\"loco-translate-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Loco Translate\",\"messages\":[\"Actualizando las traducciones de Loco Translate (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/loco-translate\",\"slug\":\"loco-translate\",\"plugin\":\"loco-translate\\/loco.php\",\"new_version\":\"2.5.3\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-256x256.png?rev=1000676\",\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/icon-128x128.png?rev=1000676\"},\"banners\":{\"1x\":\"https:\\/\\/ps.w.org\\/loco-translate\\/assets\\/banner-772x250.jpg?rev=745046\"},\"banners_rtl\":[],\"upgrade_notice\":\"<ul>\\n<li>Various improvements and bugfixes<\\/li>\\n<\\/ul>\",\"tested\":\"5.7.2\",\"requires_php\":\"5.2.4\",\"compatibility\":{},\"current_version\":\"2.5.2\"},\"result\":true,\"name\":\"Loco Translate\",\"messages\":[\"Actualizando el plugin: Loco Translate\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/loco-translate.2.5.3.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"loco-translate\",\"language\":\"es_ES\",\"version\":\"2.5.3\",\"updated\":\"2021-06-22 17:35:45\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-K5xNQG\\/\",\"source_files\":[\"loco-translate-es_ES.mo\",\"loco-translate-es_ES.po\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Loco Translate\",\"messages\":[\"Actualizando las traducciones de Loco Translate (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/loco-translate\\/2.5.3\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("833", "0", "EWWW Image Optimizer", "plugin", "6.1.7", "6.1.8", "automatic", "1", "2021-06-26 13:37:38", "Actualizando el plugin: EWWW Image Optimizer\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/ewww-image-optimizer.6.1.8.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.8\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.7\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"duplicate-post\",\"language\":\"es_ES\",\"version\":\"4.1.2\",\"updated\":\"2021-06-26 09:21:35\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-JoSJP3\\/\",\"source_files\":[\"duplicate-post-es_ES.po\",\"duplicate-post-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast Duplicate Post\",\"messages\":[\"Actualizando las traducciones de Yoast Duplicate Post (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.8\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.7\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"duplicate-post\",\"language\":\"es_ES\",\"version\":\"4.1.2\",\"updated\":\"2021-06-26 09:21:35\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-JoSJP3\\/\",\"source_files\":[\"duplicate-post-es_ES.po\",\"duplicate-post-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast Duplicate Post\",\"messages\":[\"Actualizando las traducciones de Yoast Duplicate Post (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.8\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.7\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"duplicate-post\",\"language\":\"es_ES\",\"version\":\"4.1.2\",\"updated\":\"2021-06-26 09:21:35\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-JoSJP3\\/\",\"source_files\":[\"duplicate-post-es_ES.po\",\"duplicate-post-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast Duplicate Post\",\"messages\":[\"Actualizando las traducciones de Yoast Duplicate Post (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.8\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.7\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"duplicate-post\",\"language\":\"es_ES\",\"version\":\"4.1.2\",\"updated\":\"2021-06-26 09:21:35\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-JoSJP3\\/\",\"source_files\":[\"duplicate-post-es_ES.po\",\"duplicate-post-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast Duplicate Post\",\"messages\":[\"Actualizando las traducciones de Yoast Duplicate Post (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("834", "0", "Yoast Duplicate Post (es_ES)", "translation", "4.1.2", "4.1.2", "automatic", "1", "2021-06-26 13:37:38", "", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.8\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.7\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"duplicate-post\",\"language\":\"es_ES\",\"version\":\"4.1.2\",\"updated\":\"2021-06-26 09:21:35\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-JoSJP3\\/\",\"source_files\":[\"duplicate-post-es_ES.po\",\"duplicate-post-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast Duplicate Post\",\"messages\":[\"Actualizando las traducciones de Yoast Duplicate Post (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.8\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.7\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"duplicate-post\",\"language\":\"es_ES\",\"version\":\"4.1.2\",\"updated\":\"2021-06-26 09:21:35\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-JoSJP3\\/\",\"source_files\":[\"duplicate-post-es_ES.po\",\"duplicate-post-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast Duplicate Post\",\"messages\":[\"Actualizando las traducciones de Yoast Duplicate Post (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.8\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.7\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"duplicate-post\",\"language\":\"es_ES\",\"version\":\"4.1.2\",\"updated\":\"2021-06-26 09:21:35\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-JoSJP3\\/\",\"source_files\":[\"duplicate-post-es_ES.po\",\"duplicate-post-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast Duplicate Post\",\"messages\":[\"Actualizando las traducciones de Yoast Duplicate Post (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/ewww-image-optimizer\",\"slug\":\"ewww-image-optimizer\",\"plugin\":\"ewww-image-optimizer\\/ewww-image-optimizer.php\",\"new_version\":\"6.1.8\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/ewww-image-optimizer\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-256x256.png?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/icon-128x128.png?rev=1582276\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-1544x500.jpg?rev=1582276\",\"1x\":\"https:\\/\\/ps.w.org\\/ewww-image-optimizer\\/assets\\/banner-772x250.jpg?rev=1582276\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"7.1\",\"compatibility\":{},\"current_version\":\"6.1.7\"},\"result\":true,\"name\":\"EWWW Image Optimizer\",\"messages\":[\"Actualizando el plugin: EWWW Image Optimizer\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/ewww-image-optimizer.6.1.8.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"duplicate-post\",\"language\":\"es_ES\",\"version\":\"4.1.2\",\"updated\":\"2021-06-26 09:21:35\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-JoSJP3\\/\",\"source_files\":[\"duplicate-post-es_ES.po\",\"duplicate-post-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast Duplicate Post\",\"messages\":[\"Actualizando las traducciones de Yoast Duplicate Post (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/duplicate-post\\/4.1.2\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("835", "0", "Smush", "plugin", "3.8.5", "3.8.7", "automatic", "1", "2021-06-30 11:40:29", "Actualizando el plugin: Smush\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wp-smushit.3.8.7.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wp-smushit\",\"slug\":\"wp-smushit\",\"plugin\":\"wp-smushit\\/wp-smush.php\",\"new_version\":\"3.8.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-smushit\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-256x256.gif?rev=2263432\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-128x128.gif?rev=2263431\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-1544x500.png?rev=1863697\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-772x250.png?rev=1863697\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"3.8.5\"},\"result\":true,\"name\":\"Smush\",\"messages\":[\"Actualizando el plugin: Smush\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.5\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wp-smushit\",\"language\":\"es_ES\",\"version\":\"3.8.7\",\"updated\":\"2021-06-29 17:21:17\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-11NMpy\\/\",\"source_files\":[\"wp-smushit-es_ES-4c1d4f4057e9fe55cac6131666a684af.json\",\"wp-smushit-es_ES.po\",\"wp-smushit-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Smush\",\"messages\":[\"Actualizando las traducciones de Smush (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.6\",\"updated\":\"2021-06-29 08:52:03\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-ullE7P\\/\",\"source_files\":[\"wordpress-seo-es_ES-289842c03126754e6a23eb1db36f395e.json\",\"wordpress-seo-es_ES-aa74e2b01307e27d6aace8c473481828.json\",\"wordpress-seo-es_ES-5f55aea6a1215ab9fa23714c6fed06e8.json\",\"wordpress-seo-es_ES-3d3fb322ac48db62391d821564cfe6f1.json\",\"wordpress-seo-es_ES-16aaaf8c96276dfea20072efe7e0ce06.json\",\"wordpress-seo-es_ES-fd88af3b97dc9e022ab10cf6bd79ff19.json\",\"wordpress-seo-es_ES-c3172bacda9ab4f325fe54d0208af9ff.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-95e5c05a21306582b44e9f24c97b4ddd.json\",\"wordpress-seo-es_ES-f9a4f263d05d2bf02927e0f97576f49f.json\",\"wordpress-seo-es_ES-188a17224a5b1b7d950936646679d44c.json\",\"wordpress-seo-es_ES-8d711d3adba936f10d7b5753931a9db1.json\",\"wordpress-seo-es_ES-588361e412aa3f185e103ad7e8f2d93c.json\",\"wordpress-seo-es_ES-73f645d2b957bbd8b1247675cf11a9f5.json\",\"wordpress-seo-es_ES-02cd8292a0dac2e9475423d6455a13f3.json\",\"wordpress-seo-es_ES-7ed5c62c86764068cb2d480ebee9e7d8.json\",\"wordpress-seo-es_ES-a287a551d351044ba55c0faaf0b6f708.json\",\"wordpress-seo-es_ES-f67afac6c2f40e26c26b8d8c7ee7a906.json\",\"wordpress-seo-es_ES-c27995ed2b47142ac213a4c949d83e3a.json\",\"wordpress-seo-es_ES-93f20e0009ce5139eb4d18a512f1c06c.json\",\"wordpress-seo-es_ES-3da4347ba3de6465f476ed722a0160a5.json\",\"wordpress-seo-es_ES-3b9b5f1953052e4023128fddef79d981.json\",\"wordpress-seo-es_ES-9d961bbf3cbb76dd3bdda751e24d1724.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wp-smushit\",\"slug\":\"wp-smushit\",\"plugin\":\"wp-smushit\\/wp-smush.php\",\"new_version\":\"3.8.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-smushit\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-256x256.gif?rev=2263432\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-128x128.gif?rev=2263431\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-1544x500.png?rev=1863697\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-772x250.png?rev=1863697\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"3.8.5\"},\"result\":true,\"name\":\"Smush\",\"messages\":[\"Actualizando el plugin: Smush\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.5\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wp-smushit\",\"language\":\"es_ES\",\"version\":\"3.8.7\",\"updated\":\"2021-06-29 17:21:17\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-11NMpy\\/\",\"source_files\":[\"wp-smushit-es_ES-4c1d4f4057e9fe55cac6131666a684af.json\",\"wp-smushit-es_ES.po\",\"wp-smushit-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Smush\",\"messages\":[\"Actualizando las traducciones de Smush (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.6\",\"updated\":\"2021-06-29 08:52:03\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-ullE7P\\/\",\"source_files\":[\"wordpress-seo-es_ES-289842c03126754e6a23eb1db36f395e.json\",\"wordpress-seo-es_ES-aa74e2b01307e27d6aace8c473481828.json\",\"wordpress-seo-es_ES-5f55aea6a1215ab9fa23714c6fed06e8.json\",\"wordpress-seo-es_ES-3d3fb322ac48db62391d821564cfe6f1.json\",\"wordpress-seo-es_ES-16aaaf8c96276dfea20072efe7e0ce06.json\",\"wordpress-seo-es_ES-fd88af3b97dc9e022ab10cf6bd79ff19.json\",\"wordpress-seo-es_ES-c3172bacda9ab4f325fe54d0208af9ff.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-95e5c05a21306582b44e9f24c97b4ddd.json\",\"wordpress-seo-es_ES-f9a4f263d05d2bf02927e0f97576f49f.json\",\"wordpress-seo-es_ES-188a17224a5b1b7d950936646679d44c.json\",\"wordpress-seo-es_ES-8d711d3adba936f10d7b5753931a9db1.json\",\"wordpress-seo-es_ES-588361e412aa3f185e103ad7e8f2d93c.json\",\"wordpress-seo-es_ES-73f645d2b957bbd8b1247675cf11a9f5.json\",\"wordpress-seo-es_ES-02cd8292a0dac2e9475423d6455a13f3.json\",\"wordpress-seo-es_ES-7ed5c62c86764068cb2d480ebee9e7d8.json\",\"wordpress-seo-es_ES-a287a551d351044ba55c0faaf0b6f708.json\",\"wordpress-seo-es_ES-f67afac6c2f40e26c26b8d8c7ee7a906.json\",\"wordpress-seo-es_ES-c27995ed2b47142ac213a4c949d83e3a.json\",\"wordpress-seo-es_ES-93f20e0009ce5139eb4d18a512f1c06c.json\",\"wordpress-seo-es_ES-3da4347ba3de6465f476ed722a0160a5.json\",\"wordpress-seo-es_ES-3b9b5f1953052e4023128fddef79d981.json\",\"wordpress-seo-es_ES-9d961bbf3cbb76dd3bdda751e24d1724.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wp-smushit\",\"slug\":\"wp-smushit\",\"plugin\":\"wp-smushit\\/wp-smush.php\",\"new_version\":\"3.8.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-smushit\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-256x256.gif?rev=2263432\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-128x128.gif?rev=2263431\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-1544x500.png?rev=1863697\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-772x250.png?rev=1863697\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"3.8.5\"},\"result\":true,\"name\":\"Smush\",\"messages\":[\"Actualizando el plugin: Smush\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.5\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wp-smushit\",\"language\":\"es_ES\",\"version\":\"3.8.7\",\"updated\":\"2021-06-29 17:21:17\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-11NMpy\\/\",\"source_files\":[\"wp-smushit-es_ES-4c1d4f4057e9fe55cac6131666a684af.json\",\"wp-smushit-es_ES.po\",\"wp-smushit-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Smush\",\"messages\":[\"Actualizando las traducciones de Smush (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.6\",\"updated\":\"2021-06-29 08:52:03\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-ullE7P\\/\",\"source_files\":[\"wordpress-seo-es_ES-289842c03126754e6a23eb1db36f395e.json\",\"wordpress-seo-es_ES-aa74e2b01307e27d6aace8c473481828.json\",\"wordpress-seo-es_ES-5f55aea6a1215ab9fa23714c6fed06e8.json\",\"wordpress-seo-es_ES-3d3fb322ac48db62391d821564cfe6f1.json\",\"wordpress-seo-es_ES-16aaaf8c96276dfea20072efe7e0ce06.json\",\"wordpress-seo-es_ES-fd88af3b97dc9e022ab10cf6bd79ff19.json\",\"wordpress-seo-es_ES-c3172bacda9ab4f325fe54d0208af9ff.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-95e5c05a21306582b44e9f24c97b4ddd.json\",\"wordpress-seo-es_ES-f9a4f263d05d2bf02927e0f97576f49f.json\",\"wordpress-seo-es_ES-188a17224a5b1b7d950936646679d44c.json\",\"wordpress-seo-es_ES-8d711d3adba936f10d7b5753931a9db1.json\",\"wordpress-seo-es_ES-588361e412aa3f185e103ad7e8f2d93c.json\",\"wordpress-seo-es_ES-73f645d2b957bbd8b1247675cf11a9f5.json\",\"wordpress-seo-es_ES-02cd8292a0dac2e9475423d6455a13f3.json\",\"wordpress-seo-es_ES-7ed5c62c86764068cb2d480ebee9e7d8.json\",\"wordpress-seo-es_ES-a287a551d351044ba55c0faaf0b6f708.json\",\"wordpress-seo-es_ES-f67afac6c2f40e26c26b8d8c7ee7a906.json\",\"wordpress-seo-es_ES-c27995ed2b47142ac213a4c949d83e3a.json\",\"wordpress-seo-es_ES-93f20e0009ce5139eb4d18a512f1c06c.json\",\"wordpress-seo-es_ES-3da4347ba3de6465f476ed722a0160a5.json\",\"wordpress-seo-es_ES-3b9b5f1953052e4023128fddef79d981.json\",\"wordpress-seo-es_ES-9d961bbf3cbb76dd3bdda751e24d1724.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wp-smushit\",\"slug\":\"wp-smushit\",\"plugin\":\"wp-smushit\\/wp-smush.php\",\"new_version\":\"3.8.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-smushit\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-256x256.gif?rev=2263432\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-128x128.gif?rev=2263431\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-1544x500.png?rev=1863697\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-772x250.png?rev=1863697\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"3.8.5\"},\"result\":true,\"name\":\"Smush\",\"messages\":[\"Actualizando el plugin: Smush\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.5\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wp-smushit\",\"language\":\"es_ES\",\"version\":\"3.8.7\",\"updated\":\"2021-06-29 17:21:17\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-11NMpy\\/\",\"source_files\":[\"wp-smushit-es_ES-4c1d4f4057e9fe55cac6131666a684af.json\",\"wp-smushit-es_ES.po\",\"wp-smushit-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Smush\",\"messages\":[\"Actualizando las traducciones de Smush (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.6\",\"updated\":\"2021-06-29 08:52:03\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-ullE7P\\/\",\"source_files\":[\"wordpress-seo-es_ES-289842c03126754e6a23eb1db36f395e.json\",\"wordpress-seo-es_ES-aa74e2b01307e27d6aace8c473481828.json\",\"wordpress-seo-es_ES-5f55aea6a1215ab9fa23714c6fed06e8.json\",\"wordpress-seo-es_ES-3d3fb322ac48db62391d821564cfe6f1.json\",\"wordpress-seo-es_ES-16aaaf8c96276dfea20072efe7e0ce06.json\",\"wordpress-seo-es_ES-fd88af3b97dc9e022ab10cf6bd79ff19.json\",\"wordpress-seo-es_ES-c3172bacda9ab4f325fe54d0208af9ff.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-95e5c05a21306582b44e9f24c97b4ddd.json\",\"wordpress-seo-es_ES-f9a4f263d05d2bf02927e0f97576f49f.json\",\"wordpress-seo-es_ES-188a17224a5b1b7d950936646679d44c.json\",\"wordpress-seo-es_ES-8d711d3adba936f10d7b5753931a9db1.json\",\"wordpress-seo-es_ES-588361e412aa3f185e103ad7e8f2d93c.json\",\"wordpress-seo-es_ES-73f645d2b957bbd8b1247675cf11a9f5.json\",\"wordpress-seo-es_ES-02cd8292a0dac2e9475423d6455a13f3.json\",\"wordpress-seo-es_ES-7ed5c62c86764068cb2d480ebee9e7d8.json\",\"wordpress-seo-es_ES-a287a551d351044ba55c0faaf0b6f708.json\",\"wordpress-seo-es_ES-f67afac6c2f40e26c26b8d8c7ee7a906.json\",\"wordpress-seo-es_ES-c27995ed2b47142ac213a4c949d83e3a.json\",\"wordpress-seo-es_ES-93f20e0009ce5139eb4d18a512f1c06c.json\",\"wordpress-seo-es_ES-3da4347ba3de6465f476ed722a0160a5.json\",\"wordpress-seo-es_ES-3b9b5f1953052e4023128fddef79d981.json\",\"wordpress-seo-es_ES-9d961bbf3cbb76dd3bdda751e24d1724.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("836", "0", "Yoast SEO", "plugin", "16.5", "16.6", "automatic", "1", "2021-06-30 11:40:29", "Actualizando el plugin: Yoast SEO\n\r\n\rDescargando la actualización desde https://downloads.wordpress.org/plugin/wordpress-seo.16.6.zip\n\r\n\rDescomprimiendo la actualización\n\r\n\rInstalando la última versión\n\r\n\rActivando el modo de mantenimiento\n\r\n\rEliminando la versión antigua del plugin\n\r\n\rDesactivando el modo de mantenimiento\n\r\n\rEl plugin se ha actualizado correctamente.\n\r\n\r", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wp-smushit\",\"slug\":\"wp-smushit\",\"plugin\":\"wp-smushit\\/wp-smush.php\",\"new_version\":\"3.8.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-smushit\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-256x256.gif?rev=2263432\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-128x128.gif?rev=2263431\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-1544x500.png?rev=1863697\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-772x250.png?rev=1863697\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"3.8.5\"},\"result\":true,\"name\":\"Smush\",\"messages\":[\"Actualizando el plugin: Smush\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.5\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wp-smushit\",\"language\":\"es_ES\",\"version\":\"3.8.7\",\"updated\":\"2021-06-29 17:21:17\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-11NMpy\\/\",\"source_files\":[\"wp-smushit-es_ES-4c1d4f4057e9fe55cac6131666a684af.json\",\"wp-smushit-es_ES.po\",\"wp-smushit-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Smush\",\"messages\":[\"Actualizando las traducciones de Smush (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.6\",\"updated\":\"2021-06-29 08:52:03\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-ullE7P\\/\",\"source_files\":[\"wordpress-seo-es_ES-289842c03126754e6a23eb1db36f395e.json\",\"wordpress-seo-es_ES-aa74e2b01307e27d6aace8c473481828.json\",\"wordpress-seo-es_ES-5f55aea6a1215ab9fa23714c6fed06e8.json\",\"wordpress-seo-es_ES-3d3fb322ac48db62391d821564cfe6f1.json\",\"wordpress-seo-es_ES-16aaaf8c96276dfea20072efe7e0ce06.json\",\"wordpress-seo-es_ES-fd88af3b97dc9e022ab10cf6bd79ff19.json\",\"wordpress-seo-es_ES-c3172bacda9ab4f325fe54d0208af9ff.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-95e5c05a21306582b44e9f24c97b4ddd.json\",\"wordpress-seo-es_ES-f9a4f263d05d2bf02927e0f97576f49f.json\",\"wordpress-seo-es_ES-188a17224a5b1b7d950936646679d44c.json\",\"wordpress-seo-es_ES-8d711d3adba936f10d7b5753931a9db1.json\",\"wordpress-seo-es_ES-588361e412aa3f185e103ad7e8f2d93c.json\",\"wordpress-seo-es_ES-73f645d2b957bbd8b1247675cf11a9f5.json\",\"wordpress-seo-es_ES-02cd8292a0dac2e9475423d6455a13f3.json\",\"wordpress-seo-es_ES-7ed5c62c86764068cb2d480ebee9e7d8.json\",\"wordpress-seo-es_ES-a287a551d351044ba55c0faaf0b6f708.json\",\"wordpress-seo-es_ES-f67afac6c2f40e26c26b8d8c7ee7a906.json\",\"wordpress-seo-es_ES-c27995ed2b47142ac213a4c949d83e3a.json\",\"wordpress-seo-es_ES-93f20e0009ce5139eb4d18a512f1c06c.json\",\"wordpress-seo-es_ES-3da4347ba3de6465f476ed722a0160a5.json\",\"wordpress-seo-es_ES-3b9b5f1953052e4023128fddef79d981.json\",\"wordpress-seo-es_ES-9d961bbf3cbb76dd3bdda751e24d1724.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wp-smushit\",\"slug\":\"wp-smushit\",\"plugin\":\"wp-smushit\\/wp-smush.php\",\"new_version\":\"3.8.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-smushit\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-256x256.gif?rev=2263432\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-128x128.gif?rev=2263431\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-1544x500.png?rev=1863697\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-772x250.png?rev=1863697\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"3.8.5\"},\"result\":true,\"name\":\"Smush\",\"messages\":[\"Actualizando el plugin: Smush\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.5\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wp-smushit\",\"language\":\"es_ES\",\"version\":\"3.8.7\",\"updated\":\"2021-06-29 17:21:17\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-11NMpy\\/\",\"source_files\":[\"wp-smushit-es_ES-4c1d4f4057e9fe55cac6131666a684af.json\",\"wp-smushit-es_ES.po\",\"wp-smushit-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Smush\",\"messages\":[\"Actualizando las traducciones de Smush (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.6\",\"updated\":\"2021-06-29 08:52:03\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-ullE7P\\/\",\"source_files\":[\"wordpress-seo-es_ES-289842c03126754e6a23eb1db36f395e.json\",\"wordpress-seo-es_ES-aa74e2b01307e27d6aace8c473481828.json\",\"wordpress-seo-es_ES-5f55aea6a1215ab9fa23714c6fed06e8.json\",\"wordpress-seo-es_ES-3d3fb322ac48db62391d821564cfe6f1.json\",\"wordpress-seo-es_ES-16aaaf8c96276dfea20072efe7e0ce06.json\",\"wordpress-seo-es_ES-fd88af3b97dc9e022ab10cf6bd79ff19.json\",\"wordpress-seo-es_ES-c3172bacda9ab4f325fe54d0208af9ff.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-95e5c05a21306582b44e9f24c97b4ddd.json\",\"wordpress-seo-es_ES-f9a4f263d05d2bf02927e0f97576f49f.json\",\"wordpress-seo-es_ES-188a17224a5b1b7d950936646679d44c.json\",\"wordpress-seo-es_ES-8d711d3adba936f10d7b5753931a9db1.json\",\"wordpress-seo-es_ES-588361e412aa3f185e103ad7e8f2d93c.json\",\"wordpress-seo-es_ES-73f645d2b957bbd8b1247675cf11a9f5.json\",\"wordpress-seo-es_ES-02cd8292a0dac2e9475423d6455a13f3.json\",\"wordpress-seo-es_ES-7ed5c62c86764068cb2d480ebee9e7d8.json\",\"wordpress-seo-es_ES-a287a551d351044ba55c0faaf0b6f708.json\",\"wordpress-seo-es_ES-f67afac6c2f40e26c26b8d8c7ee7a906.json\",\"wordpress-seo-es_ES-c27995ed2b47142ac213a4c949d83e3a.json\",\"wordpress-seo-es_ES-93f20e0009ce5139eb4d18a512f1c06c.json\",\"wordpress-seo-es_ES-3da4347ba3de6465f476ed722a0160a5.json\",\"wordpress-seo-es_ES-3b9b5f1953052e4023128fddef79d981.json\",\"wordpress-seo-es_ES-9d961bbf3cbb76dd3bdda751e24d1724.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wp-smushit\",\"slug\":\"wp-smushit\",\"plugin\":\"wp-smushit\\/wp-smush.php\",\"new_version\":\"3.8.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-smushit\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-256x256.gif?rev=2263432\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-128x128.gif?rev=2263431\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-1544x500.png?rev=1863697\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-772x250.png?rev=1863697\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"3.8.5\"},\"result\":true,\"name\":\"Smush\",\"messages\":[\"Actualizando el plugin: Smush\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.5\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wp-smushit\",\"language\":\"es_ES\",\"version\":\"3.8.7\",\"updated\":\"2021-06-29 17:21:17\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-11NMpy\\/\",\"source_files\":[\"wp-smushit-es_ES-4c1d4f4057e9fe55cac6131666a684af.json\",\"wp-smushit-es_ES.po\",\"wp-smushit-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Smush\",\"messages\":[\"Actualizando las traducciones de Smush (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.6\",\"updated\":\"2021-06-29 08:52:03\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-ullE7P\\/\",\"source_files\":[\"wordpress-seo-es_ES-289842c03126754e6a23eb1db36f395e.json\",\"wordpress-seo-es_ES-aa74e2b01307e27d6aace8c473481828.json\",\"wordpress-seo-es_ES-5f55aea6a1215ab9fa23714c6fed06e8.json\",\"wordpress-seo-es_ES-3d3fb322ac48db62391d821564cfe6f1.json\",\"wordpress-seo-es_ES-16aaaf8c96276dfea20072efe7e0ce06.json\",\"wordpress-seo-es_ES-fd88af3b97dc9e022ab10cf6bd79ff19.json\",\"wordpress-seo-es_ES-c3172bacda9ab4f325fe54d0208af9ff.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-95e5c05a21306582b44e9f24c97b4ddd.json\",\"wordpress-seo-es_ES-f9a4f263d05d2bf02927e0f97576f49f.json\",\"wordpress-seo-es_ES-188a17224a5b1b7d950936646679d44c.json\",\"wordpress-seo-es_ES-8d711d3adba936f10d7b5753931a9db1.json\",\"wordpress-seo-es_ES-588361e412aa3f185e103ad7e8f2d93c.json\",\"wordpress-seo-es_ES-73f645d2b957bbd8b1247675cf11a9f5.json\",\"wordpress-seo-es_ES-02cd8292a0dac2e9475423d6455a13f3.json\",\"wordpress-seo-es_ES-7ed5c62c86764068cb2d480ebee9e7d8.json\",\"wordpress-seo-es_ES-a287a551d351044ba55c0faaf0b6f708.json\",\"wordpress-seo-es_ES-f67afac6c2f40e26c26b8d8c7ee7a906.json\",\"wordpress-seo-es_ES-c27995ed2b47142ac213a4c949d83e3a.json\",\"wordpress-seo-es_ES-93f20e0009ce5139eb4d18a512f1c06c.json\",\"wordpress-seo-es_ES-3da4347ba3de6465f476ed722a0160a5.json\",\"wordpress-seo-es_ES-3b9b5f1953052e4023128fddef79d981.json\",\"wordpress-seo-es_ES-9d961bbf3cbb76dd3bdda751e24d1724.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-admin\\/includes\\/class-wp-automatic-updater.php\",\"line\":549,\"function\":\"do_action\",\"args\":[\"automatic_updates_complete\",{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wp-smushit\",\"slug\":\"wp-smushit\",\"plugin\":\"wp-smushit\\/wp-smush.php\",\"new_version\":\"3.8.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-smushit\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-256x256.gif?rev=2263432\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-128x128.gif?rev=2263431\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-1544x500.png?rev=1863697\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-772x250.png?rev=1863697\"},\"banners_rtl\":[],\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"3.8.5\"},\"result\":true,\"name\":\"Smush\",\"messages\":[\"Actualizando el plugin: Smush\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]},{\"item\":{\"id\":\"w.org\\/plugins\\/wordpress-seo\",\"slug\":\"wordpress-seo\",\"plugin\":\"wordpress-seo\\/wp-seo.php\",\"new_version\":\"16.6\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wordpress-seo\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon-256x256.png?rev=2363699\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\",\"svg\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/icon.svg?rev=2363699\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250.png?rev=1843435\"},\"banners_rtl\":{\"2x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-1544x500-rtl.png?rev=1843435\",\"1x\":\"https:\\/\\/ps.w.org\\/wordpress-seo\\/assets\\/banner-772x250-rtl.png?rev=1843435\"},\"tested\":\"5.7.2\",\"requires_php\":\"5.6.20\",\"compatibility\":{},\"current_version\":\"16.5\"},\"result\":true,\"name\":\"Yoast SEO\",\"messages\":[\"Actualizando el plugin: Yoast SEO\",\"Descargando la actualizaci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/plugin\\/wordpress-seo.16.6.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Activando el modo de mantenimiento&#8230;\",\"Eliminando la versi\\u00f3n antigua del plugin&#8230;\",\"Desactivando el modo de mantenimiento&#8230;\",\"El plugin se ha actualizado correctamente.\"]}],\"translation\":[{\"item\":{\"type\":\"plugin\",\"slug\":\"wp-smushit\",\"language\":\"es_ES\",\"version\":\"3.8.7\",\"updated\":\"2021-06-29 17:21:17\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-11NMpy\\/\",\"source_files\":[\"wp-smushit-es_ES-4c1d4f4057e9fe55cac6131666a684af.json\",\"wp-smushit-es_ES.po\",\"wp-smushit-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Smush\",\"messages\":[\"Actualizando las traducciones de Smush (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wp-smushit\\/3.8.7\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]},{\"item\":{\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"language\":\"es_ES\",\"version\":\"16.6\",\"updated\":\"2021-06-29 08:52:03\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip\",\"autoupdate\":true},\"result\":{\"source\":\"\\/home\\/solucion\\/wp\\/wp-content\\/upgrade\\/es_ES-ullE7P\\/\",\"source_files\":[\"wordpress-seo-es_ES-289842c03126754e6a23eb1db36f395e.json\",\"wordpress-seo-es_ES-aa74e2b01307e27d6aace8c473481828.json\",\"wordpress-seo-es_ES-5f55aea6a1215ab9fa23714c6fed06e8.json\",\"wordpress-seo-es_ES-3d3fb322ac48db62391d821564cfe6f1.json\",\"wordpress-seo-es_ES-16aaaf8c96276dfea20072efe7e0ce06.json\",\"wordpress-seo-es_ES-fd88af3b97dc9e022ab10cf6bd79ff19.json\",\"wordpress-seo-es_ES-c3172bacda9ab4f325fe54d0208af9ff.json\",\"wordpress-seo-es_ES.po\",\"wordpress-seo-es_ES-95e5c05a21306582b44e9f24c97b4ddd.json\",\"wordpress-seo-es_ES-f9a4f263d05d2bf02927e0f97576f49f.json\",\"wordpress-seo-es_ES-188a17224a5b1b7d950936646679d44c.json\",\"wordpress-seo-es_ES-8d711d3adba936f10d7b5753931a9db1.json\",\"wordpress-seo-es_ES-588361e412aa3f185e103ad7e8f2d93c.json\",\"wordpress-seo-es_ES-73f645d2b957bbd8b1247675cf11a9f5.json\",\"wordpress-seo-es_ES-02cd8292a0dac2e9475423d6455a13f3.json\",\"wordpress-seo-es_ES-7ed5c62c86764068cb2d480ebee9e7d8.json\",\"wordpress-seo-es_ES-a287a551d351044ba55c0faaf0b6f708.json\",\"wordpress-seo-es_ES-f67afac6c2f40e26c26b8d8c7ee7a906.json\",\"wordpress-seo-es_ES-c27995ed2b47142ac213a4c949d83e3a.json\",\"wordpress-seo-es_ES-93f20e0009ce5139eb4d18a512f1c06c.json\",\"wordpress-seo-es_ES-3da4347ba3de6465f476ed722a0160a5.json\",\"wordpress-seo-es_ES-3b9b5f1953052e4023128fddef79d981.json\",\"wordpress-seo-es_ES-9d961bbf3cbb76dd3bdda751e24d1724.json\",\"wordpress-seo-es_ES.mo\"],\"destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"destination_name\":\"\",\"local_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\",\"remote_destination\":\"\\/home\\/solucion\\/wp\\/wp-content\\/languages\\/plugins\\/\",\"clear_destination\":true},\"name\":\"Traducciones de Yoast SEO\",\"messages\":[\"Actualizando las traducciones de Yoast SEO (es_ES)&#8230;\",\"Descargando la traducci\\u00f3n desde https:\\/\\/downloads.wordpress.org\\/translation\\/plugin\\/wordpress-seo\\/16.6\\/es_ES.zip&#8230;\",\"Descomprimiendo la actualizaci\\u00f3n&#8230;\",\"Instalando la \\u00faltima versi\\u00f3n&#8230;\",\"Eliminando la versi\\u00f3n antigua de la traducci\\u00f3n&#8230;\",\"Traducci\\u00f3n actualizada correctamente.\"]}]}]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/update.php\",\"line\":650,\"function\":\"run\",\"class\":\"WP_Automatic_Updater\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"wp_maybe_auto_update\",\"args\":[\"\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[\"\",[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":484,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[\"\"]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-content\\/plugins\\/stops-core-theme-and-plugin-updates\\/includes\\/MPSUM_Disable_Updates.php\",\"line\":202,\"function\":\"do_action\",\"args\":[\"wp_maybe_auto_update\"]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"maybe_auto_update\",\"class\":\"MPSUM_Disable_Updates\",\"type\":\"->\",\"args\":[]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":316,\"function\":\"apply_filters\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[null,[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/plugin.php\",\"line\":551,\"function\":\"do_action\",\"class\":\"WP_Hook\",\"type\":\"->\",\"args\":[[]]},{\"file\":\"\\/home\\/solucion\\/wp\\/wp-cron.php\",\"line\":138,\"function\":\"do_action_ref_array\",\"args\":[\"wp_update_plugins\",[]]}]");
INSERT INTO `p0aadmzbh8_eum_logs` VALUES("837", "0", "Smush (es_ES)", "translation", "3.8.7", "3.8.7", "automatic", "1", "2021-06-30 11:40:29", "", "[{\"file\":\"\\/home\\/solucion\\/wp\\/wp-includes\\/class-wp-hook.php\",\"line\":292,\"function\":\"automatic_updates\",\"class\":\"MPSUM_Logs\",\"type\":\"->\",\"args\":[{\"plugin\":[{\"item\":{\"id\":\"w.org\\/plugins\\/wp-smushit\",\"slug\":\"wp-smushit\",\"plugin\":\"wp-smushit\\/wp-smush.php\",\"new_version\":\"3.8.7\",\"url\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-smushit\\/\",\"package\":\"https:\\/\\/downloads.wordpress.org\\/plugin\\/wp-smushit.3.8.7.zip\",\"icons\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-256x256.gif?rev=2263432\",\"1x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/icon-128x128.gif?rev=2263431\"},\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/wp-smushit\\/assets\\/banner-1544x500.png?re